/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.timecode;

import com.apple.jingle.leghorn.timecode.Rational;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class SampleRate
implements Comparable<SampleRate>,
Serializable {
    private static final long serialVersionUID = -1634107450298837163L;
    private static final Pattern fromStringPattern = Pattern.compile("([0-9]+)/([0-9:-]+)");
    protected long idealizedRate;
    protected Rational ratioToSeconds;

    public long getIdealizedRate() {
        return this.idealizedRate;
    }

    public Rational getRatioToSeconds() {
        return this.ratioToSeconds;
    }

    public static SampleRate parseSampleRateString(String sampleRateString) {
        return new SampleRate(sampleRateString);
    }

    public SampleRate(String sampleRateString) {
        this(1L, new Rational(1L, 1L));
        Matcher m = fromStringPattern.matcher(sampleRateString);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid sample rate", sampleRateString));
        }
        this.idealizedRate = Long.parseLong(m.group(1));
        this.ratioToSeconds = new Rational(m.group(2));
    }

    public SampleRate(long rate, String ratioString) {
        this(rate, new Rational(ratioString));
    }

    public SampleRate(long rate, Rational ratio) {
        assert (rate >= 0L);
        assert (ratio.denominator() > 0L) : ratio;
        assert (ratio.numerator() > 0L) : ratio;
        this.idealizedRate = rate;
        this.ratioToSeconds = ratio;
    }

    public static SampleRate parseDecimalString(String rateString) {
        BigDecimal rate = new BigDecimal(rateString);
        BigDecimal bigRate = rate.movePointRight(rate.scale());
        return new SampleRate(1L, bigRate + ":" + BigDecimal.ONE.movePointRight(rate.scale()));
    }

    public double exactSampleRate() {
        return (double)this.idealizedRate * this.ratioToSeconds.asDouble();
    }

    @Override
    public int compareTo(@Nonnull SampleRate otherSampleRate) {
        if (this.ratioToSeconds.equals(otherSampleRate.ratioToSeconds)) {
            if (this.idealizedRate == otherSampleRate.idealizedRate) {
                return 0;
            }
            return this.idealizedRate > otherSampleRate.idealizedRate ? 1 : -1;
        }
        return this.exactSampleRate() > otherSampleRate.exactSampleRate() ? 1 : -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SampleRate)) {
            throw new IllegalArgumentException(String.format("Cannot compare an object of type %s with a SampleRate", o.getClass()));
        }
        SampleRate otherRate = (SampleRate)o;
        return this.idealizedRate == otherRate.idealizedRate && this.ratioToSeconds.equals(otherRate.ratioToSeconds) || this.exactSampleRate() == otherRate.exactSampleRate();
    }

    public boolean equalsApproximately(SampleRate otherRate, double epsilon) {
        if (this.idealizedRate == otherRate.idealizedRate && this.ratioToSeconds.equals(otherRate.ratioToSeconds)) {
            return true;
        }
        Double difference = Math.abs(this.exactSampleRate() - otherRate.exactSampleRate());
        return difference <= epsilon;
    }

    public String toString() {
        return String.format("%d/%s", this.idealizedRate, this.ratioToSeconds);
    }
}

