/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.timecode;

import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.QTTextTimeCode;
import com.apple.jingle.leghorn.timecode.Rational;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.leghorn.timecode.TimeCode;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class SMPTETimeCode
implements TimeCode,
Serializable,
Comparable<TimeCode> {
    private static final long serialVersionUID = 4659583567157214255L;
    public static final int MAX_DROP_FRAMES = 1801797;
    protected MediaTime mediaTime;
    protected Mode mode;
    public static SMPTETimeCode UNDEFINED = new SMPTETimeCode();
    public static final Rational ntscFrameRateAdjustment = new Rational(1000L, 1001L);
    public static final Rational ntscFrameRateAdjustmentImprecise = new Rational(999L, 1000L);
    public static final SampleRate ntsc2997 = new SampleRate(30L, ntscFrameRateAdjustment);
    public static final SampleRate atsc23976 = new SampleRate(24L, ntscFrameRateAdjustment);
    public static final SampleRate nonDrop30 = new SampleRate(30L, new Rational(1L, 1L));
    public static final int MAXIMUM_SMPTE_FRAME_RATE = 88;
    public static final String SMPTE_TIMECODE_ONLY_PARSING_PATTERN_GROUP = "^(([+-])?(\\d\\d):(\\d\\d):(\\d\\d)([:;])(\\d\\d))(.(\\d\\d\\d))?$";
    public static final String SMPTE_TIMECODE_PARSING_PATTERN_GROUP = "(([+-])?(\\d\\d):(\\d\\d):(\\d\\d)([:;])(\\d\\d))(.(\\d\\d\\d))?( (\\d+)/(\\d+)(:|\\s+)(\\d+)/(dropNTSC|dropPAL|nonDrop))?";
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_TIMECODE_WITHOUT_MODE = 1;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_SIGN_OPTIONAL = 2;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_HH = 3;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_MM = 4;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_SS = 5;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_FF_MODE = 6;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_FF = 7;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_SF_OPTIONAL = 9;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_PARAMETERS = 10;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_FRATE_FPS = 11;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_FRATE_ADJ_NUM = 12;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_FRATE_ADJ_DEN = 14;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_FRATE_ADJ_SEPARATOR = 13;
    public static final int SMPTE_TIMECODE_PARSING_PATTERN_GROUP_FRATE_MODE = 15;
    private static final Pattern timeCodeParser = Pattern.compile("(([+-])?(\\d\\d):(\\d\\d):(\\d\\d)([:;])(\\d\\d))(.(\\d\\d\\d))?( (\\d+)/(\\d+)(:|\\s+)(\\d+)/(dropNTSC|dropPAL|nonDrop))?");

    @Override
    public MediaTime getMediaTime() {
        if (this == UNDEFINED) {
            return MediaTime.UNDEFINED;
        }
        return this.mediaTime;
    }

    public static SampleRate getDefaultFrameRate() {
        return nonDrop30;
    }

    public static Mode getDefaultSMPTETimeCodeType() {
        return Mode.nonDrop;
    }

    protected SMPTETimeCode() {
    }

    public SMPTETimeCode(SMPTETimeCode timeCode) {
        this.mediaTime = new MediaTime(timeCode.getMediaTime());
        this.mode = timeCode.getMode();
    }

    public SMPTETimeCode(MediaTime time, Mode m) {
        this(time, m, false);
    }

    public SMPTETimeCode(MediaTime time, Mode m, boolean relaxConstaints) {
        this();
        if (time == null) {
            throw new IllegalArgumentException("The time parameter must not be null");
        }
        if (m == null) {
            throw new IllegalArgumentException("The mode parameter must not be null");
        }
        if (!relaxConstaints && time.getRate().getIdealizedRate() > 88L) {
            throw new IllegalArgumentException(String.format("%s is not a valid frame rate in a SMPTE timecode", time.getRate()));
        }
        this.mediaTime = time;
        this.mode = m;
    }

    public static SMPTETimeCode parseMilliseconds(long milliseconds, SampleRate frameRate, Mode mode) {
        MediaTime millis = new MediaTime(milliseconds, new SampleRate(1000L, new Rational(1L, 1L)));
        MediaTime timeInRequestedFrameRate = millis.timeByScalingSampleRate(frameRate);
        return new SMPTETimeCode(timeInRequestedFrameRate, mode);
    }

    @Deprecated
    public static SMPTETimeCode parseTimeCodeWithOperator(String smpteTimeCodeString, SampleRate sampleRate, Mode mode) {
        return SMPTETimeCode.parseTimeCode(smpteTimeCodeString, sampleRate, mode);
    }

    public static SMPTETimeCode parseTimeCode(String smpteTimeCode) {
        Matcher m = timeCodeParser.matcher(smpteTimeCode);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid SMPTETimeCode (according to %s)", smpteTimeCode, timeCodeParser));
        }
        String timeCodeOnly = m.group(1);
        SampleRate frameRate = SMPTETimeCode.getDefaultFrameRate();
        Mode timeCodeType = SMPTETimeCode.getDefaultSMPTETimeCodeType();
        if (m.group(10) != null) {
            int idealizedFrameRate = Integer.parseInt(m.group(11));
            Rational frameRateAdjustment = new Rational(Long.parseLong(m.group(12)), Long.parseLong(m.group(14)));
            timeCodeType = Mode.valueOf(m.group(15));
            frameRate = new SampleRate((long)idealizedFrameRate, frameRateAdjustment);
        }
        return SMPTETimeCode.parseTimeCode(timeCodeOnly, frameRate, timeCodeType);
    }

    public static SMPTETimeCode parseTimeCodeWithSwapFrameMode(String smpteTimeCode, SampleRate frameRate, Mode timeCodeMode) {
        return SMPTETimeCode.parseTimeCode(SMPTETimeCode.swapFrameModeIndicator(smpteTimeCode, timeCodeMode), frameRate, timeCodeMode);
    }

    public static SMPTETimeCode parseTimeCode(String smpteTimeCode, SampleRate frameRate, Mode timeCodeType) {
        Matcher m = timeCodeParser.matcher(smpteTimeCode);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid SMPTETimeCode (according to %s)", smpteTimeCode, timeCodeParser));
        }
        boolean isDropFrameTimeCode = m.group(6).equals(Mode.dropNTSC.getIndicatorString());
        if (isDropFrameTimeCode != timeCodeType.isDrop()) {
            throw new IllegalArgumentException(String.format("DropFrame indicator in %s does not match %s mode", smpteTimeCode, timeCodeType.name()));
        }
        int hh = Integer.parseInt(m.group(3));
        int mm = Integer.parseInt(m.group(4));
        int ss = Integer.parseInt(m.group(5));
        int ff = Integer.parseInt(m.group(7));
        boolean isNegative = "-".equals(m.group(2));
        return SMPTETimeCode.createWithComponents(hh, mm, ss, ff, isNegative, frameRate, timeCodeType);
    }

    public static SMPTETimeCode createWithComponents(int hh, int mm, int ss, int ff, boolean isNegative, SampleRate frameRate, Mode timeCodeType) {
        boolean isDropFrameTimeCode = false;
        switch (timeCodeType) {
            case dropPAL: {
                throw new IllegalArgumentException("We don't yet support dropPAL");
            }
            case dropNTSC: {
                isDropFrameTimeCode = true;
                if (ff != 0 && ff != 1 || ss != 0 || mm % 10 == 0) break;
                throw new IllegalArgumentException(String.format("%s is not valid: in a drop-frame timecode, there is no frame 0 or 1 at seconds :00 -- unless the minutes are evenly divisible by 10", SMPTETimeCode.toSMPTEString(hh, mm, ss, ff, isNegative, timeCodeType)));
            }
        }
        if (hh < 0 || mm < 0 || ss < 0 || ff < 0) {
            throw new IllegalArgumentException(String.format("Illegal negative timecode component %s", SMPTETimeCode.toSMPTEString(hh, mm, ss, ff, isNegative, timeCodeType)));
        }
        if ((long)ff >= frameRate.getIdealizedRate()) {
            throw new IllegalArgumentException(String.format("%s is not valid: %d is larger than the maximum legal frame number %d", SMPTETimeCode.toSMPTEString(hh, mm, ss, ff, isNegative, timeCodeType), ff, frameRate.getIdealizedRate() - 1L));
        }
        if (mm >= 60 || ss >= 60) {
            throw new IllegalArgumentException(String.format("%s is not a legal timecode", SMPTETimeCode.toSMPTEString(hh, mm, ss, ff, isNegative, timeCodeType)));
        }
        long seconds = hh * 60 * 60 + mm * 60 + ss;
        long samples = seconds * frameRate.getIdealizedRate() + (long)ff;
        if (isDropFrameTimeCode) {
            long ten_minutes_in_ticks = frameRate.getIdealizedRate() * 600L;
            long one_minute_in_ticks = frameRate.getIdealizedRate() * 60L;
            long ten_minute_ticks = samples / ten_minutes_in_ticks;
            long one_minute_ticks = (samples - ten_minutes_in_ticks * ten_minute_ticks) / one_minute_in_ticks;
            long frames_to_drop = ten_minute_ticks * 18L + one_minute_ticks * 2L;
            samples -= frames_to_drop;
        }
        if (isNegative) {
            samples *= -1L;
        }
        return new SMPTETimeCode(new MediaTime(samples, frameRate), timeCodeType);
    }

    private long[] asComponents() {
        long nominalFrameRate = this.getMediaTime().getRate().getIdealizedRate();
        long samples = Math.abs(this.getMediaTime().getSampleCount());
        boolean asDropFrame = this.isDropFrame();
        long samplesPerMinute = 60L * nominalFrameRate;
        long samplesPerHour = 60L * samplesPerMinute;
        long hh = samples / samplesPerHour;
        long mm = (samples - hh * samplesPerHour) / samplesPerMinute;
        long ss = (samples - hh * samplesPerHour - mm * samplesPerMinute) / nominalFrameRate;
        long ff = samples - hh * samplesPerHour - mm * samplesPerMinute - ss * nominalFrameRate;
        if (!asDropFrame) {
            return new long[]{hh, mm, ss, ff};
        }
        if (samples > 1801797L) {
            throw new IllegalArgumentException("Unable to calculate drop-frame timecode >= 16:42:00;00");
        }
        long samplesPerTenMinutes = 10L * samplesPerMinute;
        long tenMinuteChunks = samples / samplesPerTenMinutes;
        long oneMinuteChunks = (samples - tenMinuteChunks * samplesPerTenMinutes) / samplesPerMinute;
        long framesToAdd = tenMinuteChunks * 18L + oneMinuteChunks * 2L;
        long nextMinuteDropDistance = samplesPerMinute * oneMinuteChunks + samplesPerMinute + samplesPerTenMinutes * tenMinuteChunks - samples;
        long nextTenMinuteDistance = samplesPerTenMinutes * tenMinuteChunks + samplesPerTenMinutes - samples;
        if (0L < nextMinuteDropDistance && nextMinuteDropDistance <= framesToAdd && nextTenMinuteDistance > framesToAdd) {
            framesToAdd += 2L;
        }
        SMPTETimeCode newTimeCode = new SMPTETimeCode();
        newTimeCode.mediaTime = this.getMediaTime().timeByAdjustingSamples(framesToAdd);
        newTimeCode.mode = Mode.nonDrop;
        return newTimeCode.asComponents();
    }

    public boolean isDropFrame() {
        return this.getMode().isDrop();
    }

    public double getSeconds() {
        return this.getMediaTime().getSeconds();
    }

    @Override
    public long getHoursComponent() {
        return this.asComponents()[0];
    }

    @Override
    public long getMinutesComponent() {
        return this.asComponents()[1];
    }

    @Override
    public long getSecondsComponent() {
        return this.asComponents()[2];
    }

    public long getFramesComponent() {
        return this.asComponents()[3];
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public long getMillisComponent() {
        return (long)((double)(this.getFramesComponent() * 1000L) / this.getMediaTime().getRate().exactSampleRate());
    }

    @Override
    public long getTotalMilliseconds() {
        if (this == UNDEFINED || null == this.mediaTime) {
            return 0L;
        }
        return this.mediaTime.getTotalMilliseconds();
    }

    @Override
    public String toUserString() {
        return this.toSMPTEString();
    }

    @Nonnull
    public String toQtText() {
        long[] components = this.asComponents();
        return String.format("%s%02d:%02d:%02d.%03d", this.getMediaTime().getSampleCount() < 0L ? "-" : "", components[0], components[1], components[2], this.getMillisComponent());
    }

    public String toSMPTEString() {
        long[] components = this.asComponents();
        return SMPTETimeCode.toSMPTEString(components[0], components[1], components[2], components[3], this.getMediaTime().getSampleCount() < 0L, this.getMode());
    }

    private static String toSMPTEString(long hh, long mm, long ss, long ff, boolean isNegative, Mode mode) {
        return (isNegative ? "-" : "") + (hh > 9L ? Long.valueOf(hh) : "0" + hh) + ':' + (mm > 9L ? Long.valueOf(mm) : "0" + mm) + ':' + (ss > 9L ? Long.valueOf(ss) : "0" + ss) + mode.getIndicatorString() + (ff > 9L ? Long.valueOf(ff) : "0" + ff);
    }

    public String toSMPTEParameterizedString() {
        return String.format("%s %s", this.toSMPTEString(), this.getFrameRateFormatString());
    }

    public String getFrameRateFormatString() {
        return String.format("%d/%s/%s", new Object[]{this.mediaTime.rate.getIdealizedRate(), this.mediaTime.rate.getRatioToSeconds(), this.mode});
    }

    public static Mode guessMode(String smpteTimeCodeString) {
        Matcher m = timeCodeParser.matcher(smpteTimeCodeString);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid SMPTETimeCode (according to %s)", smpteTimeCodeString, timeCodeParser));
        }
        if (m.group(10) != null) {
            return Mode.valueOf(m.group(15));
        }
        return m.group(6).equals(Mode.dropNTSC.getIndicatorString()) ? Mode.dropNTSC : Mode.nonDrop;
    }

    public static String swapFrameModeIndicator(String smpteTimeCode, Mode mode) {
        Matcher m = timeCodeParser.matcher(smpteTimeCode);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid SMPTETimeCode (according to %s)", smpteTimeCode, timeCodeParser));
        }
        boolean isNegative = "-".equals(m.group(2));
        long hh = Long.parseLong(m.group(3));
        long mm = Long.parseLong(m.group(4));
        long ss = Long.parseLong(m.group(5));
        long ff = Long.parseLong(m.group(7));
        return String.format("%s%02d:%02d:%02d%s%02d", isNegative ? "-" : "", hh, mm, ss, mode.getIndicatorString(), ff);
    }

    @Override
    public int compareTo(@Nonnull TimeCode smpteTimeCode) {
        return this.getMediaTime().compareTo(smpteTimeCode.getMediaTime());
    }

    public String toString() {
        return this == UNDEFINED ? "undefined" : this.toSMPTEParameterizedString();
    }

    public static boolean isValid(String timecode) {
        return StringUtils.isNotEmpty((CharSequence)timecode) && timeCodeParser.matcher(timecode).matches();
    }

    @Nonnull
    public static SMPTETimeCode parseTimeCode(@Nonnull String timeCode, @Nonnull String timeFormat) {
        if ("qt_text".equals(timeFormat)) {
            QTTextTimeCode qtTime = QTTextTimeCode.parseQTTextString(timeCode);
            return new SMPTETimeCode(qtTime.getMediaTime().timeByScalingSampleRate(SMPTETimeCode.getDefaultFrameRate()), SMPTETimeCode.getDefaultSMPTETimeCodeType());
        }
        return SMPTETimeCode.parseTimeCode(timeCode + " " + timeFormat);
    }

    public static enum Mode {
        dropNTSC(true),
        dropPAL(true),
        nonDrop(false);

        private boolean isDrop;
        private static final boolean DROP = true;
        private static final boolean NONDROP = false;

        private Mode(boolean isDrop) {
            this.isDrop = isDrop;
        }

        public boolean isDrop() {
            return this.isDrop;
        }

        public String getIndicatorString() {
            return this.isDrop() ? ";" : ":";
        }
    }
}

