/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.timecode;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class Rational
implements Comparable<Rational>,
Serializable {
    private static final long serialVersionUID = 4013361081194035896L;
    private long _numerator;
    private long _denominator;
    public static final Rational ONE = new Rational(1L, 1L);
    public static final String rationalStringParsingPattern = "(\\d+)(:|\\s+|-)(\\d+)";
    private static final Pattern rationalStringParser = Pattern.compile("(\\d+)(:|\\s+|-)(\\d+)");

    public long numerator() {
        return this._numerator;
    }

    public long denominator() {
        return this._denominator;
    }

    public static Rational parseRationalString(String rationalString) {
        return new Rational(rationalString);
    }

    public Rational(String rationalString) {
        this(1L, 1L);
        Matcher m = rationalStringParser.matcher(rationalString);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid string representation of a Rational (does not match pattern %s)", rationalString, rationalStringParsingPattern));
        }
        this._numerator = Long.parseLong(m.group(1));
        this._denominator = Long.parseLong(m.group(3));
    }

    public Rational(long numerator, long denominator) {
        assert (0L < denominator) : denominator;
        this._numerator = numerator;
        this._denominator = denominator;
    }

    public static Rational makeRational(long numerator, long denominator) {
        return new Rational(numerator, denominator);
    }

    public Rational reduce() {
        long gcd = Rational.greatestCommonDivisor(this._numerator, this._denominator);
        return new Rational(this._numerator / gcd, this._denominator / gcd);
    }

    public static long greatestCommonDivisor(long a, long b) {
        while (b != 0L) {
            long tmp = b;
            b = a % b;
            a = tmp;
        }
        return a;
    }

    public static long leastCommonMultiple(long a, long b) {
        return a * b / Rational.greatestCommonDivisor(a, b);
    }

    public double asDouble() {
        return (double)this._numerator / (double)this._denominator;
    }

    @Override
    public int compareTo(@Nonnull Rational other) {
        if (this._numerator == other.numerator() && this._denominator == other.denominator()) {
            return 0;
        }
        if (this._denominator == other.denominator()) {
            return this._numerator > other.numerator() ? 1 : -1;
        }
        Rational a = this.reduce();
        Rational b = other.reduce();
        return a.asDouble() > b.asDouble() ? 1 : -1;
    }

    public boolean equal(Object o) {
        if (!(o instanceof Rational)) {
            throw new IllegalArgumentException(String.format("Object of type %s cannot be compared to a Rational", o.getClass()));
        }
        Rational otherRational = (Rational)o;
        if (this._numerator == otherRational._numerator && this._denominator == otherRational._denominator) {
            return true;
        }
        Rational a = this.reduce();
        Rational b = otherRational.reduce();
        return a._numerator == b._numerator && a._denominator == b._denominator;
    }

    public String toString() {
        return String.format("%d:%d", this._numerator, this._denominator);
    }
}

