/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.timecode;

import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.MillisTimeCode;
import com.apple.jingle.leghorn.timecode.TimeCode;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class QTTextTimeCode
implements TimeCode,
Serializable,
Comparable<TimeCode> {
    private static Logger lager = Logger.getLogger(QTTextTimeCode.class);
    private static final long serialVersionUID = 855029996166519258L;
    public static final String QTEXT_TIMECODE_REGEX = "((\\d*):)??((\\d\\d):)?(\\d{2,4})(\\.(\\d{1,3}))?";
    public static final Pattern QTTEXT_TIMECODE = Pattern.compile("((\\d*):)??((\\d\\d):)?(\\d{2,4})(\\.(\\d{1,3}))?");
    protected static final int QTTEXT_HOUR_GROUP = 2;
    protected static final int QTTEXT_MINUTE_GROUP = 4;
    protected static final int QTTEXT_SECOND_GROUP = 5;
    protected static final int QTTEXT_MILLIS_GROUP = 7;
    protected MediaTime mediaTime;
    private long hoursComponent;
    private long minutesComponent;
    private long secondsComponent;
    private long millisComponent;

    private QTTextTimeCode() {
    }

    public QTTextTimeCode(MediaTime mediaTime) {
        this.mediaTime = mediaTime;
        long[] millisToHHMMSSMIComponents = MillisTimeCode.millisToHHMMSSMIComponents((long)(mediaTime.getSeconds() * 1000.0));
        this.hoursComponent = millisToHHMMSSMIComponents[0];
        this.minutesComponent = millisToHHMMSSMIComponents[1];
        this.secondsComponent = millisToHHMMSSMIComponents[2];
        this.millisComponent = millisToHHMMSSMIComponents[3];
    }

    public static QTTextTimeCode parseQTTextString(String timeCodeString) throws IllegalArgumentException {
        if (timeCodeString == null) {
            throw new IllegalArgumentException("timeCodeString is null");
        }
        Matcher matcher = QTTEXT_TIMECODE.matcher(timeCodeString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(timeCodeString + " does not match expected expression " + QTTEXT_TIMECODE.pattern());
        }
        boolean hasOptionals = false;
        QTTextTimeCode timeCode = new QTTextTimeCode();
        long millis = 0L;
        if (matcher.group(2) != null) {
            timeCode.hoursComponent = Long.parseLong(matcher.group(2));
            millis += timeCode.hoursComponent * 3600000L;
            hasOptionals = true;
        }
        if (matcher.group(4) != null) {
            timeCode.minutesComponent = Long.parseLong(matcher.group(4));
            millis += timeCode.minutesComponent * 60000L;
            hasOptionals = true;
        }
        if (matcher.group(5) != null) {
            timeCode.secondsComponent = Long.parseLong(matcher.group(5));
            millis += timeCode.secondsComponent * 1000L;
        }
        if (matcher.group(7) != null) {
            timeCode.millisComponent = Long.parseLong(matcher.group(7));
            millis += timeCode.millisComponent;
        }
        if (hasOptionals && timeCode.secondsComponent > 59L) {
            lager.warn((Object)("Invalid QTText timecode:" + timeCodeString));
        }
        timeCode.mediaTime = new MediaTime(millis, MillisTimeCode.MILLIS_SAMPLE_RATE);
        return timeCode;
    }

    public static boolean isValid(String timeCodeString) {
        if (timeCodeString == null) {
            return false;
        }
        Matcher matcher = QTTEXT_TIMECODE.matcher(timeCodeString);
        if (!matcher.matches()) {
            return false;
        }
        boolean hasOptionals = false;
        if (matcher.group(2) != null) {
            hasOptionals = true;
        }
        if (matcher.group(4) != null) {
            if (Long.parseLong(matcher.group(4)) > 59L) {
                return false;
            }
            hasOptionals = true;
        }
        return matcher.group(5) == null || !hasOptionals || Long.parseLong(matcher.group(5)) <= 59L;
    }

    @Override
    public String toUserString() {
        return this.toQTTextString();
    }

    public String toQTTextString() {
        return String.format("%02d:%02d:%02d.%03d", this.getHoursComponent(), this.getMinutesComponent(), this.getSecondsComponent(), this.getMillisComponent());
    }

    @Override
    public long getHoursComponent() {
        return this.hoursComponent;
    }

    @Override
    public long getMinutesComponent() {
        return this.minutesComponent;
    }

    @Override
    public long getSecondsComponent() {
        return this.secondsComponent;
    }

    @Override
    public long getMillisComponent() {
        return this.millisComponent;
    }

    @Override
    public MediaTime getMediaTime() {
        return this.mediaTime;
    }

    @Override
    public long getTotalMilliseconds() {
        if (this.mediaTime != null && this.mediaTime != MediaTime.UNDEFINED) {
            return this.mediaTime.getTotalMilliseconds();
        }
        return 0L;
    }

    public String toString() {
        return this.toQTTextString();
    }

    @Override
    public int compareTo(TimeCode otherTimeCode) {
        return this.getMediaTime().compareTo(otherTimeCode.getMediaTime());
    }
}

