/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.timecode;

import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.Rational;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.leghorn.timecode.TimeCode;
import java.io.Serializable;

public class MillisTimeCode
implements TimeCode,
Serializable,
Comparable<TimeCode> {
    private static final long serialVersionUID = -2763755682608246932L;
    protected static final long MILLIS_PER_SECOND = 1000L;
    protected static final long MILLIS_PER_MINUTE = 60000L;
    protected static final long MILLIS_PER_HOUR = 3600000L;
    protected MediaTime mediaTime;
    protected long[] components;
    public static final SampleRate MILLIS_SAMPLE_RATE = new SampleRate(1000L, new Rational(1L, 1L));
    public static final int C_HOURS = 0;
    public static final int C_MINUTES = 1;
    public static final int C_SECONDS = 2;
    public static final int C_MILLIS = 3;

    @Override
    public MediaTime getMediaTime() {
        return this.mediaTime;
    }

    public static MillisTimeCode parseMillis(String millis) {
        return MillisTimeCode.parseMillis(Long.parseLong(millis));
    }

    public static MillisTimeCode parseMillis(long millis) {
        MillisTimeCode timeCode = new MillisTimeCode();
        timeCode.components = MillisTimeCode.millisToHHMMSSMIComponents(millis);
        timeCode.mediaTime = new MediaTime(millis, MILLIS_SAMPLE_RATE);
        return timeCode;
    }

    public static long[] millisToHHMMSSMIComponents(long millis) {
        long[] components;
        components = new long[]{millis / 3600000L, (millis -= components[0] * 3600000L) / 60000L, (millis -= components[1] * 60000L) / 1000L, millis -= components[2] * 1000L};
        return components;
    }

    @Override
    public long getHoursComponent() {
        return this.components[0];
    }

    @Override
    public long getMinutesComponent() {
        return this.components[1];
    }

    @Override
    public long getSecondsComponent() {
        return this.components[2];
    }

    @Override
    public long getMillisComponent() {
        return this.components[3];
    }

    @Override
    public long getTotalMilliseconds() {
        if (this.mediaTime != null && this.mediaTime != MediaTime.UNDEFINED) {
            return this.mediaTime.getTotalMilliseconds();
        }
        return 0L;
    }

    @Override
    public String toUserString() {
        return String.format("%d", this.mediaTime.getSampleCount());
    }

    @Override
    public int compareTo(TimeCode otherTimeCode) {
        return this.getMediaTime().compareTo(otherTimeCode.getMediaTime());
    }
}

