/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.timecode;

import com.apple.jingle.leghorn.timecode.Rational;
import com.apple.jingle.leghorn.timecode.SampleRate;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class MediaTime
implements Comparable<MediaTime>,
Serializable {
    private static final long serialVersionUID = 4103995782229494332L;
    protected long sampleCount;
    protected SampleRate rate;
    public static MediaTime UNDEFINED = new MediaTime();

    public long getSampleCount() {
        return this.sampleCount;
    }

    public SampleRate getRate() {
        return this.rate;
    }

    private MediaTime() {
    }

    public MediaTime(long sampleCount, SampleRate rate) {
        this.sampleCount = sampleCount;
        this.rate = rate;
    }

    public MediaTime(long value, long timeScale) {
        this(value, new SampleRate(timeScale, Rational.ONE));
    }

    public MediaTime(MediaTime time) {
        this(time.sampleCount, time.rate);
    }

    public double getSeconds() {
        return (double)this.sampleCount / this.rate.exactSampleRate();
    }

    public long getTotalMilliseconds() {
        return (long)((double)this.sampleCount / this.rate.exactSampleRate() * 1000.0);
    }

    public MediaTime timeByAddingTime(MediaTime otherTime) {
        if (!this.rate.equals(otherTime.rate)) {
            throw new IllegalArgumentException(String.format("Cannot add: %s and %s must be expressed in the same SampleRate", otherTime, this));
        }
        return new MediaTime(this.sampleCount + otherTime.sampleCount, this.rate);
    }

    public MediaTime add(@Nonnull MediaTime otherTime) {
        if (!this.rate.equals(otherTime.rate)) {
            otherTime = otherTime.timeByScalingSampleRate(this.rate);
        }
        return this.timeByAddingTime(otherTime);
    }

    public MediaTime subtract(@Nonnull MediaTime otherTime) {
        if (!this.rate.equals(otherTime.rate)) {
            otherTime = otherTime.timeByScalingSampleRate(this.rate);
        }
        return this.timeBySubtractingTime(otherTime);
    }

    public MediaTime timeBySubtractingTime(MediaTime otherTime) {
        if (!this.rate.equals(otherTime.rate)) {
            throw new IllegalArgumentException(String.format("Cannot subtract: %s and %s must be expressed in the same SampleRate", otherTime, this));
        }
        if (this.sampleCount < otherTime.sampleCount) {
            throw new IllegalArgumentException(String.format("Cannot subtract: %s is larger than %s", otherTime, this));
        }
        return new MediaTime(this.sampleCount - otherTime.sampleCount, this.rate);
    }

    public MediaTime timeByAdjustingSamples(long samplesToAdjust) {
        return samplesToAdjust > 0L ? this.timeByAddingTime(new MediaTime(samplesToAdjust, this.rate)) : this.timeBySubtractingTime(new MediaTime(-1L * samplesToAdjust, this.rate));
    }

    public MediaTime timeByScalingSampleRate(SampleRate newBase) {
        if (newBase.equals(this.rate)) {
            return new MediaTime(this);
        }
        double newRatio = newBase.exactSampleRate() / this.rate.exactSampleRate();
        long newSample = (long)(newRatio * (double)this.sampleCount);
        return new MediaTime(newSample, newBase);
    }

    public MediaTime timeByChangingSampleRate(SampleRate newBase) {
        return new MediaTime(this.sampleCount, newBase);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MediaTime)) {
            throw new IllegalArgumentException(String.format("Cannot compare object of type %s to a MediaTime", o.getClass()));
        }
        MediaTime otherMt = (MediaTime)o;
        if (this.sampleCount == otherMt.sampleCount && this.rate.equals(otherMt.rate)) {
            return true;
        }
        return this.getSeconds() == otherMt.getSeconds();
    }

    @Override
    public int compareTo(MediaTime otherTime) {
        if (otherTime.rate.equals(this.rate)) {
            if (otherTime.sampleCount == this.sampleCount) {
                return 0;
            }
            return this.sampleCount > otherTime.sampleCount ? 1 : -1;
        }
        if (this.getSeconds() == otherTime.getSeconds()) {
            return 0;
        }
        return this.getSeconds() > otherTime.getSeconds() ? 1 : -1;
    }

    public String toString() {
        if (this == UNDEFINED) {
            return "undefined";
        }
        return String.format("%d %s", this.sampleCount, this.rate);
    }
}

