/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.timecode;

import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.Rational;
import com.apple.jingle.leghorn.timecode.SampleRate;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class CMTime
implements Comparable<CMTime>,
Serializable {
    private static final long serialVersionUID = 218726859208048107L;
    private final Rational _value;
    public static final CMTime ZERO = new CMTime(0L, 1L);

    public CMTime(long value, long timeScale) {
        this(new Rational(value, timeScale));
    }

    public CMTime(Rational r) {
        this._value = r;
    }

    public long getTimeValue() {
        return this._value.numerator();
    }

    public long getTimeScale() {
        return this._value.denominator();
    }

    public double asSeconds() {
        return this._value.asDouble();
    }

    public long asMilliSeconds() {
        return (long)(this._value.asDouble() * 1000.0);
    }

    public long asMilliSecondsRoundUp() {
        return (long)Math.ceil(this._value.asDouble() * 1000.0);
    }

    public CMTime add(CMTime t) {
        if (this._value.denominator() == t._value.denominator()) {
            return new CMTime(this._value.numerator() + t._value.numerator(), this._value.denominator());
        }
        long lcm = Rational.leastCommonMultiple(this._value.denominator(), t._value.denominator());
        long v1 = this._value.numerator() * (lcm / this._value.denominator());
        long v2 = t._value.numerator() * (lcm / t._value.denominator());
        return new CMTime(Rational.makeRational(v1 + v2, lcm));
    }

    public CMTime subtract(CMTime subtrahend) {
        if (this._value.denominator() == subtrahend._value.denominator()) {
            return new CMTime(this._value.numerator() - subtrahend._value.numerator(), this._value.denominator());
        }
        long lcm = Rational.leastCommonMultiple(this._value.denominator(), subtrahend._value.denominator());
        long v1 = this._value.numerator() * (lcm / this._value.denominator());
        long v2 = subtrahend._value.numerator() * (lcm / subtrahend._value.denominator());
        return new CMTime(Rational.makeRational(v1 + v2, lcm).reduce());
    }

    public CMTime MakeTimeWithNewScale(long newScale) {
        if (this._value.denominator() == newScale) {
            return new CMTime(this._value);
        }
        long lcm = Rational.leastCommonMultiple(this._value.denominator(), newScale);
        long v1 = this._value.numerator() * (lcm / this._value.denominator());
        return new CMTime(Rational.makeRational(v1, lcm));
    }

    @Nonnull
    public static CMTime fromMediaTime(@Nonnull MediaTime mediaTime) {
        SampleRate samplerate = mediaTime.getRate();
        long sampleCount = mediaTime.getSampleCount();
        return new CMTime(new Rational(sampleCount * samplerate.getRatioToSeconds().denominator(), samplerate.idealizedRate * samplerate.getRatioToSeconds().numerator()).reduce());
    }

    public CMTime fromMediaTimeStrict(MediaTime mediaTime) {
        SampleRate samplerate = mediaTime.getRate();
        long sampleCount = mediaTime.getSampleCount();
        if (samplerate.getRatioToSeconds().asDouble() != 1.0) {
            throw new IllegalArgumentException("Expects the ratio of samples to seconds to be 1.");
        }
        return new CMTime(Rational.makeRational(sampleCount, samplerate.getIdealizedRate()).reduce());
    }

    public CMTime makeReduced() {
        return new CMTime(this._value.reduce());
    }

    public String toString() {
        return String.format("%d/%d", this._value.numerator(), this._value.denominator());
    }

    @Override
    public int compareTo(CMTime o) {
        return this.asSeconds() > o.asSeconds() ? 1 : -1;
    }
}

