/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import com.apple.jingle.leghorn.subtitle.webvtt.ReadableAsset;
import com.apple.jingle.leghorn.subtitle.webvtt.StyledString;
import com.apple.jingle.leghorn.subtitle.webvtt.SubtitleConvertException;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLColorMapper;
import com.apple.jingle.leghorn.subtitle.webvtt.TextElement;
import com.apple.jingle.leghorn.subtitle.webvtt.ittRegion;
import com.apple.jingle.leghorn.subtitle.webvtt.ittStyle;
import com.apple.jingle.leghorn.subtitle.webvtt.subtitlesExporter;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.Rational;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.ISO639_2Code;
import com.apple.jingle.locale.LanguageTag;
import com.google.common.base.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;

public class texmlExporter
implements subtitlesExporter {
    private long _outputWidth = 0L;
    private long _outputHeight = 0L;
    private boolean _allForced = false;
    private boolean _overideRegionInformation = true;
    private boolean _collapseEmptySubtitles = true;
    private boolean _endOnEmptySubtitles = false;
    private static final long LAST_EMPTY_DURATION_IN_FRAMES = 4L;
    private static final String NUMBER_TUPLE_PERCENTAGE = "([0-9]+)%\\s+([0-9]+)%";
    private static Pattern numberTuplePercentPattern = Pattern.compile("([0-9]+)%\\s+([0-9]+)%");
    private static final String FRAMERATE_MUL_REGEX = "([0-9]+)\\s+([0-9]+)";
    private static Pattern frameRateMulPattern = Pattern.compile("([0-9]+)\\s+([0-9]+)");

    @Override
    public void setOutputDimensions(long w, long h) {
        this._outputWidth = w;
        this._outputHeight = h;
    }

    public void setAllForced(boolean enable) {
        this._allForced = enable;
    }

    public void setCollapseEmptySubtitles(boolean enable) {
        this._collapseEmptySubtitles = enable;
    }

    public void setEndOnEmptySubtitles(boolean enable) {
        this._endOnEmptySubtitles = enable;
    }

    private boolean isTopRegion(String regionName, ReadableAsset asset) {
        return "top".compareToIgnoreCase(regionName) == 0;
    }

    private double[] parseNumberTuple(String s) throws SubtitleConvertException {
        Matcher m = numberTuplePercentPattern.matcher(s.trim());
        if (!m.matches()) {
            throw new SubtitleConvertException("INvalid number format:" + s);
        }
        return new double[]{Double.parseDouble(m.group(1)), Double.parseDouble(m.group(2))};
    }

    private rectangle createTextBox(String regionName, ReadableAsset asset) throws SubtitleConvertException {
        rectangle r = new rectangle();
        if (this._overideRegionInformation) {
            r._h = Math.round((double)this._outputHeight * 0.15);
            r._w = this._outputWidth;
            if (asset.hasTopPositionSubtitles()) {
                r._y = this._outputHeight - r._h;
                if (this.isTopRegion(regionName, asset)) {
                    r._y = 0L;
                }
            }
        } else {
            ittRegion region = asset.region(regionName);
            if (region == null) {
                throw new SubtitleConvertException("Undefined region:" + regionName);
            }
            double[] extendTuple = this.parseNumberTuple(region._style._extent);
            r._w = Math.round((double)this._outputWidth * extendTuple[0]);
            r._h = Math.round((double)this._outputHeight * extendTuple[1]);
            r._x = Math.round((double)this._outputWidth * extendTuple[0]);
            r._y = Math.round((double)this._outputHeight * extendTuple[1]);
        }
        return r;
    }

    @Override
    public boolean export(ReadableAsset asset, File dst) throws SubtitleConvertException, IOException {
        if (asset == null) {
            throw new SubtitleConvertException("ReadableAsset is null");
        }
        asset.applyTimeOffset();
        BufferedWriter bw = null;
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(dst), "UTF-8");
            bw = new BufferedWriter(fw);
            XMLOutputFactory output = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = output.createXMLStreamWriter(bw);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeProcessingInstruction("quicktime", "type=\"application/x-quicktime-sbtl\"");
            writer.writeStartElement("subtitleTrack");
            LanguageTag docLangTag = null;
            if (asset.attribute("lang") != null) {
                String langTag = "unk";
                langTag = (String)asset.attribute("lang");
                try {
                    docLangTag = BCP47TagSupport.createTag((String)langTag);
                }
                catch (BCP47TagParseException ex) {
                    // empty catch block
                }
                if (docLangTag == null) {
                    try {
                        docLangTag = ISO639_2Code.getBCP47TagForISO639Tag((String)langTag);
                    }
                    catch (BCP47TagParseException ex) {
                        // empty catch block
                    }
                }
                if (docLangTag == null) {
                    docLangTag = BCP47TagSupport.ENGLISH_US;
                }
            }
            BigInteger docFrameRate = (BigInteger)asset.attribute("frameRate");
            String docFrameRateMultiplier = (String)asset.attribute("frameRateMultiplier");
            SampleRate outputSampleRate = this.computeFrameRate(docFrameRate, docFrameRateMultiplier);
            writer.writeAttribute("language", docLangTag.getValue());
            writer.writeAttribute("layer", "0");
            if (asset.hasTopPositionSubtitles()) {
                writer.writeAttribute("trackHeight", String.valueOf(this._outputHeight));
                writer.writeAttribute("trackWidth", String.valueOf(this._outputWidth));
            } else {
                writer.writeAttribute("trackHeight", String.valueOf((int)Math.round((double)this._outputHeight * 0.15)));
                writer.writeAttribute("trackWidth", String.valueOf(this._outputWidth));
            }
            writer.writeAttribute("timeScale", String.valueOf(outputSampleRate.getIdealizedRate()));
            if (asset.textElementCount() > 0) {
                MediaTime lastEndTime = new MediaTime(0L, asset.textElement(0).showTime().getMediaTime().getRate());
                for (TextElement e : asset) {
                    if (this._collapseEmptySubtitles && e.isEmpty()) continue;
                    MediaTime showTime = e.showTime().getMediaTime();
                    MediaTime timeDiff = showTime.timeBySubtractingTime(lastEndTime);
                    if (timeDiff.getSampleCount() > 0L) {
                        this.addEmptySample(writer, timeDiff, outputSampleRate, asset);
                    }
                    MediaTime duration = e.duration().timeByScalingSampleRate(outputSampleRate);
                    writer.writeStartElement("sample");
                    writer.writeAttribute("duration", String.valueOf(duration.getSampleCount() * outputSampleRate.getRatioToSeconds().denominator()));
                    writer.writeAttribute("keyFrame", "true");
                    writer.writeAttribute("forced", this._allForced ? "true" : "false");
                    writer.writeStartElement("description");
                    writer.writeAttribute("backgroundColor", "0%, 0%, 0%, 0%");
                    writer.writeAttribute("format", "tx3g");
                    writer.writeAttribute("horizontalJustification", "Center");
                    writer.writeAttribute("verticalJustification", "Bottom");
                    if (asset.hasTopPositionSubtitles()) {
                        writer.writeAttribute("displayFlags", "obey");
                    }
                    rectangle defTextBox = this.createTextBox(e.regions()[0], asset);
                    writer.writeStartElement("defaultTextBox");
                    writer.writeAttribute("x", String.valueOf(defTextBox._x));
                    writer.writeAttribute("y", String.valueOf(defTextBox._y));
                    writer.writeAttribute("width", String.valueOf(defTextBox._w));
                    writer.writeAttribute("height", String.valueOf(defTextBox._h));
                    writer.writeEndElement();
                    writer.writeStartElement("fontTable");
                    writer.writeStartElement("font");
                    writer.writeAttribute("id", "1");
                    writer.writeAttribute("name", "Sans-Serif");
                    writer.writeEndElement();
                    writer.writeEndElement();
                    writer.writeStartElement("sharedStyles");
                    this.writeStyles(writer, e, asset);
                    writer.writeEndElement();
                    writer.writeEndElement();
                    writer.writeStartElement("sampleData");
                    writer.writeAttribute("targetEncoding", "utf8");
                    for (StyledString ss : e) {
                        this.writeText(writer, ss, e);
                    }
                    writer.writeEndElement();
                    writer.writeEndElement();
                    lastEndTime = new MediaTime(e.hideTime().getMediaTime());
                }
            }
            if (this._endOnEmptySubtitles) {
                this.addEmptySample(writer, new MediaTime(4L, outputSampleRate), outputSampleRate, asset);
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException ex) {
            try {
                throw new SubtitleConvertException("There was a XmlStream problem while writing:" + dst, ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)bw);
        return true;
    }

    private void writeText(XMLStreamWriter writer, StyledString ss, TextElement te) throws XMLStreamException {
        writer.writeStartElement("text");
        writer.writeAttribute("styleID", String.valueOf(te.styleToIdx(ss.styleName())));
        writer.writeCharacters(texmlExporter.sanitizeString(ss.export()));
        writer.writeEndElement();
    }

    private void writeStyles(XMLStreamWriter writer, TextElement te, ReadableAsset asset) throws XMLStreamException {
        for (String styleName : te.styles()) {
            writer.writeStartElement("style");
            writer.writeAttribute("id", String.valueOf(te.styleToIdx(styleName)));
            String styleString = this.buildStyleString(asset, styleName, this._outputHeight, false);
            writer.writeCharacters(styleString);
            writer.writeEndElement();
        }
    }

    static String sanitizeString(String dirty) {
        return dirty;
    }

    private Rational approximateDoubleWithRational(double value, long maxDen) {
        long ai;
        long[][] m = new long[2][2];
        double startx = value;
        double x = value;
        m[1][1] = 1L;
        m[0][0] = 1L;
        m[1][0] = 0L;
        m[0][1] = 0L;
        while (m[1][0] * (ai = (long)x) + m[1][1] <= maxDen) {
            long t = m[0][0] * ai + m[0][1];
            m[0][1] = m[0][0];
            m[0][0] = t;
            t = m[1][0] * ai + m[1][1];
            m[1][1] = m[1][0];
            m[1][0] = t;
            if (x != (double)ai && !((x = 1.0 / (x - (double)ai)) > 2.147483647E9)) continue;
            break;
        }
        Rational r1 = new Rational(m[0][0], m[1][0]);
        double r1error = startx - r1.asDouble();
        ai = (maxDen - m[1][1]) / m[1][0];
        m[0][0] = m[0][0] * ai + m[0][1];
        m[1][0] = m[1][0] * ai + m[1][1];
        Rational r2 = new Rational(m[0][0], m[1][0]);
        double r2error = startx - r2.asDouble();
        if (Math.abs(r1error) < Math.abs(r2error)) {
            return r1;
        }
        return r2;
    }

    private SampleRate computeFrameRate(BigInteger baseRate, String rateMultiplier) {
        Matcher m = frameRateMulPattern.matcher(rateMultiplier);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal frame rate multiplier expression:" + rateMultiplier);
        }
        long num = Long.parseLong(m.group(1));
        long den = Long.parseLong(m.group(2));
        double floatSampleRate = (double)(baseRate.longValue() * num) / (double)den;
        Rational rationalAprox = this.approximateDoubleWithRational(floatSampleRate, 10000L);
        return new SampleRate(rationalAprox.numerator(), new Rational(1L, rationalAprox.denominator()));
    }

    private String buildStyleString(ReadableAsset asset, String styleName, long trackHeight, boolean isBlank) {
        ittStyle e = asset.style(styleName);
        String colorString = TTMLColorMapper.ColorStringToPercentString(e._color);
        int fontSize = (int)Math.round((double)trackHeight * 0.15 / 3.0);
        if (asset.hasTopPositionSubtitles()) {
            fontSize = (int)Math.round((double)trackHeight / 3.0);
        }
        String fontWeight = isBlank ? "normal" : e._fontWeight;
        String fontStyle = isBlank ? "normal" : e._fontStyle;
        return String.format("{font-table: 1} {font-size: %d} {font-style: %s} {font-weight: %s} {color: %s}", fontSize, fontStyle, fontWeight, colorString);
    }

    private void addEmptySample(XMLStreamWriter writer, MediaTime duration, SampleRate outputRate, ReadableAsset asset) throws XMLStreamException, SubtitleConvertException {
        String computedStyle;
        writer.writeStartElement("sample");
        writer.writeAttribute("duration", String.valueOf(duration.getSampleCount() * outputRate.getRatioToSeconds().denominator()));
        writer.writeAttribute("keyFrame", "true");
        writer.writeAttribute("forced", this._allForced ? "true" : "false");
        writer.writeStartElement("description");
        writer.writeAttribute("backgroundColor", "0%, 0%, 0%, 0%");
        writer.writeAttribute("format", "tx3g");
        writer.writeAttribute("horizontalJustification", "Center");
        writer.writeAttribute("verticalJustification", "Bottom");
        if (asset.hasTopPositionSubtitles()) {
            writer.writeAttribute("displayFlags", "obey");
        }
        String defaultRegion = asset.getDefaultRegionName();
        rectangle defTextBox = this.createTextBox(defaultRegion, asset);
        writer.writeStartElement("defaultTextBox");
        writer.writeAttribute("x", String.valueOf(defTextBox._x));
        writer.writeAttribute("y", String.valueOf(defTextBox._y));
        writer.writeAttribute("width", String.valueOf(defTextBox._w));
        writer.writeAttribute("height", String.valueOf(defTextBox._h));
        writer.writeEndElement();
        writer.writeStartElement("fontTable");
        writer.writeStartElement("font");
        writer.writeAttribute("id", "1");
        writer.writeAttribute("name", "Sans-Serif");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("sharedStyles");
        writer.writeStartElement("style");
        writer.writeAttribute("id", "1");
        String styleString = "{font-table: 1} {font-size: 24} {font-style: normal} {font-weight: normal} {color: 100%, 100%, 100%, 100%}";
        String styleName = (String)asset.attribute("style");
        if (!Strings.isNullOrEmpty((String)styleName) && !Strings.isNullOrEmpty((String)(computedStyle = this.buildStyleString(asset, styleName, this._outputHeight, true)))) {
            styleString = computedStyle;
        }
        writer.writeCharacters(styleString);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("sampleData");
        writer.writeAttribute("targetEncoding", "utf8");
        writer.writeStartElement("text");
        writer.writeAttribute("styleID", "1");
        writer.writeCharacters("");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public class rectangle {
        public long _x;
        public long _y;
        public long _w;
        public long _h;

        public rectangle(long t, long b, long w, long h) {
            this._x = t;
            this._y = b;
            this._w = w;
            this._h = h;
        }

        public rectangle() {
            this._h = 0L;
            this._w = 0L;
            this._y = 0L;
            this._x = 0L;
        }
    }
}

