/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.subtitle.SubtitleSMPTEException;
import com.apple.jingle.leghorn.subtitle.SubtitleSMPTETimeCode;
import com.apple.jingle.leghorn.subtitle.SubtitleSummary;
import com.apple.jingle.leghorn.subtitle.webvtt.PopulateTextElementStrategy;
import com.apple.jingle.leghorn.subtitle.webvtt.ReadableAsset;
import com.apple.jingle.leghorn.subtitle.webvtt.StyledString;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLBeansEnumMapper;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.ParagraphParser;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.TTMLCursorAdaptor;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.TTMLException;
import com.apple.jingle.leghorn.subtitle.webvtt.TextElement;
import com.apple.jingle.leghorn.subtitle.webvtt.ValidationErrorList;
import com.apple.jingle.leghorn.subtitle.webvtt.ittRegion;
import com.apple.jingle.leghorn.subtitle.webvtt.ittStyle;
import com.apple.jingle.leghorn.subtitle.webvtt.subtitlesImporter;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.w3.ns.ttml.BodyEltype;
import org.w3.ns.ttml.DivEltype;
import org.w3.ns.ttml.HeadEltype;
import org.w3.ns.ttml.LayoutEltype;
import org.w3.ns.ttml.PEltype;
import org.w3.ns.ttml.RegionEltype;
import org.w3.ns.ttml.StyleEltype;
import org.w3.ns.ttml.StylingEltype;
import org.w3.ns.ttml.TtDocument;
import org.w3.ns.ttml.TtEltype;

public class ittImporterXMLBeans
implements subtitlesImporter {
    private static final Logger logger = Logger.getLogger(ittImporterXMLBeans.class);
    private BigInteger _docframeRate;
    private SMPTETimeCode.Mode _docTmcdMode;
    private SampleRate _docTmcdSampleRate;
    private boolean _verbose = false;
    private Stack<String> _styleStack = new Stack();
    private Stack<String> _regionStack = new Stack();

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    @Override
    public ReadableAsset importToReadableAsset(File inputFile) throws DescriptionException {
        String orgFileContent;
        try {
            FileInputStream fis = new FileInputStream(inputFile);
            byte[] magic = new byte[3];
            fis.read(magic);
            if (magic[0] == -17 && magic[1] == -69 && magic[2] == -65) {
                orgFileContent = IOUtils.toString((InputStream)fis, (String)"UTF-8").replaceAll("\r", "\n").replaceAll("\n\n", "\n");
                fis.close();
            } else {
                orgFileContent = FileUtils.readFileToString((File)inputFile, (String)"UTF-8").replaceAll("\r", "\n").replaceAll("\n\n", "\n");
            }
        }
        catch (IOException ex) {
            throw new DescriptionException(String.format("ERROR: IO exception while reading input (%s)", ex.getMessage()));
        }
        if (Strings.isNullOrEmpty((String)orgFileContent)) {
            return null;
        }
        ArrayList<String> mungedLines = new ArrayList<String>();
        for (String line : orgFileContent.split("\n")) {
            if (line.isEmpty()) continue;
            mungedLines.add(line.trim());
        }
        String mungedString = Joiner.on((String)"\n").join(mungedLines);
        if (this._verbose) {
            logger.debug((Object)orgFileContent);
            logger.debug((Object)"-------------------");
            logger.debug((Object)mungedString);
        }
        TtDocument ttmlDocument = null;
        try {
            ttmlDocument = TtDocument.Factory.parse((String)mungedString, (XmlOptions)new XmlOptions().setLoadLineNumbers());
        }
        catch (XmlException ex) {
            ex.printStackTrace();
            throw new DescriptionException(String.format("TTML exception while parsing input (%s)", ex.getMessage()));
        }
        ReadableAsset readableAsset = new ReadableAsset();
        if (null != ttmlDocument) {
            ValidationErrorList validationErrors = this.validateTTMLDoc(ttmlDocument);
            if (validationErrors.size() > 0) {
                throw new DescriptionException("TTML validation Error:\n" + validationErrors.toString());
            }
            try {
                this.parseTTMLDocToReadableAsset(ttmlDocument, readableAsset);
            }
            catch (Exception ex) {
                throw new DescriptionException(String.format("iTT exception while parsing input (%s)", ex.getMessage()));
            }
            readableAsset.postProcess();
        }
        return readableAsset;
    }

    public ReadableAsset importToReadableAsset(TtDocument ttmlDocument) throws DescriptionException {
        ReadableAsset readableAsset = new ReadableAsset();
        if (null != ttmlDocument) {
            ValidationErrorList validationErrors = this.validateTTMLDoc(ttmlDocument);
            if (validationErrors.size() > 0) {
                throw new DescriptionException("TTML validation Error:\n" + validationErrors.toString());
            }
            try {
                this.parseTTMLDocToReadableAsset(ttmlDocument, readableAsset);
            }
            catch (Exception ex) {
                throw new DescriptionException(String.format("iTT exception while parsing input (%s)", ex.getMessage()));
            }
            readableAsset.postProcess();
        }
        return readableAsset;
    }

    public ReadableAsset importToReadableAsset(SubtitleSummary subtitleSummary) throws DescriptionException {
        return this.importToReadableAsset(subtitleSummary.getDocument());
    }

    public ReadableAsset importToReadableAsset(File inputFile, Map<Character, Character> overrideCharMap, boolean convertCjkVerticalChars, boolean useCjkOverride, boolean useMultiCharMapping) throws DescriptionException {
        if (convertCjkVerticalChars) {
            try {
                SubtitleSummary summary = new SubtitleSummary((SeekableDataInput)new FileSeekableDataInput(inputFile));
                summary.validationsToException();
                if (useCjkOverride) {
                    summary.setCjkOverrideMap();
                }
                if (overrideCharMap != null) {
                    summary.addToCjkOverrideMap(overrideCharMap);
                }
                if (useMultiCharMapping) {
                    summary.shouldUseMultiCharMaping(useMultiCharMapping);
                }
                summary.halfToFullWidth();
                return this.importToReadableAsset(summary.getDocument());
            }
            catch (IOException ex) {
                throw new DescriptionException(String.format("ERROR: IO exception while reading input (%s)", ex.getMessage()));
            }
        }
        return this.importToReadableAsset(inputFile);
    }

    public ReadableAsset importToReadableAsset(File inputFile, boolean convertCjkVerticalChars, boolean useCjkOverride, boolean useMultiCharMapping) throws DescriptionException {
        return this.importToReadableAsset(inputFile, null, convertCjkVerticalChars, useCjkOverride, useMultiCharMapping);
    }

    public ReadableAsset importToReadableAsset(File inputFile, boolean convertCjkVerticalChars, boolean useCjkOverride) throws DescriptionException {
        return this.importToReadableAsset(inputFile, null, convertCjkVerticalChars, useCjkOverride, false);
    }

    public ReadableAsset importToReadableAsset(File inputFile, boolean convertCjkVerticalChars) throws DescriptionException {
        return this.importToReadableAsset(inputFile, null, convertCjkVerticalChars, false, false);
    }

    public void parseTTMLDocToReadableAsset(TtDocument doc, ReadableAsset asset) throws Exception {
        TtEltype ttmlElement = doc.getTt();
        this.parseRoot(ttmlElement, asset);
        HeadEltype head = ttmlElement.getHead();
        this.parseStyling(head.getStyling(), asset);
        this.parseLayout(head.getLayout(), asset);
        this.parseBody(ttmlElement.getBody(), asset);
        if (ttmlElement.getBody().sizeOfDivArray() != 1) {
            throw new Exception("There can be only one DIV tag");
        }
        this.parseDiv(ttmlElement.getBody().getDivArray(0), asset);
        for (PEltype par : ttmlElement.getBody().getDivArray(0).getPArray()) {
            asset.appendTextElement(this.parseParagraph(par, asset));
        }
    }

    private ittStyle styleFromCursor(XmlCursor cursor) {
        ittStyle s = new ittStyle();
        cursor.toFirstAttribute();
        do {
            String attName;
            if ("id".equals(attName = cursor.getName().getLocalPart())) {
                s._id = cursor.getTextValue();
                continue;
            }
            if (ittStyle.isKnownTTMLStyle(attName)) {
                if (!TTMLCursorAdaptor.ttmlStyleAttNameSpace().equals(cursor.getName().getNamespaceURI())) {
                    // empty if block
                }
                switch (attName) {
                    case "fontFamily": {
                        s._fontFamily = cursor.getTextValue();
                        break;
                    }
                    case "fontWeight": {
                        s._fontWeight = cursor.getTextValue();
                        break;
                    }
                    case "fontStyle": {
                        s._fontStyle = cursor.getTextValue();
                        break;
                    }
                    case "color": {
                        s._color = cursor.getTextValue();
                        break;
                    }
                    case "fontSize": {
                        s._fontSize = cursor.getTextValue();
                        break;
                    }
                    case "origin": {
                        s._origin = cursor.getTextValue();
                        break;
                    }
                    case "extent": {
                        s._extent = cursor.getTextValue();
                        break;
                    }
                    case "textAlign": {
                        s._textAlign = cursor.getTextValue();
                        break;
                    }
                    case "displayAlign": {
                        s._displayAlign = cursor.getTextValue();
                        break;
                    }
                    case "writingMode": {
                        s._writingMode = cursor.getTextValue();
                        break;
                    }
                    case "backgroundColor": {
                        s._bgColor = cursor.getTextValue();
                        break;
                    }
                    case "textDecoration": {
                        s._textDecoration = cursor.getTextValue();
                    }
                }
                continue;
            }
            if (ittStyle.isKnownRubyExtensionStyle(attName)) {
                switch (attName) {
                    case "position": {
                        s._rubyPosition = cursor.getTextValue();
                        break;
                    }
                    case "align": {
                        s._rubyAlign = cursor.getTextValue();
                        break;
                    }
                    case "offset": {
                        s._rubyOffset = cursor.getTextValue();
                    }
                }
                continue;
            }
            if (!ittStyle.isKnownVerticalExtensionStyle(attName)) continue;
            switch (attName) {
                case "combine": {
                    s._verticalCombine = cursor.getTextValue();
                }
            }
        } while (cursor.toNextAttribute());
        return s;
    }

    void parseStyling(StylingEltype styling, ReadableAsset asset) {
        for (StyleEltype style : styling.getStyleArray()) {
            ittStyle s = this.styleFromCursor(style.newCursor());
            asset.addStyle(s);
        }
    }

    void parseLayout(LayoutEltype layout, ReadableAsset asset) {
        for (RegionEltype region : layout.getRegionArray()) {
            ittRegion x = new ittRegion();
            x._style = this.styleFromCursor(region.newCursor());
            x._id = x._style._id;
            asset.addRegion(x);
        }
    }

    void parseBody(BodyEltype body, ReadableAsset asset) {
        if (body.isSetRegion()) {
            if (asset.isRegionDefined(body.getRegion())) {
                this._regionStack.push(body.getRegion());
                asset.setAttribute("region", body.getStyle());
            } else {
                throw new IllegalArgumentException("Body's region attribute does not exist. Must be one of the regions defined in the Layout section");
            }
        }
        if (body.isSetStyle()) {
            if (asset.isStyleDefined((String)body.getStyle().get(0))) {
                this._styleStack.push((String)body.getStyle().get(0));
                asset.setAttribute("style", body.getStyle().get(0));
            } else {
                throw new IllegalArgumentException("Body's style attribute does not exist. Must be one of the styles defined in the styling section");
            }
        }
    }

    void parseDiv(DivEltype div, ReadableAsset asset) throws SubtitleSMPTEException {
        if (div.isSetBegin()) {
            SubtitleSMPTETimeCode showTimecode = SubtitleSMPTETimeCode.parseSubtitleTimeCode(div.getBegin(), this._docTmcdSampleRate, this._docTmcdMode);
            asset.setAttribute("displayTimeBegin", showTimecode);
        }
        if (div.isSetStyle()) {
            if (asset.isStyleDefined((String)div.getStyle().get(0))) {
                this._styleStack.push((String)div.getStyle().get(0));
                if (asset.attribute("style") == null) {
                    asset.setAttribute("style", div.getStyle().get(0));
                }
            } else {
                throw new IllegalArgumentException("Div's style attribute does not exist. Must be one of the styles defined in the styling section");
            }
        }
        if (div.isSetRegion()) {
            if (asset.isRegionDefined(div.getRegion())) {
                this._regionStack.push(div.getRegion());
                if (asset.attribute("region") == null) {
                    asset.setAttribute("region", div.getRegion());
                }
            } else {
                throw new IllegalArgumentException("Div's style attribute does not exist. Must be one of the regions defined in the styling section");
            }
        }
    }

    private String getDefaultStyle(ReadableAsset asset) {
        String style = "";
        try {
            style = this._styleStack.peek();
        }
        catch (EmptyStackException ex) {
            logger.debug((Object)"There is no default style defined");
        }
        if (style.isEmpty()) {
            style = asset.getDefaultStyleName();
        }
        return style;
    }

    private String getDefaultRegion(ReadableAsset asset) {
        String region = "";
        try {
            region = this._regionStack.peek();
        }
        catch (EmptyStackException ex) {
            logger.debug((Object)"There is no default region defined");
        }
        if (region.isEmpty()) {
            region = asset.getDefaultRegionName();
        }
        return region;
    }

    public TextElement parseParagraph(PEltype para, ReadableAsset asset) throws TTMLException, SubtitleSMPTEException {
        if (!para.isSetBegin()) {
            throw new TTMLException("Each P tag needs a begin attribute");
        }
        if (!para.isSetEnd()) {
            throw new TTMLException("Each P tag needs a end attribute");
        }
        TextElement textElement = new TextElement();
        String beginTimecode = para.getBegin();
        String endTimecode = para.getEnd();
        SubtitleSMPTETimeCode showTimecode = SubtitleSMPTETimeCode.parseSubtitleTimeCode(beginTimecode, this._docTmcdSampleRate, this._docTmcdMode);
        SubtitleSMPTETimeCode hideTimecode = SubtitleSMPTETimeCode.parseSubtitleTimeCode(endTimecode, this._docTmcdSampleRate, this._docTmcdMode);
        textElement.setPresentationTimes(showTimecode, hideTimecode);
        String paraStyle = this.getDefaultStyle(asset);
        if (para.isSetStyle() && asset.isStyleDefined((String)para.getStyle().get(0))) {
            paraStyle = (String)para.getStyle().get(0);
        }
        if (paraStyle.isEmpty()) {
            throw new TTMLException("There is no defined style for this subtitle.");
        }
        this._styleStack.push(paraStyle);
        String paraRegion = this.getDefaultRegion(asset);
        if (para.isSetRegion() && asset.isRegionDefined(para.getRegion())) {
            paraRegion = para.getRegion();
        }
        if (paraRegion.isEmpty()) {
            throw new TTMLException("There is no defined region for this subtitle.");
        }
        this._regionStack.push(paraRegion);
        PopulateTextElementStrategy strategy = new PopulateTextElementStrategy();
        strategy.setStacks(this._styleStack, this._regionStack);
        ParagraphParser paragraphParser = ParagraphParser.factory(strategy);
        XmlCursor paraCursor = para.newCursor();
        paragraphParser.processStream(paraCursor);
        if (paraCursor != null) {
            paraCursor.dispose();
        }
        for (StyledString ss : strategy.strings()) {
            textElement.appendStyledString(ss);
        }
        this._styleStack.pop();
        this._regionStack.pop();
        return textElement;
    }

    void parseRoot(TtEltype ttmlElement, ReadableAsset asset) {
        if (ttmlElement.isSetDropMode()) {
            this._docTmcdMode = TTMLBeansEnumMapper.toSMPTEDropMode(ttmlElement.getDropMode());
            asset.setAttribute("dropMode", (Object)this._docTmcdMode);
        }
        if (ttmlElement.isSetTimeBase()) {
            asset.setAttribute("timeBase", ttmlElement.getTimeBase().toString());
        }
        asset.setAttribute("lang", ttmlElement.getLang());
        if (ttmlElement.isSetFrameRateMultiplier()) {
            asset.setAttribute("frameRateMultiplier", ttmlElement.getFrameRateMultiplier());
        }
        if (ttmlElement.isSetFrameRate()) {
            this._docframeRate = ttmlElement.getFrameRate();
            asset.setAttribute("frameRate", this._docframeRate);
        }
        String frameRateMultiplier = (String)asset.attribute("frameRateMultiplier");
        this._docTmcdSampleRate = new SampleRate(this._docframeRate.longValue(), frameRateMultiplier);
    }

    ValidationErrorList validateTTMLDoc(TtDocument ttmlDocument) {
        XmlOptions validateOptions = new XmlOptions();
        ArrayList<XmlError> errorList = new ArrayList<XmlError>();
        validateOptions.setErrorListener(errorList);
        boolean isValid = ttmlDocument.validate(validateOptions);
        if (!isValid && this._verbose) {
            for (int i = 0; i < errorList.size(); ++i) {
                XmlError error = errorList.get(i);
                logger.debug((Object)String.format("Message: %s\n", error.getMessage()));
                logger.debug((Object)String.format("Location of invalid XML: %s\n", error.getCursorLocation().xmlText()));
            }
        }
        return new ValidationErrorList(errorList);
    }

    public static void main(String[] args) {
        File inputFile = new File(args[0]);
        ittImporterXMLBeans importerXMLBeans = new ittImporterXMLBeans();
        try {
            ReadableAsset asset = importerXMLBeans.importToReadableAsset(inputFile);
            String timeranges = asset.timerangesWithinPeriod(new MediaTime(60L, 1L), new MediaTime(600L, 1L), 10);
            System.out.println("Timeranges for 1 to 10 minutes : " + timeranges);
        }
        catch (DescriptionException ex) {
            ex.printStackTrace();
        }
    }

    public static enum ppState {
        NONE,
        TEXT,
        BR,
        SPAN,
        RUBY_SPAN,
        RB_SPAN,
        RT_SPAN;

    }
}

