/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import com.apple.jingle.leghorn.subtitle.VTTAlignmentPolicy;
import com.apple.jingle.leghorn.subtitle.VTTAlignmentPolicyDefault;
import com.apple.jingle.leghorn.subtitle.VTTStylingPolicy;
import com.apple.jingle.leghorn.subtitle.VTTStylingPolicyDefault;
import com.apple.jingle.leghorn.subtitle.webvtt.ReadableAsset;
import com.apple.jingle.leghorn.subtitle.webvtt.RubyContent;
import com.apple.jingle.leghorn.subtitle.webvtt.StyledString;
import com.apple.jingle.leghorn.subtitle.webvtt.SubtitleConvertException;
import com.apple.jingle.leghorn.subtitle.webvtt.TextElement;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTHelper;
import com.apple.jingle.leghorn.subtitle.webvtt.ittRegion;
import com.apple.jingle.leghorn.subtitle.webvtt.ittStyle;
import com.apple.jingle.leghorn.subtitle.webvtt.subtitlesExporter;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.TimeCode;
import com.apple.jingle.leghorn.util.UnicodeUtil;
import com.google.common.base.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class WebVTTExporter
implements subtitlesExporter {
    static final String VTT_HEADER = "WEBVTT - Version=1.0 \n\n";
    static final String VTT_TIMING_SEP = " --> ";
    private Map<String, String> _alignmentMappper = new HashMap<String, String>();
    private boolean _overrideDocumentSettings = true;
    private boolean _shouldExportStyles = true;
    private boolean _shouldAddStyleSection = true;
    private boolean _shouldStripIBU = false;
    private VTTAlignmentPolicy _alignmentPolicy = new VTTAlignmentPolicyDefault();
    private VTTStylingPolicy _stylingPolicy = new VTTStylingPolicyDefault();
    private static Map<String, String> selectorNameReplacementMap = new HashMap<String, String>();

    public void setShoulExportStyles(boolean enable) {
        this._shouldExportStyles = enable;
    }

    public boolean shouldExportStyles() {
        return this._shouldExportStyles;
    }

    public void setAddStyleSection(boolean enable) {
        this._shouldAddStyleSection = enable;
    }

    public boolean shouldAddStyleSection() {
        return this._shouldAddStyleSection;
    }

    public void setShouldStripIBU(boolean enable) {
        this._shouldStripIBU = enable;
    }

    public boolean shouldStripIBU() {
        return this._shouldStripIBU;
    }

    @Override
    public void setOutputDimensions(long w, long h) {
    }

    static String timecodeToString(TimeCode tmcd) {
        MediaTime mt = tmcd.getMediaTime();
        long milliseconds = Math.round((double)mt.getSampleCount() / mt.getRate().exactSampleRate() * 1000.0);
        if (milliseconds == 0L) {
            return "00:00:00.000";
        }
        long hours = (long)Math.floor(milliseconds / 3600000L);
        long minutes = (long)Math.floor((milliseconds -= hours * 3600000L) / 60000L);
        long seconds = (long)Math.floor((milliseconds -= minutes * 60000L) / 1000L);
        return String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, milliseconds -= seconds * 1000L);
    }

    static String sanitizeString(String dirty) {
        return dirty;
    }

    private static String timeCodesToVTT(TimeCode show, TimeCode hide) {
        StringBuilder builder = new StringBuilder(40);
        builder.append(WebVTTExporter.timecodeToString(show));
        builder.append(VTT_TIMING_SEP);
        builder.append(WebVTTExporter.timecodeToString(hide));
        builder.append(" ");
        return builder.toString();
    }

    public String buildCueSettings(TextElement e, ReadableAsset asset) {
        ittRegion region;
        StringBuilder sb = new StringBuilder(" ");
        Iterator<StyledString> it = e.iterator();
        StyledString ss = new StyledString("", asset.getDefaultStyleName(), asset.getDefaultRegionName());
        if (it.hasNext()) {
            ss = it.next();
        }
        if ((region = asset.region(ss.regionName())) == null || region._style == null) {
            return "";
        }
        ittStyle style = region._style;
        sb.append(" align:");
        sb.append(this._alignmentMappper.get(style._textAlign));
        String writingMode = style._writingMode;
        int textOrientation = 0;
        if ("tblr".equals(writingMode)) {
            textOrientation = 1;
        } else if ("tbrl".equals(writingMode) || "tb".equals(writingMode)) {
            textOrientation = -1;
        }
        ReadableAsset.BasicDisplayArea displayArea = asset.getStyledStringDisplayArea(ss);
        if (displayArea == ReadableAsset.BasicDisplayArea.TOP) {
            sb.append(" ");
            sb.append(this._alignmentPolicy.topRegionLR());
        } else if (displayArea == ReadableAsset.BasicDisplayArea.BOTTOM) {
            sb.append(" ");
            sb.append(this._alignmentPolicy.bottomRegionLR());
        } else if (displayArea == ReadableAsset.BasicDisplayArea.LEFT) {
            sb.append(" ");
            if (textOrientation == -1) {
                sb.append(this._alignmentPolicy.leftRegionRL());
            } else if (textOrientation == 1) {
                sb.append(this._alignmentPolicy.leftRegionLR());
            }
        } else if (displayArea == ReadableAsset.BasicDisplayArea.RIGHT) {
            sb.append(" ");
            if (textOrientation == -1) {
                sb.append(this._alignmentPolicy.rightRegionRL());
            } else if (textOrientation == 1) {
                sb.append(this._alignmentPolicy.rightRegionLR());
            }
        } else {
            throw new IllegalStateException("Incorrect display area");
        }
        if (textOrientation == 1) {
            sb.append(" vertical:lr");
        } else if (textOrientation == -1) {
            sb.append(" vertical:rl");
        }
        return sb.toString();
    }

    public String buildCueText(TextElement e, ReadableAsset asset) {
        UnicodeUtil.CJKCompatibility cjkUtil = new UnicodeUtil.CJKCompatibility();
        StringBuilder cueText = new StringBuilder();
        for (StyledString ss : e) {
            ss = ss.sanitizeText().escapeLessGreaterThan();
            boolean isItalic = false;
            boolean isBold = false;
            boolean isUnderline = false;
            String rubyStyleName = "";
            if (ss.styleName() != null && asset.style(ss.styleName()) != null) {
                isItalic = "italic".equalsIgnoreCase(asset.style((String)ss.styleName())._fontStyle);
                isBold = "bold".equalsIgnoreCase(asset.style((String)ss.styleName())._fontWeight);
                isUnderline = "underline".equalsIgnoreCase(asset.style((String)ss.styleName())._textDecoration);
                if (this._shouldExportStyles && VTTHelper.ittStyleToVTTStyleString(asset.style(ss.styleName())).length() != 0) {
                    rubyStyleName = ss.styleName();
                }
            }
            rubyStyleName = this.sanitizeSelectorName(rubyStyleName);
            if (ss instanceof RubyContent) {
                RubyContent rc = (RubyContent)ss;
                if (rubyStyleName.isEmpty()) {
                    cueText.append(String.format("<ruby>%s%s</ruby>%s", rc.text(), rc.annotation().toString(), rc.appendedText()));
                    continue;
                }
                cueText.append(String.format("<c.%s><ruby>%s%s</ruby></c>%s", rubyStyleName, rc.text(), rc.annotation().toString(), rc.appendedText()));
                continue;
            }
            if (rubyStyleName.length() != 0) {
                String mss = ss.export();
                if (mss.endsWith("\r")) {
                    cueText.append(String.format("<c.%s>%s</c>\r", rubyStyleName, mss.substring(0, mss.length() - 1)));
                    continue;
                }
                cueText.append(String.format("<c.%s>%s</c>", rubyStyleName, mss));
                continue;
            }
            String prefix = "";
            String posfix = "";
            if (isItalic) {
                prefix = prefix + "<i>";
                posfix = posfix + "</i>";
            }
            if (isBold) {
                prefix = prefix + "<b>";
                posfix = posfix + "</b>";
            }
            if (isUnderline) {
                prefix = prefix + "<u>";
                posfix = posfix + "</u>";
            }
            String preString = ss.export();
            if (asset.hasTCYStyle(ss)) {
                preString = cjkUtil.halfToFullWidth(ss.export());
            }
            cueText.append(prefix);
            if (preString.endsWith("\r")) {
                cueText.append(preString.substring(0, preString.length() - 1));
                cueText.append(posfix);
                cueText.append("\r");
                continue;
            }
            cueText.append(preString);
            cueText.append(posfix);
        }
        return cueText.toString();
    }

    public void initAttributeMappingPolicies() {
        this._alignmentMappper.clear();
        if (this._overrideDocumentSettings) {
            this._alignmentMappper.put("left", "start");
            this._alignmentMappper.put("center", "middle");
            this._alignmentMappper.put("right", "start");
            this._alignmentMappper.put("start", "start");
            this._alignmentMappper.put("end", "start");
        } else {
            this._alignmentMappper.put("left", "left");
            this._alignmentMappper.put("center", "middle");
            this._alignmentMappper.put("right", "right");
            this._alignmentMappper.put("start", "start");
            this._alignmentMappper.put("end", "end");
        }
    }

    private String sanitizeSelectorName(String selectorName) {
        String ret = selectorName;
        for (Map.Entry<String, String> e : selectorNameReplacementMap.entrySet()) {
            ret = ret.replace(e.getKey(), e.getValue());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean export(ReadableAsset asset, File dst) throws SubtitleConvertException, IOException {
        if (this._shouldStripIBU) {
            this.stripIBU(asset);
        }
        this.initAttributeMappingPolicies();
        asset.applyTimeOffset();
        File cuesText = new File(dst.getAbsolutePath() + ".cuetext");
        BufferedWriter writer = null;
        int cueIndex = 1;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cuesText), "UTF-8"));
            for (TextElement e : asset) {
                writer.write(String.format("%d\n", cueIndex));
                writer.write(WebVTTExporter.timeCodesToVTT(e.showTime(), e.hideTime()));
                writer.write(this.buildCueSettings(e, asset));
                writer.write("\n");
                writer.write(this.buildCueText(e, asset));
                writer.write("\n\n");
                ++cueIndex;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dst), "UTF-8"));
            writer.write(VTT_HEADER);
            if (this._shouldExportStyles && this._shouldAddStyleSection) {
                StringBuilder stylesBuilder = new StringBuilder();
                stylesBuilder.append(this.computeWholeDocumentStyles(asset));
                for (ittStyle st : asset.allStyles()) {
                    String rubyStyle;
                    if ("allCuesSelectorITunesStore201687387357".equals(st._id) || "itmsNormalStyle".equals(st._id) || (rubyStyle = VTTHelper.ittStyleToVTTStyleString(st)).length() == 0) continue;
                    stylesBuilder.append(String.format("::cue(.%s) { %s }\n", this.sanitizeSelectorName(st._id), rubyStyle));
                }
                if (stylesBuilder.length() > 0) {
                    writer.write("STYLE\n");
                    writer.write(stylesBuilder.toString());
                    writer.write("\n\n");
                }
            }
            writer.write(FileUtils.readFileToString((File)cuesText, (String)"UTF-8"));
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        FileUtils.deleteQuietly((File)cuesText);
        return true;
    }

    public void setAlignmentPolicy(VTTAlignmentPolicy policy) {
        this._alignmentPolicy = policy;
    }

    public void setStylingPolicy(VTTStylingPolicy policy) {
        this._stylingPolicy = policy;
    }

    private String computeWholeDocumentStyles(ReadableAsset asset) {
        String styleString;
        if (asset.style("allCuesSelectorITunesStore201687387357") != null && (styleString = VTTHelper.ittStyleToVTTStyleString(asset.style("allCuesSelectorITunesStore201687387357"))).length() > 0) {
            return "::cue {" + styleString + "}\n";
        }
        if (!"Default".equals(this._stylingPolicy.name())) {
            String styleString2;
            if (this._stylingPolicy.fontRelativeSize() > 0 && this._stylingPolicy.fontRelativeScreenPercentage() != 0.0) {
                throw new IllegalArgumentException("Invalid styling policy. Use either fontRelativeSize or fontRelativeScreenPercentage but not both");
            }
            if (!Strings.isNullOrEmpty((String)this._stylingPolicy.fontFamilyName()) && !Strings.isNullOrEmpty((String)this._stylingPolicy.fontGenericFamilyName())) {
                throw new IllegalArgumentException("Invalid styling policy. Use either fontFamilyName or fontGenericFamilyName but not both");
            }
            ittStyle newStyle = new ittStyle();
            boolean updated = false;
            if (!Strings.isNullOrEmpty((String)this._stylingPolicy.backgroundColor())) {
                newStyle._bgColor = this._stylingPolicy.backgroundColor();
                updated = true;
            }
            if (!Strings.isNullOrEmpty((String)this._stylingPolicy.characterEdgeStyle()) && !this._stylingPolicy.characterEdgeStyle().toLowerCase().equals("none")) {
                newStyle._textEdgeStyle = this._stylingPolicy.characterEdgeStyle();
                updated = true;
            }
            if (this._stylingPolicy.fontRelativeSize() > 0) {
                newStyle._fontSize = String.format("%d", this._stylingPolicy.fontRelativeSize());
                updated = true;
            }
            if (this._stylingPolicy.fontRelativeScreenPercentage() != 0.0) {
                newStyle._fontSizeDisplay = String.format("%.02f", this._stylingPolicy.fontRelativeScreenPercentage());
                updated = true;
            }
            if (!Strings.isNullOrEmpty((String)this._stylingPolicy.fontFamilyName())) {
                newStyle._fontFamily = this._stylingPolicy.fontFamilyName();
                updated = true;
            }
            if (!Strings.isNullOrEmpty((String)this._stylingPolicy.fontGenericFamilyName())) {
                newStyle._genericFontFamily = this._stylingPolicy.fontGenericFamilyName();
                updated = true;
            }
            if (updated && (styleString2 = VTTHelper.ittStyleToVTTStyleString(newStyle)).length() > 0) {
                return "::cue {" + styleString2 + "}\n";
            }
        }
        return "";
    }

    private void stripIBU(ReadableAsset asset) {
        Collection<ittStyle> styles = asset.allStyles();
        for (ittStyle s : styles) {
            s._fontStyle = "normal";
            s._fontWeight = "normal";
            s._textDecoration = "";
        }
    }

    static {
        selectorNameReplacementMap.put(".", "dot");
        selectorNameReplacementMap.put("_", "undscr");
    }
}

