/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import com.apple.jingle.leghorn.subtitle.webvtt.CSSColor;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTParserException;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class VTTStyleParser {
    private static String kStyleHeader = "STYLE";
    private static Pattern vttStylePattern = Pattern.compile("::cue(\\([\\w|.|\\-]+\\))*\\s*\\{(\\s*[\\w|#|\\-|\\:|\\s|,|;|\"|\\.|\\(|\\)]+)\\}\\s*");
    private static Map<String, String> _cssNameToCMAttribute = new HashMap<String, String>();
    private List<Map<String, Object>> _styles = new ArrayList<Map<String, Object>>();

    private List<String> getStyleLines(File vttfile) {
        boolean styleHeaderFound = false;
        ArrayList<String> styleStrings = new ArrayList<String>();
        try {
            String str;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(vttfile), "UTF8"));
            while ((str = in.readLine()) != null) {
                if (kStyleHeader.equals(str.trim())) {
                    styleHeaderFound = true;
                    continue;
                }
                if (!styleHeaderFound) continue;
                if (Strings.isNullOrEmpty((String)str.trim())) break;
                styleStrings.add(str.trim());
            }
            in.close();
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return styleStrings;
    }

    private void parseStyledString(String styleString) {
        String vttStyle = "";
        try {
            vttStyle = new String(styleString.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return;
        }
        Matcher styleMatcher = vttStylePattern.matcher(vttStyle);
        if (!styleMatcher.matches()) {
            throw new VTTParserException("bad style:" + styleString);
        }
        HashMap<String, Object> dict = new HashMap<String, Object>();
        try {
            String selectorName = styleMatcher.group(1);
            String styles = styleMatcher.group(2);
            selectorName = Strings.isNullOrEmpty((String)selectorName) ? "::cue" : StringUtils.strip((String)selectorName, (String)"()");
            for (String att : styles.split(";")) {
                String rubyAlign;
                String[] parts = att.split(":");
                if (parts.length != 2 || parts[0] == null || parts[1] == null) continue;
                String cmName = _cssNameToCMAttribute.get(parts[0].trim());
                String attValue = parts[1].trim();
                if (Strings.isNullOrEmpty((String)cmName)) continue;
                if (cmName.equals("CMForegroundColorARGB") || cmName.equals("CMCharacterBackgroundColorARGB") || cmName.equals("CMBackgroundColorARGB")) {
                    CSSColor clr = CSSColor.colorFromString(attValue);
                    if (clr == null) continue;
                    dict.put(cmName, clr.asFloatARGBList());
                    continue;
                }
                if (cmName.equals("CMBoldStyle")) {
                    if (!"bold".equals(attValue)) continue;
                    dict.put(cmName, true);
                    continue;
                }
                if (cmName.equals("CMItalicStyle")) {
                    if (!"italic".equals(attValue)) continue;
                    dict.put(cmName, true);
                    continue;
                }
                if (cmName.equals("CMUnderlineStyle")) {
                    if (!"underline".equals(attValue)) continue;
                    dict.put(cmName, true);
                    continue;
                }
                if (cmName.equals("CMFontFamilyName")) {
                    dict.put(cmName, StringUtils.strip((String)attValue, (String)"\""));
                    continue;
                }
                if (cmName.equals("CMRelativeFontSize")) {
                    dict.put(cmName, Long.parseLong(attValue));
                    continue;
                }
                if (cmName.equals("CMBaseFontSizePercentage")) {
                    dict.put(cmName, Double.parseDouble(attValue));
                    continue;
                }
                if (cmName.equals("CMHorizontalInVerticalForms")) {
                    if ("all".equalsIgnoreCase(attValue)) {
                        dict.put(cmName, 4);
                        continue;
                    }
                    dict.put(cmName, Long.parseLong(attValue));
                    continue;
                }
                if (cmName.equals("CMRubyOffset")) {
                    dict.put(cmName, Long.parseLong(attValue));
                    continue;
                }
                if (cmName.equals("CMCharacterEdgeStyle")) {
                    String edgeStyle = StringUtils.strip((String)attValue, (String)"\"");
                    if ("raised".equals(edgeStyle)) {
                        dict.put(cmName, "CMCharacterEdgeStyle_Raised");
                        continue;
                    }
                    if ("depressed".equals(edgeStyle)) {
                        dict.put(cmName, "CMCharacterEdgeStyle_Depressed");
                        continue;
                    }
                    if ("uniform".equals(edgeStyle)) {
                        dict.put(cmName, "CMCharacterEdgeStyle_Uniform");
                        continue;
                    }
                    if (!"dropshadow".equals(edgeStyle)) continue;
                    dict.put(cmName, "CMCharacterEdgeStyle_DropShadow");
                    continue;
                }
                if (cmName.equals("CMRubyAlignment")) {
                    rubyAlign = StringUtils.strip((String)attValue, (String)"\"");
                    if ("start".equals(rubyAlign)) {
                        dict.put(cmName, "CMRubyAlignment_Start");
                        continue;
                    }
                    if ("center".equals(rubyAlign)) {
                        dict.put(cmName, "CMRubyAlignment_Center");
                        continue;
                    }
                    if ("space-between".equals(rubyAlign) || "spaceBetween".equals(rubyAlign)) {
                        dict.put(cmName, "CMRubyAlignment_DistributeSpace");
                        continue;
                    }
                    if (!"space-around".equals(rubyAlign) && !"spaceAround".equals(rubyAlign)) continue;
                    dict.put(cmName, "CMRubyAlignment_DistributeLetter");
                    continue;
                }
                if (!cmName.equals("CMRubyPosition")) continue;
                rubyAlign = StringUtils.strip((String)attValue, (String)"\"");
                if ("over".equals(rubyAlign)) {
                    dict.put(cmName, "CMRubyPosition_Before");
                    continue;
                }
                if (!"under".equals(rubyAlign)) continue;
                dict.put(cmName, "CMRubyPosition_After");
            }
            if (dict.size() > 0) {
                dict.put("CMTextSelector", selectorName);
                this._styles.add(dict);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new VTTParserException("bad style:" + vttStyle, ex);
        }
        catch (NumberFormatException ex) {
            throw new VTTParserException("bad style:" + vttStyle, ex);
        }
        catch (IllegalArgumentException ex) {
            throw new VTTParserException("bad style:" + vttStyle, ex);
        }
    }

    private void serializeList(StringBuilder sb, List<?> aa) {
        sb.append("[ ");
        boolean bfirst = true;
        for (Object ooo : aa) {
            if (bfirst) {
                bfirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(ooo);
        }
        sb.append("]");
    }

    private void serializeMap(StringBuilder sb, Map<String, Object> m) {
        sb.append("  {\n");
        boolean bfirst = true;
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (bfirst) {
                bfirst = false;
            } else {
                sb.append(",\n");
            }
            sb.append("    ");
            sb.append("\"");
            sb.append(e.getKey());
            sb.append("\" : ");
            Object oo = e.getValue();
            if (oo instanceof String) {
                sb.append("\"");
                sb.append((String)oo);
                sb.append("\"");
                continue;
            }
            if (oo instanceof Boolean) {
                sb.append((Boolean)oo);
                continue;
            }
            if (oo instanceof Long) {
                sb.append((Long)oo);
                continue;
            }
            if (oo instanceof Double) {
                sb.append((Double)oo);
                continue;
            }
            if (!(oo instanceof List)) continue;
            this.serializeList(sb, (List)oo);
        }
        sb.append("\n  }");
    }

    public String getJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        boolean bfirst = true;
        for (Map<String, Object> m : this._styles) {
            if (bfirst) {
                bfirst = false;
            } else {
                sb.append(",\n");
            }
            this.serializeMap(sb, m);
        }
        sb.append("]\n");
        return sb.toString();
    }

    public void parse(File vttfile) {
        List<String> styleStrings = this.getStyleLines(vttfile);
        for (String ss : styleStrings) {
            this.parseStyledString(ss);
        }
    }

    public static void main(String[] args) {
        VTTStyleParser parser = new VTTStyleParser();
        parser.parse(new File(args[0]));
    }

    static {
        _cssNameToCMAttribute.put("color", "CMForegroundColorARGB");
        _cssNameToCMAttribute.put("x-char-background-color", "CMCharacterBackgroundColorARGB");
        _cssNameToCMAttribute.put("background-color", "CMBackgroundColorARGB");
        _cssNameToCMAttribute.put("font-weight", "CMBoldStyle");
        _cssNameToCMAttribute.put("text-decoration-line", "CMUnderlineStyle");
        _cssNameToCMAttribute.put("font-style", "CMItalicStyle");
        _cssNameToCMAttribute.put("font-family-name", "CMFontFamilyName");
        _cssNameToCMAttribute.put("x-generic-font-family", "CMGenericFontFamilyName");
        _cssNameToCMAttribute.put("x-text-edge-style", "CMCharacterEdgeStyle");
        _cssNameToCMAttribute.put("x-font-size-display", "CMBaseFontSizePercentage");
        _cssNameToCMAttribute.put("font-size", "CMRelativeFontSize");
        _cssNameToCMAttribute.put("text-combine-upright", "CMHorizontalInVerticalForms");
        _cssNameToCMAttribute.put("offset", "CMRubyOffset");
        _cssNameToCMAttribute.put("align", "CMRubyAlignment");
        _cssNameToCMAttribute.put("ruby-position", "CMRubyPosition");
    }

    class namedEntry {
        String _name;
        Object _value;

        public namedEntry(String name, Object value) {
            this._name = name;
            this._value = value;
        }
    }
}

