/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTSettings;

import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTSettings.Percentage;

public class LineValue {
    public LineModifier modifier = LineModifier.none;
    public Percentage percentage = Percentage.NONE;
    public long line = Long.MAX_VALUE;
    public static LineValue NONE = new LineValue();

    public static LineValue fromString(String s) {
        if (!LineValue.isValid(s)) {
            return NONE;
        }
        LineValue ret = new LineValue();
        String[] parts = s.trim().split(",");
        if (Percentage.isValid(parts[0])) {
            ret.percentage = Percentage.fromString(parts[0]);
        } else {
            ret.line = Long.valueOf(parts[0]);
        }
        if (parts.length > 1) {
            ret.modifier = LineModifier.fromString(parts[1]);
        }
        return ret;
    }

    public static boolean isValid(String s) {
        return true;
    }

    public String toString() {
        return "LineValue{modifier=" + (Object)((Object)this.modifier) + ", percentage=" + this.percentage + ", line=" + this.line + '}';
    }

    public static enum LineModifier {
        start("start"),
        center("center"),
        end("end"),
        none("none");

        private String _value;

        private LineModifier(String s) {
            this._value = s;
        }

        public static LineModifier fromString(String parameterName) {
            if (parameterName != null) {
                for (LineModifier objType : LineModifier.values()) {
                    if (!parameterName.equalsIgnoreCase(objType._value)) continue;
                    return objType;
                }
            }
            return none;
        }
    }
}

