/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt.VTTParser;

import com.apple.jingle.leghorn.subtitle.webvtt.BreakStyledText;
import com.apple.jingle.leghorn.subtitle.webvtt.ReadableAsset;
import com.apple.jingle.leghorn.subtitle.webvtt.RubyContent;
import com.apple.jingle.leghorn.subtitle.webvtt.RubyText;
import com.apple.jingle.leghorn.subtitle.webvtt.StyledString;
import com.apple.jingle.leghorn.subtitle.webvtt.TextElement;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTHelper;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTParserActionBase;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTSettings.CueSetting;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTSettings.VerticalValue;
import com.apple.jingle.leghorn.subtitle.webvtt.ittRegion;
import com.apple.jingle.leghorn.subtitle.webvtt.ittStyle;
import com.apple.jingle.leghorn.timecode.MillisTimeCode;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class VTTParserReadableAssetAction
extends VTTParserActionBase {
    private static final Logger log = Logger.getLogger(VTTParserActionBase.class);
    private ReadableAsset _asset;
    private final String _italicDefaultName;
    private final String _boldDefaultName;
    private final String _underlineDefaultName;
    private List<ittRegion> _regionCache = new ArrayList<ittRegion>();
    private static Map<String, String> _alignmentMappper = new HashMap<String, String>();

    public VTTParserReadableAssetAction(ReadableAsset asset) {
        this._asset = asset;
        long uniquePerDoc = System.currentTimeMillis();
        this._italicDefaultName = "italic" + uniquePerDoc;
        this._boldDefaultName = "bold" + uniquePerDoc;
        this._underlineDefaultName = "underline" + uniquePerDoc;
    }

    @Override
    public void foundCueID(String id) {
        log.debug((Object)("CueID:" + id));
        this._ctx.id = id;
    }

    @Override
    public void foundCueTiming(long start, long end) {
        log.debug((Object)("Start:" + start + "End:" + end));
        this._ctx.start = start;
        this._ctx.end = end;
    }

    private TextElement textElementFromContext() {
        TextElement textElement = new TextElement();
        MillisTimeCode showTimecode = MillisTimeCode.parseMillis(this._ctx.start);
        MillisTimeCode hideTimecode = MillisTimeCode.parseMillis(this._ctx.end);
        textElement.setPresentationTimes(showTimecode, hideTimecode);
        ittRegion region = this.getRegionFromCueSetting(this._ctx.settings);
        Stack<String> styleIDStack = new Stack<String>();
        styleIDStack.push(region._style._id);
        for (String msg : this._ctx.msg) {
            StyledString last;
            List<StyledString> lss = this.buildStyleString(msg, region, styleIDStack);
            if (lss.size() == 0 || (last = (StyledString)Iterables.getLast(lss, null)) == null) continue;
            last.cat(new BreakStyledText(last.styleName(), last.regionName()));
            for (StyledString ss : lss) {
                textElement.appendStyledString(ss);
            }
        }
        return textElement;
    }

    private List<StyledString> buildStyleString(String msg, ittRegion currentRegion, Stack<String> styleIDStack) {
        ArrayList<StyledString> ret = new ArrayList<StyledString>();
        Pattern p = Pattern.compile("<([^>]*)>");
        Matcher m = p.matcher(msg);
        int begin = 0;
        RubyContent rubyString = null;
        while (m.find()) {
            ittStyle st;
            String smsg = msg.substring(begin, m.start());
            begin = m.end();
            String tag = m.group(1);
            if (rubyString == null) {
                if (!smsg.isEmpty()) {
                    StyledString ss = new StyledString(smsg, styleIDStack.peek(), currentRegion._id);
                    ret.add(ss);
                }
            } else if (tag.startsWith("rt")) {
                rubyString.setText(smsg);
            }
            if ("/c".equals(tag)) {
                styleIDStack.pop();
                continue;
            }
            if ("/ruby".equals(tag)) {
                rubyString = null;
                styleIDStack.pop();
                continue;
            }
            if ("/rt".equals(tag)) {
                rubyString.setAnnotation(new RubyText(smsg));
                ret.add(rubyString);
                continue;
            }
            if (tag.startsWith("c.")) {
                styleIDStack.push(tag.substring(2));
                continue;
            }
            if (tag.startsWith("ruby")) {
                if (tag.startsWith("ruby.")) {
                    styleIDStack.push(tag.substring(5));
                } else {
                    st = this._asset.style(styleIDStack.peek());
                    if (st != null) {
                        String dummyName = st._id + "Ruby";
                        if (!this._asset.isStyleDefined(dummyName)) {
                            st._id = dummyName;
                            this._asset.addStyle(st);
                        }
                        styleIDStack.push(dummyName);
                    } else {
                        styleIDStack.push(styleIDStack.peek());
                    }
                }
                rubyString = new RubyContent("", styleIDStack.peek(), currentRegion._id);
                continue;
            }
            if ("i".equals(tag)) {
                if (!this._asset.isStyleDefined(this._italicDefaultName)) {
                    st = VTTHelper.ItalicDefaultIttStyle();
                    st._id = this._italicDefaultName;
                    this._asset.addStyle(st);
                }
                styleIDStack.push(this._italicDefaultName);
                continue;
            }
            if ("b".equals(tag)) {
                if (!this._asset.isStyleDefined(this._boldDefaultName)) {
                    st = VTTHelper.BoldDefaultIttStyle();
                    st._id = this._boldDefaultName;
                    this._asset.addStyle(st);
                }
                styleIDStack.push(this._boldDefaultName);
                continue;
            }
            if ("u".equals(tag)) {
                if (!this._asset.isStyleDefined(this._underlineDefaultName)) {
                    st = VTTHelper.UnderlineDefaultIttStyle();
                    st._id = this._underlineDefaultName;
                    this._asset.addStyle(st);
                }
                styleIDStack.push(this._underlineDefaultName);
                continue;
            }
            if (!"/i".equals(tag) && !"/b".equals(tag) && !"/u".equals(tag)) continue;
            styleIDStack.pop();
        }
        if (begin != msg.length()) {
            if (styleIDStack.size() == 0) {
                System.out.print("aaa");
            }
            ret.add(new StyledString(msg.substring(begin), styleIDStack.peek(), currentRegion._id));
        }
        return ret;
    }

    @Override
    public void endCue() {
        if (this._ctx.settings == CueSetting.NONE) {
            log.debug((Object)"EndCue on empy document");
            return;
        }
        log.debug((Object)"EndCue");
        this._asset.appendTextElement(this.textElementFromContext());
        super.endCue();
    }

    @Override
    public void setHasRuby(boolean v) {
    }

    @Override
    public void setHeaderMessage(String message) {
        this._asset.setAttribute("timeBase", "clock");
        this._asset.setAttribute("lang", "en-US");
        this._asset.setAttribute("frameRateMultiplier", "1 1");
        this._asset.setAttribute("frameRate", "1000");
        this._asset.setAttribute("headerComments", message);
    }

    private String genRegionName() {
        return String.format("region%06d", this._regionCache.size());
    }

    private ittRegion getRegionFromCueSetting(CueSetting setting) {
        ittRegion x = new ittRegion();
        ittStyle s = new ittStyle();
        s._id = this.genRegionName();
        if (setting.vertical == VerticalValue.lr) {
            s._writingMode = "tblr";
        } else if (setting.vertical == VerticalValue.rl) {
            s._writingMode = "tbrl";
        }
        s._textAlign = _alignmentMappper.get(setting.alignment.getValue());
        if (setting.line.percentage.value() == 0.0 && setting.position.value() == 0.0) {
            if (setting.vertical == VerticalValue.lr) {
                s._origin = "15% 0%";
                s._extent = "15% 100%";
            } else if (setting.vertical == VerticalValue.rl) {
                s._origin = "85% 0%";
                s._extent = "15% 100%";
            }
        } else if (setting.line.percentage.value() == 100.0 && setting.position.value() == 0.0) {
            if (setting.vertical == VerticalValue.lr) {
                s._origin = "85% 0%";
                s._extent = "15% 100%";
            } else if (setting.vertical == VerticalValue.rl) {
                s._origin = "15% 0%";
                s._extent = "15% 100%";
            }
        } else if (setting.line.percentage.value() <= 50.0) {
            s._origin = "0% 0%";
            s._extent = "100% 15%";
        } else {
            s._origin = "0% 85%";
            s._extent = "100% 15%";
        }
        x._style = s;
        x._id = x._style._id;
        for (ittRegion r : this._regionCache) {
            if (!r.weakEquals(x)) continue;
            return r;
        }
        this._regionCache.add(x);
        this._asset.addRegion(x);
        this._asset.addStyle(x._style);
        return x;
    }

    @Override
    public void foundStyle(String selectorName, String styleString) {
        ittStyle s = VTTHelper.VTTStyleStringToIttStyle(styleString);
        String notDottedSelectorName = selectorName;
        if (selectorName.startsWith(".")) {
            notDottedSelectorName = selectorName.substring(1);
        }
        s._id = notDottedSelectorName;
        this._asset.addStyle(s);
    }

    static {
        _alignmentMappper.put("left", "left");
        _alignmentMappper.put("middle", "center");
        _alignmentMappper.put("right", "right");
        _alignmentMappper.put("start", "start");
        _alignmentMappper.put("end", "end");
        _alignmentMappper.put("none", "center");
    }
}

