/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt.VTTParser;

import com.apple.jingle.leghorn.subtitle.VTTDocument;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTParserActionBase;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTSettings.CueSetting;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTSettings.VerticalValue;

public class VTTParserDescribeAction
extends VTTParserActionBase {
    private final VTTDocument _doc;
    private long _sampleCount = 0L;
    private long _firstSample = -1L;
    private long _topSamples = 0L;
    private long _bottomSamples = 0L;
    private long _leftSamples = 0L;
    private long _rightSamples = 0L;

    public VTTParserDescribeAction(VTTDocument doc) {
        this._doc = doc;
    }

    @Override
    public void setHasRuby(boolean v) {
        this._doc.setHasRuby(this._doc.hasRuby() || v);
    }

    @Override
    public void setHeaderMessage(String message) {
        this._doc.setHeaderMessage(message);
    }

    @Override
    public void foundCueID(String id) {
    }

    @Override
    public void foundCueTiming(long start, long end) {
        if (this._firstSample < 0L) {
            this._firstSample = start;
            this._doc.setFirstSampleTime(this._firstSample);
            this._doc.setLastSampleTime(this._firstSample);
        } else {
            this._doc.setLastSampleTime(start);
        }
    }

    @Override
    public void endCue() {
        if (this._firstSample >= 0L) {
            ++this._sampleCount;
            this._doc.setNumberOfSamples(this._sampleCount);
            if (this._ctx.msg.size() == 0) {
                this._doc.setNumberOfEmptySamples(this._doc.numberOfEmptySamples() + 1L);
            } else {
                this._doc.countSampleTextLine(this._ctx.msg.size() - 1);
            }
            this.updateLocationCounts(this._ctx.settings);
        }
        super.endCue();
    }

    private void updateLocationCounts(CueSetting setting) {
        if (setting == CueSetting.NONE) {
            return;
        }
        if (setting.line.percentage.value() == 0.0 && setting.position.value() == 0.0) {
            if (setting.vertical == VerticalValue.lr) {
                ++this._leftSamples;
            } else if (setting.vertical == VerticalValue.rl) {
                ++this._rightSamples;
            }
        } else if (setting.line.percentage.value() == 100.0 && setting.position.value() == 0.0) {
            if (setting.vertical == VerticalValue.lr) {
                ++this._rightSamples;
            } else if (setting.vertical == VerticalValue.rl) {
                ++this._leftSamples;
            }
        } else if (0.0 <= setting.line.percentage.value() && setting.line.percentage.value() <= 50.0) {
            ++this._topSamples;
        } else {
            ++this._bottomSamples;
        }
    }

    @Override
    public void endDocument() {
        super.endDocument();
        this._doc.setTopSamplesCount(this._topSamples);
        this._doc.setBottomSamplesCount(this._bottomSamples);
        this._doc.setLeftSamplesCount(this._leftSamples);
        this._doc.setRightSamplesCount(this._rightSamples);
        this._doc.setHasVerticals(this._leftSamples > 0L || this._rightSamples > 0L);
    }

    @Override
    public void foundStyle(String selectorName, String styleString) {
        this._doc.addStyle(selectorName, styleString);
    }
}

