/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt.VTTParser;

import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTParserAction;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTParserException;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTSettings.CueSetting;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class VTTParser {
    private state _state = state.init;
    private static Pattern headerPattern = Pattern.compile("\r?\n?\\s*WEBVTT(\\s-\\s.*)");
    private static Pattern timeStampPattern = Pattern.compile("([0-9]{2}):([0-9]{2}):([0-9]{2}[.][0-9]{1,3})|([0-9]{2})");
    private static Pattern sampleIndexPattern = Pattern.compile("\\d+");
    private static Pattern rubyPattern = Pattern.compile("(?i)\\p{all}+\\bruby\\b>\\p{all}+<\\brt\\b>\\p{all}+\\brt\\b>\\p{all}+\\bruby\\b>.*");
    private static Pattern vttStylePattern = Pattern.compile("::cue(\\([\\w|.|\\-]+\\))*\\s*\\{(\\s*[\\w|#|\\-|\\:|\\s|,|;|\"|\\.|\\(|\\)]+)\\}\\s*");
    private VTTParserAction _action;

    public VTTParser(VTTParserAction action) {
        this._action = action;
    }

    public void parse(SeekableDataInput sdi) throws FileNotFoundException, IOException {
        String aline = sdi.readLine();
        String vttHeader = new String(aline.getBytes("ISO-8859-1"), "UTF-8");
        Matcher headerMatcher = headerPattern.matcher(vttHeader);
        if (!headerMatcher.matches()) {
            throw new VTTParserException("bad header:" + vttHeader, 1L);
        }
        try {
            this.captureMagicNote(headerMatcher.group(1));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new VTTParserException("bad vtt file", ex);
        }
        boolean done = false;
        int[] transition = new int[]{1, 0};
        boolean parsingStyles = false;
        int curState = 0;
        long[] p = new long[]{0L, 0L};
        int lineNumber = 1;
        while (!done) {
            aline = sdi.readLine();
            ++lineNumber;
            if (aline == null) {
                done = true;
                continue;
            }
            if (aline.isEmpty()) {
                if (!parsingStyles) continue;
                parsingStyles = false;
                continue;
            }
            if ("STYLE".equals(aline)) {
                parsingStyles = true;
                continue;
            }
            if (parsingStyles) {
                String vttStyle = new String(aline.getBytes("ISO-8859-1"), "UTF-8");
                Matcher styleMatcher = vttStylePattern.matcher(vttStyle);
                if (!styleMatcher.matches()) {
                    throw new VTTParserException("bad style:" + vttStyle, (long)lineNumber);
                }
                try {
                    String selectorName = styleMatcher.group(1);
                    selectorName = Strings.isNullOrEmpty((String)selectorName) ? "allCuesSelectorITunesStore201687387357" : StringUtils.strip((String)selectorName, (String)"()");
                    this._action.foundStyle(selectorName, styleMatcher.group(2));
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new VTTParserException("bad style:" + vttStyle, ex);
                }
            }
            String line = new String(aline.getBytes("ISO-8859-1"), "UTF-8");
            try {
                if (curState == 0) {
                    if (StringUtils.contains((CharSequence)line, (CharSequence)"-->")) {
                        p = this.parseTimeCue(line);
                        curState = transition[curState];
                        this._action.foundCueTiming(p[0], p[1]);
                    } else if (sampleIndexPattern.matcher(line).matches()) {
                        this._action.foundCueID(line);
                    }
                }
                if (curState != true) continue;
                if (StringUtils.contains((CharSequence)line, (CharSequence)"-->")) {
                    String[] parts = line.split("\\s+");
                    String cueSettingsString = Joiner.on((String)" ").join((Object[])Arrays.copyOfRange(parts, 3, parts.length));
                    this._action.foundCueSettings(CueSetting.fromString(cueSettingsString), cueSettingsString);
                    continue;
                }
                if (sampleIndexPattern.matcher(line).matches()) {
                    this._action.foundCueID(line);
                    curState = transition[curState];
                    this._action.endCue();
                    continue;
                }
                if (line.isEmpty()) continue;
                this._action.foundCueText(line);
                this.checkPayload(line);
            }
            catch (Exception ex) {
                throw new VTTParserException(String.format("Error parsing line number %d:\"%s\"\n", lineNumber, line), ex);
            }
        }
        this._action.endCue();
        this._action.endDocument();
    }

    public void parse(URI uri) throws IOException, URISyntaxException {
        this.parse(SeekableDataInput.Factory.fromURI((URI)uri));
    }

    public void parse(File file) throws IOException, URISyntaxException {
        URI fileURI = new URI("file://" + file.getAbsolutePath());
        this.parse(SeekableDataInput.Factory.fromURI((URI)fileURI));
    }

    private boolean checkMagic(String line) {
        return false;
    }

    private void captureMagicNote(String line) {
        this._action.setHeaderMessage(line);
    }

    private long[] parseTimeCue(String input) throws VTTParserException {
        String[] parts = input.split("\\s+");
        if (!"-->".equals(parts[1])) {
            throw new VTTParserException("Missing '-->' in the cue header");
        }
        long start = this.parseTimeStamp(parts[0]);
        long end = this.parseTimeStamp(parts[2]);
        return new long[]{start, end};
    }

    private long parseTimeStamp(String input) throws VTTParserException {
        Matcher match = timeStampPattern.matcher(input);
        if (!match.matches()) {
            throw new VTTParserException("Invalid time string:" + input);
        }
        long hh = Long.valueOf(match.group(1));
        long mm = Long.valueOf(match.group(2));
        double ss = Double.valueOf(match.group(3));
        long milliseconds = Math.round(ss * 1000.0);
        milliseconds += 60000L * mm;
        return milliseconds += 3600000L * hh;
    }

    @Nonnull
    private String[] parseCueSettingValues(@Nonnull String cueSetting) {
        return cueSetting.split(",");
    }

    protected CueElementModifier determineCueModifier(String value, boolean hasVerticals) throws NumberFormatException {
        boolean moreThanHalfLinePercentage;
        String[] lineAttributes = value.split(",");
        String lineValue = lineAttributes[0];
        float linePercentage = lineValue.endsWith("%") ? this.parsePercentage(lineValue) : (float)(Integer.parseInt(lineValue) * 100);
        boolean bl = moreThanHalfLinePercentage = linePercentage > 50.0f;
        CueElementModifier cueElementModifier = hasVerticals ? (moreThanHalfLinePercentage ? CueElementModifier.LEFT : CueElementModifier.RIGHT) : (moreThanHalfLinePercentage ? CueElementModifier.END : CueElementModifier.START);
        return cueElementModifier;
    }

    private float parsePercentage(String s) throws NumberFormatException {
        if (!s.endsWith("%")) {
            throw new NumberFormatException("Percentages must end with %");
        }
        s = s.substring(0, s.length() - 1);
        return Float.parseFloat(s);
    }

    private void checkPayload(String line) throws VTTParserException {
        if (line == null) {
            return;
        }
        this._action.setHasRuby(this.isThereRubyContent(line));
    }

    private boolean isThereRubyContent(String line) {
        return rubyPattern.matcher(line).matches();
    }

    private static enum state {
        init,
        header,
        body;

    }

    public static enum CueElementModifier {
        START("start", 0),
        END("end", 1),
        LEFT("left", 2),
        RIGHT("right", 3),
        MIDDLE("middle", 4),
        INVALID("", -1);

        public final String value;
        public final int index;

        private CueElementModifier(String _value, int _index) {
            this.value = _value;
            this.index = _index;
        }
    }
}

