/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import com.apple.jingle.leghorn.subtitle.webvtt.ittStyle;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class VTTHelper {
    public static final String NONAME_SELECTOR = "allCuesSelectorITunesStore201687387357";

    public static String ittStyleToVTTStyleString(ittStyle style) {
        ArrayList<String> settings = new ArrayList<String>();
        if (!(Strings.isNullOrEmpty((String)style._color) || "white".equals(style._color) || "rgb(255,255,255)".equals(style._color))) {
            settings.add("color:" + style._color);
        }
        if (!Strings.isNullOrEmpty((String)style._fontWeight) && "bold".equals(style._fontWeight)) {
            settings.add("font-weight:bold");
        }
        if (!Strings.isNullOrEmpty((String)style._fontStyle) && "italic".equals(style._fontStyle)) {
            settings.add("font-style:italic");
        }
        if (!Strings.isNullOrEmpty((String)style._textDecoration) && "underline".equals(style._textDecoration)) {
            settings.add("text-decoration-line:underline");
        }
        if (!Strings.isNullOrEmpty((String)style._rubyAlign)) {
            String retString = "";
            if ("start".equals(style._rubyAlign) || "center".equals(style._rubyAlign)) {
                retString = style._rubyAlign;
            } else if ("spaceBetween".equals(style._rubyAlign)) {
                retString = "space-between";
            } else if ("spaceAround".equals(style._rubyAlign)) {
                retString = "space-around";
            } else {
                throw new IllegalArgumentException("Invalid rubyAlign value:" + style._rubyAlign);
            }
            settings.add("align:" + retString);
        }
        if (!Strings.isNullOrEmpty((String)style._rubyOffset)) {
            settings.add("offset:" + style._rubyOffset);
        }
        if (!Strings.isNullOrEmpty((String)style._rubyPosition)) {
            if ("before".equals(style._rubyPosition)) {
                settings.add("ruby-position:over");
            } else if ("after".equals(style._rubyPosition)) {
                settings.add("ruby-position:under");
            } else {
                throw new IllegalArgumentException("Invalid rubyPosition value:" + style._rubyPosition);
            }
        }
        if (!Strings.isNullOrEmpty((String)style._verticalCombine)) {
            settings.add("text-combine-upright:" + style._verticalCombine);
        }
        if (!Strings.isNullOrEmpty((String)style._bgColor)) {
            settings.add("background-color:" + style._bgColor);
        }
        if (!Strings.isNullOrEmpty((String)style._textEdgeStyle)) {
            settings.add(String.format("x-text-edge-style:\"%s\"", style._textEdgeStyle));
        }
        if (!(Strings.isNullOrEmpty((String)style._fontSize) || "100%".equals(style._fontSize) || "100".equals(style._fontSize))) {
            settings.add("font-size:" + StringUtils.strip((String)style._fontSize, (String)"%"));
        }
        if (!Strings.isNullOrEmpty((String)style._fontSizeDisplay)) {
            settings.add("x-font-size-display:" + style._fontSizeDisplay);
        }
        if (!Strings.isNullOrEmpty((String)style._fontFamily) && !style._fontFamily.toLowerCase().equals("sansserif")) {
            settings.add(String.format("font-family-name:\"%s\"", style._fontFamily));
        }
        if (!Strings.isNullOrEmpty((String)style._genericFontFamily)) {
            settings.add(String.format("x-generic-font-family:\"%s\"", style._genericFontFamily));
        }
        if (settings.size() == 0) {
            return "";
        }
        return Joiner.on((char)';').join(settings);
    }

    public static ittStyle VTTStyleStringToIttStyle(String styleString) {
        if (styleString.length() == 0) {
            return ittStyle.INVALID_STYLE;
        }
        List parts = Splitter.on((char)';').trimResults().omitEmptyStrings().splitToList((CharSequence)styleString);
        Splitter attSplit = Splitter.on((char)':').trimResults().omitEmptyStrings();
        if (parts.size() == 0) {
            return ittStyle.INVALID_STYLE;
        }
        ittStyle newStyle = new ittStyle();
        for (String s : parts) {
            List attribute = attSplit.splitToList((CharSequence)s);
            if (attribute.size() != 2) {
                throw new IllegalArgumentException("Invalid attribute:" + s);
            }
            switch ((String)attribute.get(0)) {
                case "color": {
                    newStyle._color = (String)attribute.get(1);
                    break;
                }
                case "align": {
                    String val = (String)attribute.get(1);
                    if ("start".equals(val) || "center".equals(val)) {
                        newStyle._rubyAlign = val;
                        break;
                    }
                    if ("space-between".equals(val)) {
                        newStyle._rubyAlign = "spaceBetween";
                        break;
                    }
                    if ("space-around".equals(val)) {
                        newStyle._rubyAlign = "spaceAround";
                        break;
                    }
                    throw new IllegalArgumentException("Invalid rubyAlign value:" + val);
                }
                case "offset": {
                    newStyle._rubyOffset = (String)attribute.get(1);
                    break;
                }
                case "text-combine-upright": {
                    newStyle._verticalCombine = (String)attribute.get(1);
                    break;
                }
                case "ruby-position": {
                    if ("over".equals(attribute.get(1))) {
                        newStyle._rubyPosition = "before";
                        break;
                    }
                    if ("under".equals(attribute.get(1))) {
                        newStyle._rubyPosition = "after";
                        break;
                    }
                    throw new IllegalArgumentException("Invalid attribute:" + s);
                }
                case "font-weight": {
                    if (!"bold".equals(attribute.get(1))) break;
                    newStyle._fontWeight = "bold";
                    break;
                }
                case "font-style": {
                    if (!"italic".equals(attribute.get(1))) break;
                    newStyle._fontStyle = "italic";
                    break;
                }
                case "text-decoration-line": {
                    if (!"underline".equals(attribute.get(1))) break;
                    newStyle._textDecoration = "underline";
                    break;
                }
                case "background-color": {
                    newStyle._bgColor = (String)attribute.get(1);
                    break;
                }
                case "x-text-edge-style": {
                    newStyle._textEdgeStyle = StringUtils.strip((String)((String)attribute.get(1)), (String)"\"");
                    break;
                }
                case "font-size": {
                    newStyle._fontSize = (String)attribute.get(1) + "%";
                    break;
                }
                case "x-font-size-display": {
                    newStyle._fontSizeDisplay = (String)attribute.get(1);
                    break;
                }
                case "font-family-name": {
                    newStyle._fontFamily = StringUtils.strip((String)((String)attribute.get(1)), (String)"\"");
                    break;
                }
                case "x-generic-font-family": {
                    newStyle._genericFontFamily = StringUtils.strip((String)((String)attribute.get(1)), (String)"\"");
                    break;
                }
            }
        }
        return newStyle;
    }

    public static ittStyle ItalicDefaultIttStyle() {
        return VTTHelper.VTTStyleStringToIttStyle("font-style:italic");
    }

    public static ittStyle BoldDefaultIttStyle() {
        return VTTHelper.VTTStyleStringToIttStyle("font-weight:bold");
    }

    public static ittStyle UnderlineDefaultIttStyle() {
        return VTTHelper.VTTStyleStringToIttStyle("text-decoration-line:underline");
    }
}

