/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import com.apple.jingle.leghorn.subtitle.webvtt.BreakStyledText;
import com.apple.jingle.leghorn.subtitle.webvtt.RubyContent;
import com.apple.jingle.leghorn.subtitle.webvtt.StyledString;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.TimeCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class TextElement
implements Iterable<StyledString> {
    public static final String FONTCOLOR = "fontColor";
    public static final String FONTFAMILY = "fontFamily";
    public static final String FONTSIZE = "fontSize";
    public static final String FONTSTYLE = "fontStyle";
    public static final String FONTWEIGHT = "fontWeight";
    public static final String ORIGIN = "origin";
    public static final String EXTENT = "extent";
    public static final String TEXTALIGN = "textAlign";
    public static final String DISPLAYALIGN = "displayAlign";
    public static final String WRITINGMODE = "writingMode";
    List<StyledString> _segments = new ArrayList<StyledString>();
    private TimeCode _showTime = SMPTETimeCode.UNDEFINED;
    private TimeCode _hideTime = SMPTETimeCode.UNDEFINED;
    private Map<String, Integer> _styleToIdx;

    public TextElement() {
    }

    public TextElement(String text) {
    }

    public TextElement santizeText() {
        int ii;
        if (this._segments.isEmpty()) {
            return this;
        }
        for (ii = 0; ii < this._segments.size() - 1; ++ii) {
            StyledString ss = this._segments.get(ii);
            ss.sanitizeText();
            if (!(this._segments.get(ii + 1) instanceof BreakStyledText)) continue;
            ss.trimRight();
        }
        for (ii = 1; ii < this._segments.size(); ++ii) {
            if (!(this._segments.get(ii - 1) instanceof BreakStyledText)) continue;
            this._segments.get(ii).trimLeft();
        }
        this._segments.get(this._segments.size() - 1).sanitizeText();
        this._segments.get(this._segments.size() - 1).trimRight();
        this._segments.get(0).trimLeft();
        return this;
    }

    public TextElement collapseStyles() {
        if (this._segments.isEmpty()) {
            return this;
        }
        String prevStyleName = "";
        ArrayList<StyledString> collapsedSegments = new ArrayList<StyledString>();
        for (StyledString ss : this._segments) {
            if (prevStyleName.equals(ss.styleName()) && !(collapsedSegments.get(collapsedSegments.size() - 1) instanceof RubyContent)) {
                ((StyledString)collapsedSegments.get(collapsedSegments.size() - 1)).cat(ss);
            } else {
                StyledString newString = null;
                newString = ss instanceof RubyContent ? new RubyContent((RubyContent)ss) : new StyledString(ss.export(), ss.styleName(), ss.regionName());
                collapsedSegments.add(newString);
            }
            prevStyleName = ss.styleName();
        }
        this._segments = collapsedSegments;
        return this;
    }

    public TextElement removeEmptySegments() {
        if (this._segments.isEmpty()) {
            return this;
        }
        ArrayList<StyledString> nonEmptySegments = new ArrayList<StyledString>();
        for (StyledString ss : this._segments) {
            if (ss.length() <= 0) continue;
            StyledString newString = ss instanceof RubyContent ? new RubyContent((RubyContent)ss) : new StyledString(ss.export(), ss.styleName(), ss.regionName());
            nonEmptySegments.add(newString);
        }
        this._segments = nonEmptySegments;
        return this;
    }

    public TextElement collapseBreaks() {
        if (this._segments.isEmpty()) {
            return this;
        }
        ArrayList<StyledString> collapsedSegments = new ArrayList<StyledString>();
        for (int ii = 0; ii < this._segments.size() - 1; ++ii) {
            StyledString ss = this._segments.get(ii);
            if (this._segments.get(ii + 1) instanceof BreakStyledText) {
                ss.cat((BreakStyledText)this._segments.get(ii + 1));
                ++ii;
            }
            collapsedSegments.add(ss);
        }
        StyledString ss = this._segments.get(this._segments.size() - 1);
        if (!(ss instanceof BreakStyledText)) {
            collapsedSegments.add(ss);
        }
        this._segments = collapsedSegments;
        return this;
    }

    public void appendStyledString(StyledString segment) {
        StyledString inSegment = segment;
        inSegment.sanitizeText();
        this._segments.add(inSegment);
        inSegment.setOrder(this._segments.size() - 1);
    }

    public void setPresentationTimes(TimeCode show, TimeCode hide) {
        this._showTime = show;
        this._hideTime = hide;
    }

    public TimeCode showTime() {
        return this._showTime;
    }

    public TimeCode hideTime() {
        return this._hideTime;
    }

    public MediaTime duration() {
        MediaTime begin = this._showTime.getMediaTime();
        MediaTime end = this._hideTime.getMediaTime();
        return end.timeBySubtractingTime(begin);
    }

    public int styleToIdx(String styleName) {
        if (this._segments.size() == 1) {
            return 1;
        }
        if (this._styleToIdx == null) {
            this._styleToIdx = new HashMap<String, Integer>();
            for (StyledString ss : this._segments) {
                if (this._styleToIdx.containsKey(ss.styleName())) continue;
                this._styleToIdx.put(ss.styleName(), this._styleToIdx.size() + 1);
            }
        }
        return this._styleToIdx.get(styleName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Segments:" + this._segments.size() + " ");
        builder.append("Begin:").append(this._showTime.getMediaTime().toString()).append(" End:").append(this._hideTime.getMediaTime().toString()).append("\n");
        ListIterator<StyledString> iter = this._segments.listIterator();
        if (iter.hasNext()) {
            builder.append(iter.next().toString());
        }
        while (iter.hasNext()) {
            builder.append("\n").append(iter.next().toString());
        }
        return builder.toString();
    }

    public String[] styles() {
        if (this._segments.size() == 1) {
            return new String[]{this._segments.get(0).styleName()};
        }
        ArrayList<String> unique = new ArrayList<String>();
        for (StyledString ss : this._segments) {
            if (unique.contains(ss.styleName())) continue;
            unique.add(ss.styleName());
        }
        return unique.toArray(new String[0]);
    }

    public String[] regions() {
        if (this._segments.size() == 1) {
            return new String[]{this._segments.get(0).regionName()};
        }
        ArrayList<String> unique = new ArrayList<String>();
        for (StyledString ss : this._segments) {
            if (unique.contains(ss.regionName())) continue;
            unique.add(ss.regionName());
        }
        return unique.toArray(new String[0]);
    }

    public int segmentCount() {
        return this._segments.size();
    }

    @Override
    public Iterator<StyledString> iterator() {
        return this._segments.iterator();
    }

    public StyledString segment(int index) {
        return this._segments.get(index);
    }

    public boolean isEmpty() {
        for (StyledString ss : this._segments) {
            if (ss.text().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

