/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser;

import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.TTMLException;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.TTMLParState;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;

public class TTMLCursorAdaptor {
    Stack<String> _stateStack = new Stack();
    private static String _rubyAttNameSpace = "http://namespace.itunes.apple.com/itt/ttml-extension/".replaceFirst("/$", "") + "#ruby";
    private static String _verticalAttNameSpace = "http://namespace.itunes.apple.com/itt/ttml-extension/".replaceFirst("/$", "") + "#vertical";
    private static String _ttmlStyleAttNameSpace = "http://namespace.itunes.apple.com/itt/ttml-extension/".replaceFirst("/$", "") + "#styling";
    private XmlCursor _cursor;

    public static TTMLCursorAdaptor factory(XmlCursor c) {
        return new TTMLCursorAdaptor(c);
    }

    public TTMLCursorAdaptor(XmlCursor c) {
        this._cursor = c;
        this._stateStack.removeAllElements();
    }

    public static String rubyAttNameSpace() {
        return _rubyAttNameSpace;
    }

    public static String verticalAttNameSpace() {
        return _verticalAttNameSpace;
    }

    public static String ttmlStyleAttNameSpace() {
        return _ttmlStyleAttNameSpace;
    }

    public int tokenValue() {
        return this._cursor.currentTokenType().intValue();
    }

    public XmlCursor get() {
        return this._cursor;
    }

    public String text() {
        return this._cursor.getTextValue();
    }

    public String name() {
        return this._cursor.getName().getLocalPart();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TTMLParState mapToState() throws TTMLException {
        if (this._cursor.currentTokenType().intValue() == 5) {
            return TTMLParState.TEXT;
        }
        if (this._cursor.currentTokenType() == XmlCursor.TokenType.START) {
            TTMLParState retState;
            QName qq = this._cursor.getName();
            String ss = qq.getLocalPart();
            if ("span".equalsIgnoreCase(ss)) {
                String kind = this._cursor.getAttributeText(new QName(_rubyAttNameSpace, "kind"));
                if (kind == null) {
                    retState = TTMLParState.SPAN;
                } else if ("ruby".equalsIgnoreCase(kind)) {
                    retState = TTMLParState.RUBY;
                    ss = "ruby";
                } else if ("rb".equalsIgnoreCase(kind)) {
                    retState = TTMLParState.RUBY_BASE;
                    ss = "rb";
                } else {
                    if (!"rt".equalsIgnoreCase(kind)) throw new TTMLException("Malformed paragraph tag");
                    retState = TTMLParState.RUBY_TEXT;
                    ss = "rt";
                }
            } else {
                if (!"br".equalsIgnoreCase(ss)) throw new TTMLException("Malformed paragraph tag");
                retState = TTMLParState.BR;
            }
            this._stateStack.push(ss);
            return retState;
        }
        String ss = this._stateStack.pop();
        if ("span".equalsIgnoreCase(ss)) {
            return TTMLParState.SPAN_END;
        }
        if ("br".equalsIgnoreCase(ss)) {
            return TTMLParState.BR_END;
        }
        if ("ruby".equalsIgnoreCase(ss)) {
            return TTMLParState.RUBY_END;
        }
        if ("rb".equalsIgnoreCase(ss)) {
            return TTMLParState.RUBY_BASE_END;
        }
        if (!"rt".equalsIgnoreCase(ss)) throw new TTMLException("Malformed paragraph tag");
        return TTMLParState.RUBY_TEXT_END;
    }

    public String style() {
        return this._cursor.getAttributeText(new QName("style"));
    }

    public String verticalCombine() {
        return this._cursor.getAttributeText(new QName(_verticalAttNameSpace, "combine"));
    }

    public String rubyPosition() {
        return this._cursor.getAttributeText(new QName(_rubyAttNameSpace, "position"));
    }

    public String rubyAlign() {
        return this._cursor.getAttributeText(new QName(_rubyAttNameSpace, "align"));
    }

    public String rubyOffset() {
        return this._cursor.getAttributeText(new QName(_rubyAttNameSpace, "offset"));
    }

    public Map<String, String> getRubyAttributes() {
        HashMap<String, String> ret = new HashMap<String, String>();
        String val = this._cursor.getAttributeText(new QName(_rubyAttNameSpace, "position"));
        if (val != null) {
            ret.put("position", val);
        }
        if ((val = this._cursor.getAttributeText(new QName(_rubyAttNameSpace, "align"))) != null) {
            ret.put("align", val);
        }
        if ((val = this._cursor.getAttributeText(new QName(_rubyAttNameSpace, "offset"))) != null) {
            ret.put("offset", val);
        }
        return ret;
    }

    public String toString() {
        QName qq = this._cursor.getName();
        String name = "[N/A]";
        if (qq != null) {
            name = qq.getLocalPart();
        }
        return super.toString() + String.format("Type:%s Name:%s", this._cursor.currentTokenType(), name);
    }
}

