/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser;

import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.CloseBreakAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.CloseRubyAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.CloseRubyBaseAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.CloseRubyTextAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.CloseSpanAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.FinishAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.InitAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.OpenBreakAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.OpenRubyAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.OpenRubyBaseAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.OpenRubyTextAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.OpenSpanAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.ParagraphParserStrategy;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.ParserStateAction;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.TTMLCursorAdaptor;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.TTMLException;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.TTMLParState;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.TextAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;

public class ParagraphParser {
    private TTMLParState _currentState;
    ParagraphParserStrategy _strategy;
    private Stack<TTMLParState> _stateHistory;
    private final Map<TTMLParState, ParserStateAction<TTMLParState>> stateActionMap = new HashMap<TTMLParState, ParserStateAction<TTMLParState>>();
    private static Logger log = Logger.getLogger(ParagraphParser.class);

    public static ParagraphParser factory(ParagraphParserStrategy strategy) {
        ParagraphParser parser = new ParagraphParser(strategy);
        parser.addAction(TTMLParState.INIT, new InitAction());
        parser.addAction(TTMLParState.FINISH, new FinishAction());
        parser.addAction(TTMLParState.TEXT, new TextAction());
        parser.addAction(TTMLParState.SPAN, new OpenSpanAction());
        parser.addAction(TTMLParState.SPAN_END, new CloseSpanAction());
        parser.addAction(TTMLParState.BR, new OpenBreakAction());
        parser.addAction(TTMLParState.BR_END, new CloseBreakAction());
        parser.addAction(TTMLParState.RUBY, new OpenRubyAction());
        parser.addAction(TTMLParState.RUBY_END, new CloseRubyAction());
        parser.addAction(TTMLParState.RUBY_BASE, new OpenRubyBaseAction());
        parser.addAction(TTMLParState.RUBY_BASE_END, new CloseRubyBaseAction());
        parser.addAction(TTMLParState.RUBY_TEXT, new OpenRubyTextAction());
        parser.addAction(TTMLParState.RUBY_TEXT_END, new CloseRubyTextAction());
        return parser;
    }

    private ParagraphParser(ParagraphParserStrategy s) {
        this._stateHistory = new Stack();
        this._strategy = s;
        this._currentState = TTMLParState.INIT;
    }

    public void processStream(XmlCursor c) throws TTMLException {
        log.debug((Object)("\nParagraph:\n" + c.xmlText()));
        TTMLCursorAdaptor cursor = new TTMLCursorAdaptor(c);
        cursor.get().toFirstContentToken();
        int elemCount = 1;
        while (elemCount > 0) {
            boolean processToken = false;
            switch (cursor.tokenValue()) {
                case 3: {
                    ++elemCount;
                    processToken = true;
                    break;
                }
                case 4: {
                    --elemCount;
                    processToken = true;
                    break;
                }
                case 5: {
                    processToken = true;
                }
            }
            if (processToken) {
                if (elemCount > 0) {
                    log.trace((Object)cursor);
                    ParserStateAction<TTMLParState> action = this.stateActionMap.get((Object)this._currentState);
                    this._currentState = action.HandleNode(cursor, this._currentState);
                } else if (this._strategy.stringsCount() == 0) {
                    this._strategy.AppendText("");
                    this._strategy.StoreText();
                }
            }
            cursor.get().toNextToken();
            if (cursor.tokenValue() != 2) continue;
            if (elemCount != 0) break;
        }
        this.stateActionMap.get((Object)this._currentState).terminate(this._currentState);
    }

    public void addAction(TTMLParState state2, ParserStateAction<TTMLParState> action) {
        action.setStrategy(this._strategy);
        action.setStateHistory(this._stateHistory);
        this.stateActionMap.put(state2, action);
    }

    public void removeAction(ParserStateAction<TTMLParState> action) {
        this.stateActionMap.remove(action);
    }
}

