/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TTMLColorMapper {
    static Map<String, Integer> _nameToVal = new HashMap<String, Integer>();
    public static final String TRANSPARENT = "transparent";
    public static final String BLACK = "black";
    public static final String SILVER = "silver";
    public static final String GRAY = "gray";
    public static final String WHITE = "white";
    public static final String YELLOW = "yellow";
    public static final String MAROON = "maroon";
    public static final String RED = "red";
    public static final String PURPLE = "purple";
    public static final String FUCHSIA = "fuchsia";
    public static final String MAGENTA = "magenta";
    public static final String GREEN = "green";
    public static final String LIME = "lime";
    public static final String OLIVE = "olive";
    public static final String NAVY = "navy";
    public static final String BLUE = "blue";
    public static final String TEAL = "teal";
    public static final String AQUA = "aqua";
    public static final String CYAN = "cyan";
    private static final Pattern RGB_PATTERN = Pattern.compile("rgb\\((\\d{1,3}),(\\d{1,3}),(\\d{1,3})\\)");
    private static final Pattern RGBA_PATTERN = Pattern.compile("rgba\\((\\d{1,3}),(\\d{1,3}),(\\d{1,3}),(\\d{1,3})\\)");
    private static final Pattern HEX_PATTERN = Pattern.compile("#([a-f\\d]{2})([a-f\\d]{2})([a-f\\d]{2})([a-f\\d]{2})?");

    public static void build() {
        _nameToVal.put(TRANSPARENT, 0);
        _nameToVal.put(BLACK, 255);
        _nameToVal.put(SILVER, -1061109505);
        _nameToVal.put(GRAY, -2139062017);
        _nameToVal.put(WHITE, -1);
        _nameToVal.put(YELLOW, -65281);
        _nameToVal.put(MAROON, -2147483393);
        _nameToVal.put(RED, -16776961);
        _nameToVal.put(PURPLE, -2147450625);
        _nameToVal.put(FUCHSIA, -16711681);
        _nameToVal.put(MAGENTA, -16711681);
        _nameToVal.put(GREEN, 0x8000FF);
        _nameToVal.put(LIME, 0xFF00FF);
        _nameToVal.put(OLIVE, -2139094785);
        _nameToVal.put(NAVY, 33023);
        _nameToVal.put(BLUE, 65535);
        _nameToVal.put(TEAL, 0x8080FF);
        _nameToVal.put(AQUA, 0xFFFFFF);
        _nameToVal.put(CYAN, 0xFFFFFF);
    }

    public static String ColorStringToPercentString(String nameClr) {
        String name = nameClr.toLowerCase();
        return TTMLColorMapper.intToPercentString(TTMLColorMapper.ColorStringToInteger(name));
    }

    public static int ColorStringToInteger(String nameClr) {
        if (nameClr != null && !nameClr.isEmpty()) {
            String name = nameClr.toLowerCase();
            Matcher matcher = RGB_PATTERN.matcher(name);
            if (matcher.matches()) {
                return TTMLColorMapper.parseRGB(matcher);
            }
            matcher = RGBA_PATTERN.matcher(name);
            if (matcher.matches()) {
                return TTMLColorMapper.parseRGBA(matcher);
            }
            matcher = HEX_PATTERN.matcher(name);
            if (matcher.matches()) {
                return TTMLColorMapper.parseHex(matcher);
            }
            if (_nameToVal.containsKey(nameClr)) {
                return _nameToVal.get(name);
            }
        }
        throw new IllegalArgumentException("Invalid color:" + nameClr);
    }

    public static String intToPercentString(int value) {
        int a = value & 0xFF;
        a = (int)Math.ceil((double)(100 * a) / 255.0);
        int b = value >>> 8 & 0xFF;
        b = (int)Math.ceil((double)(100 * b) / 255.0);
        int g = value >>> 16 & 0xFF;
        g = (int)Math.ceil((double)(100 * g) / 255.0);
        int r = value >>> 24 & 0xFF;
        r = (int)Math.ceil((double)(100 * r) / 255.0);
        return String.format("%d%%, %d%%, %d%%, %d%%", r, g, b, a);
    }

    private static int parseRGB(Matcher matcher) {
        String[] parts = new String[]{matcher.group(1), matcher.group(2), matcher.group(3), "255"};
        return TTMLColorMapper.parseRGBAHelper(parts);
    }

    private static int parseRGBA(Matcher matcher) {
        String[] parts = new String[]{matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4)};
        return TTMLColorMapper.parseRGBAHelper(parts);
    }

    private static int parseRGBAHelper(String[] parts) {
        if (parts.length != 4) {
            throw new IllegalArgumentException("Arguments needs to have components per color");
        }
        int r = Math.min(Integer.parseInt(parts[0]), 255);
        int g = Math.min(Integer.parseInt(parts[1]), 255);
        int b = Math.min(Integer.parseInt(parts[2]), 255);
        int a = Math.min(Integer.parseInt(parts[3]), 255);
        return (r << 24) + (g << 16) + (b << 8) + a;
    }

    private static int parseHex(Matcher matcher) {
        String red = matcher.group(1);
        String green = matcher.group(2);
        String blue = matcher.group(3);
        String alpha = matcher.group(4) != null ? matcher.group(4) : "ff";
        int r = Math.min(Integer.parseInt(red, 16), 255);
        int g = Math.min(Integer.parseInt(green, 16), 255);
        int b = Math.min(Integer.parseInt(blue, 16), 255);
        int a = Math.min(Integer.parseInt(alpha, 16), 255);
        return (r << 24) + (g << 16) + (b << 8) + a;
    }

    static {
        TTMLColorMapper.build();
    }
}

