/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import com.apple.jingle.leghorn.subtitle.webvtt.BreakStyledText;
import java.util.HashMap;
import java.util.Map;

public class StyledString {
    protected String _text;
    protected String _styleName;
    protected String _regionName;
    protected int _order = -1;
    protected Map<String, String> _attr = new HashMap<String, String>();

    public StyledString() {
    }

    public StyledString(String text, String styleName, String regionName) {
        this._order = -1;
        this._text = text;
        this._styleName = styleName;
        this._regionName = regionName;
    }

    public StyledString sanitizeText() {
        if (this._text.length() == 1 && " ".compareTo(this._text) == 0) {
            return this;
        }
        this._text = this._text.replaceAll("\n", "").replaceAll("<br/>", "\r");
        return this;
    }

    public StyledString escapeLessGreaterThan() {
        this._text = this._text.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        return this;
    }

    public StyledString trimLeft() {
        if (this._text.length() == 1 && " ".compareTo(this._text) == 0) {
            return this;
        }
        this._text = this._text.replaceAll("^\\s+", "");
        return this;
    }

    public StyledString trimRight() {
        if (this._text.length() == 1 && " ".compareTo(this._text) == 0) {
            return this;
        }
        this._text = this._text.replaceAll("\\s+$", "");
        return this;
    }

    public StyledString trim() {
        if (this._text.length() == 1 && " ".compareTo(this._text) == 0) {
            return this;
        }
        this._text = this._text.replaceAll("^\\s+", "").replaceAll("\\s+$", "");
        return this;
    }

    public void trimTrailingNewLine() {
        if (this._text.length() > 0 && this._text.endsWith("\r")) {
            this._text = this._text.substring(0, this._text.length() - 1);
        }
    }

    public void cat(StyledString ss) {
        if (!this._styleName.equals(ss._styleName) || !this._regionName.equals(ss._regionName)) {
            throw new IllegalArgumentException("Can not concatenate two StyledString with different styles or regions.");
        }
        this._text = this._text + ss.export();
    }

    public void cat(BreakStyledText ss) {
        this._text = this._text + "\r";
    }

    public String text() {
        return this._text;
    }

    public String styleName() {
        return this._styleName;
    }

    public void setStyleName(String styleName) {
        this._styleName = styleName;
    }

    public String regionName() {
        return this._regionName;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public int order() {
        return this._order;
    }

    public String export() {
        return this._text;
    }

    public int length() {
        return this._text.length();
    }

    public String toString() {
        return String.format("order:%d Style:%s Region:%s text:%s", this._order, this._styleName, this._regionName, this._text);
    }

    public Map<String, String> attributes() {
        return this._attr;
    }

    public void setAttributes(Map<String, String> a) {
        this._attr.clear();
        this._attr.putAll(a);
    }
}

