/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import com.apple.jingle.leghorn.subtitle.webvtt.BreakStyledText;
import com.apple.jingle.leghorn.subtitle.webvtt.RubyText;
import com.apple.jingle.leghorn.subtitle.webvtt.StyledString;

public class RubyContent
extends StyledString {
    RubyText _annotation;
    String _appendedText = "";

    public RubyContent(String text, String styleName, String regionName) {
        super(text, styleName, regionName);
    }

    public RubyContent(RubyContent rc) {
        super(rc._text, rc.styleName(), rc.regionName());
        this._annotation = rc._annotation;
        this._appendedText = rc._appendedText;
    }

    public void setAnnotation(RubyText ann) {
        this._annotation = ann;
    }

    public RubyText annotation() {
        return this._annotation;
    }

    public String appendedText() {
        return this._appendedText;
    }

    public boolean isValid() {
        return this._text != null;
    }

    public void setText(String text) {
        this._text = text;
    }

    @Override
    public RubyContent sanitizeText() {
        super.sanitizeText();
        return this;
    }

    @Override
    public StyledString escapeLessGreaterThan() {
        super.sanitizeText();
        this._annotation.setText(this._annotation.text().replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
        this._appendedText = this._appendedText.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        return this;
    }

    @Override
    public String export() {
        if (this._annotation == null) {
            return "";
        }
        return String.format("<ruby>%s%s</ruby>", this._text, this._annotation.toString()) + this._appendedText;
    }

    @Override
    public void cat(BreakStyledText ss) {
        this._appendedText = this._appendedText + "\r";
    }

    public void cat2(BreakStyledText ss) {
        this._appendedText = this._appendedText + "\r";
    }

    @Override
    public String toString() {
        if (this._text == null || this._annotation == null) {
            return null;
        }
        String retString = String.format("order:%d Style:%s Region:%s <ruby>%s%s</ruby>", this._order, this._styleName, this._regionName, this._text, this._annotation.toString());
        retString = retString + this._appendedText;
        return retString;
    }

    @Override
    public int length() {
        return super.length() + this._annotation.length() + this._appendedText.length();
    }
}

