/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import com.apple.jingle.leghorn.subtitle.webvtt.LengthTuplet;
import com.apple.jingle.leghorn.subtitle.webvtt.StyledString;
import com.apple.jingle.leghorn.subtitle.webvtt.TextElement;
import com.apple.jingle.leghorn.subtitle.webvtt.ittRegion;
import com.apple.jingle.leghorn.subtitle.webvtt.ittStyle;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.MillisTimeCode;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.TimeCode;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class ReadableAsset
implements Iterable<TextElement> {
    private Map<String, ittStyle> _namedStyles = new HashMap<String, ittStyle>();
    private Map<String, ittRegion> _namedRegions = new HashMap<String, ittRegion>();
    private Map<String, Object> _attributes = new HashMap<String, Object>();
    private List<TextElement> _contents = new ArrayList<TextElement>();
    private boolean _timeOffsetApplied = false;
    private boolean _hasTopPositionSubtitles = false;
    public static final String ITMS_DEF_STYLE_NAME = "itmsNormalStyle";
    public static final String ITMS_DEF_REGION_NAME = "itmsBottomRegion";

    public ReadableAsset() {
        ittStyle s = new ittStyle();
        s._id = ITMS_DEF_STYLE_NAME;
        s._fontFamily = "sansSerif";
        s._fontWeight = "normal";
        s._fontStyle = "normal";
        s._color = "white";
        s._fontSize = "100%";
        this._namedStyles.put(ITMS_DEF_STYLE_NAME, s);
        ittRegion r = new ittRegion();
        r._style = new ittStyle();
        r._style._textAlign = "center";
        r._style._displayAlign = "after";
        r._style._origin = "0% 85%";
        r._style._extent = "100% 15%";
        r._style._id = ITMS_DEF_REGION_NAME;
        r._id = ITMS_DEF_REGION_NAME;
        this._namedRegions.put(ITMS_DEF_REGION_NAME, r);
    }

    public boolean timeOffsetApplied() {
        return this._timeOffsetApplied;
    }

    public boolean hasTimeOffset() {
        return this._attributes.get("displayTimeBegin") != null;
    }

    public Object attribute(String attrName) {
        return this._attributes.get(attrName);
    }

    public void setAttribute(String attrName, Object attrValue) {
        this._attributes.put(attrName, attrValue);
    }

    public void appendTextElement(TextElement elem) {
        this._contents.add(elem);
        if (!this._hasTopPositionSubtitles) {
            this._hasTopPositionSubtitles = ArrayUtils.contains((Object[])elem.regions(), (Object)"top") || ArrayUtils.contains((Object[])elem.regions(), (Object)"Top");
        }
    }

    public void reset() {
        this._contents.clear();
        this._attributes.clear();
    }

    public void addStyle(ittStyle s) {
        this._namedStyles.put(s._id, s);
    }

    public void setStyles(Collection<ittStyle> ss) {
        this._namedStyles.clear();
        for (ittStyle s : ss) {
            this.addStyle(s);
        }
    }

    public ittStyle style(String styleName) {
        return this._namedStyles.get(styleName);
    }

    public Collection<ittStyle> allStyles() {
        return this._namedStyles.values();
    }

    public boolean isStyleDefined(String styleName) {
        return this._namedStyles.containsKey(styleName);
    }

    public String getDefaultStyleName() {
        return ITMS_DEF_STYLE_NAME;
    }

    public void addRegion(ittRegion region) {
        this._namedRegions.put(region._id, region);
    }

    public void setRegions(Collection<ittRegion> ss) {
        this._namedRegions.clear();
        for (ittRegion s : ss) {
            this.addRegion(s);
        }
    }

    public ittRegion region(String regionName) {
        return this._namedRegions.get(regionName);
    }

    public Collection<ittRegion> allRegions() {
        return this._namedRegions.values();
    }

    public boolean isRegionDefined(String regionName) {
        return this._namedRegions.containsKey(regionName);
    }

    public String getDefaultRegionName() {
        return ITMS_DEF_REGION_NAME;
    }

    @Override
    public Iterator<TextElement> iterator() {
        return this._contents.iterator();
    }

    public int textElementCount() {
        return this._contents.size();
    }

    public TextElement textElement(int ii) {
        return this._contents.get(ii);
    }

    public int[] findEntrysInInterval(long beginMS, long endMS) {
        long[] bs = new long[this._contents.size()];
        long[] es = new long[this._contents.size()];
        int idx = 0;
        for (TextElement te : this._contents) {
            bs[idx] = te.showTime().getTotalMilliseconds();
            es[idx] = te.hideTime().getTotalMilliseconds();
            ++idx;
        }
        int bidx = Arrays.binarySearch(bs, beginMS);
        int eidx = Arrays.binarySearch(es, endMS);
        if (bidx < 0 && (bidx = -(bidx + 1)) > 0 && beginMS < bs[bidx - 1]) {
            --bidx;
        }
        if (eidx < 0) {
            if ((eidx = -(eidx + 1)) == this._contents.size() - 1) {
                if (endMS < es[eidx]) {
                    // empty if block
                }
            } else if (eidx >= this._contents.size()) {
                eidx = this._contents.size() - 1;
            }
        }
        return new int[]{bidx, --eidx};
    }

    public void offsetSampleTime(long milli) {
        for (TextElement e : this._contents) {
            MillisTimeCode show = MillisTimeCode.parseMillis(e.showTime().getTotalMilliseconds() + milli);
            MillisTimeCode hide = MillisTimeCode.parseMillis(e.hideTime().getTotalMilliseconds() + milli);
            e.setPresentationTimes(show, hide);
        }
    }

    public String timerangesWithinPeriod(MediaTime periodStartMediaTime, MediaTime durationMediaTime, int maxNumberOfRanges) {
        String timeranges = "";
        if (!this._contents.isEmpty() && periodStartMediaTime.getSampleCount() >= 0L && durationMediaTime.getSampleCount() >= 0L && maxNumberOfRanges > 0) {
            long startMilliseconds = periodStartMediaTime.getTotalMilliseconds();
            long endMilliseconds = periodStartMediaTime.getTotalMilliseconds() + durationMediaTime.getTotalMilliseconds();
            TimeCode displayBeginOffset = (TimeCode)this._attributes.get("displayTimeBegin");
            ArrayList<TextElement> elementsInPeriod = new ArrayList<TextElement>();
            for (TextElement subtitleElement : this._contents) {
                TimeCode elementHideTimeCode;
                TimeCode elementStartTimeCode;
                if (!this._timeOffsetApplied && displayBeginOffset != null) {
                    elementStartTimeCode = this.applyOffset(subtitleElement.showTime(), displayBeginOffset);
                    elementHideTimeCode = this.applyOffset(subtitleElement.hideTime(), displayBeginOffset);
                } else {
                    elementStartTimeCode = subtitleElement.showTime();
                    elementHideTimeCode = subtitleElement.hideTime();
                }
                if (elementStartTimeCode.getTotalMilliseconds() < startMilliseconds || elementHideTimeCode.getTotalMilliseconds() > endMilliseconds) continue;
                TextElement subtitleElementInPeriod = new TextElement();
                MillisTimeCode showTimecode = MillisTimeCode.parseMillis(elementStartTimeCode.getTotalMilliseconds());
                MillisTimeCode hideTimecode = MillisTimeCode.parseMillis(elementHideTimeCode.getTotalMilliseconds());
                subtitleElementInPeriod.setPresentationTimes(showTimecode, hideTimecode);
                for (StyledString ss : subtitleElement._segments) {
                    subtitleElementInPeriod.appendStyledString(ss);
                }
                elementsInPeriod.add(subtitleElementInPeriod);
            }
            Collections.sort(elementsInPeriod, new Comparator<TextElement>(){

                @Override
                public int compare(TextElement o1, TextElement o2) {
                    return Integer.compare(o2.toString().trim().replaceAll("\\s+", " ").length(), o1.toString().trim().replaceAll("\\s+", " ").length());
                }
            });
            int numberOfRanges = 0;
            StringBuilder sb = new StringBuilder("");
            for (TextElement subtitleElementInPeriod : elementsInPeriod) {
                if (numberOfRanges >= maxNumberOfRanges) continue;
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(String.format("%d:%d", subtitleElementInPeriod.showTime().getTotalMilliseconds(), subtitleElementInPeriod.hideTime().getTotalMilliseconds()));
                ++numberOfRanges;
            }
            timeranges = sb.toString();
        }
        return timeranges;
    }

    public void applyTimeOffset() {
        TimeCode displayBeginOffset = null;
        if (this._attributes.get("displayTimeBegin") == null) {
            return;
        }
        if (!this._timeOffsetApplied) {
            displayBeginOffset = (TimeCode)this._attributes.get("displayTimeBegin");
            for (TextElement e : this._contents) {
                TimeCode show = this.applyOffset(e.showTime(), displayBeginOffset);
                TimeCode hide = this.applyOffset(e.hideTime(), displayBeginOffset);
                e.setPresentationTimes(show, hide);
            }
            this._timeOffsetApplied = true;
        }
    }

    private TimeCode applyOffset(TimeCode op1, TimeCode op2) {
        if (((SMPTETimeCode)op1).getMode() != ((SMPTETimeCode)op2).getMode()) {
            throw new IllegalArgumentException("Can not substract timecodes with different frame drop modes");
        }
        SMPTETimeCode.Mode mode = ((SMPTETimeCode)op1).getMode();
        return new SMPTETimeCode(op1.getMediaTime().timeByAddingTime(op2.getMediaTime()), mode);
    }

    private String formatMap(Map<String, ?> m) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, ?> e : m.entrySet()) {
            builder.append(e.getKey()).append("->").append(e.getValue().toString()).append("\n");
        }
        return builder.toString();
    }

    private String formatList(List<?> m) {
        StringBuilder builder = new StringBuilder();
        ListIterator<?> iter = m.listIterator();
        while (iter.hasNext()) {
            builder.append(iter.next().toString()).append("\n\n");
        }
        return builder.toString();
    }

    public void postProcess() {
        for (TextElement te : this._contents) {
            ReadableAsset.postProcessElement(te);
        }
        this.adjustTCYLen();
    }

    public static TextElement postProcessElement(TextElement te) {
        return te.santizeText().collapseBreaks().collapseStyles().removeEmptySegments();
    }

    private List<StyledString> findStringWithStyleInSet(Set<String> interestingStyles) {
        ArrayList<StyledString> ret = new ArrayList<StyledString>();
        for (TextElement te : this._contents) {
            for (StyledString ss : te) {
                if (!interestingStyles.contains(ss.styleName())) continue;
                ret.add(ss);
            }
        }
        return ret;
    }

    private void adjustTCYLen() {
        HashSet<String> interestingStyles = new HashSet<String>();
        HashSet<String> stylesToRemove = new HashSet<String>();
        for (Map.Entry<String, ittStyle> styleEntry : this._namedStyles.entrySet()) {
            ittStyle styleValue = styleEntry.getValue();
            if (Strings.isNullOrEmpty((String)styleValue._verticalCombine) || !styleValue._verticalCombine.equals("all") && !styleValue._verticalCombine.equals("0")) continue;
            interestingStyles.add(styleEntry.getKey());
        }
        List<StyledString> tcyss = this.findStringWithStyleInSet(interestingStyles);
        for (StyledString ss : tcyss) {
            String newStyleName;
            String as = ss.text();
            int len = Math.min(as.trim().length(), 4);
            stylesToRemove.add(ss.styleName());
            ittStyle newStyle = new ittStyle(this._namedStyles.get(ss.styleName()));
            newStyle._id = newStyleName = ss.styleName() + "itms" + String.valueOf(len);
            newStyle._verticalCombine = String.valueOf(len);
            if (!this._namedStyles.containsKey(newStyleName)) {
                this._namedStyles.put(newStyleName, newStyle);
            }
            ss.setStyleName(newStyleName);
        }
        for (String styleName : stylesToRemove) {
            this._namedStyles.remove(styleName);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return builder.append("Styles:\n").append(this.formatMap(this._namedStyles)).append("Regions:\n").append(this.formatMap(this._namedRegions)).append("Attributes:\n").append(this._attributes.toString()).append("\nContents:\n").append(this.formatList(this._contents)).toString();
    }

    public boolean hasTopPositionSubtitles() {
        return this._hasTopPositionSubtitles;
    }

    public BasicDisplayArea getStyledStringDisplayArea(StyledString ss) {
        ittRegion region = this._namedRegions.get(ss.regionName());
        if (region != null && region._style != null) {
            ittStyle style = region._style;
            LengthTuplet tuple = new LengthTuplet(style._origin);
            if (tuple.getY() < 50.0) {
                if (tuple.getX() == 0.0) {
                    return BasicDisplayArea.TOP;
                }
                if (tuple.getX() > 0.0 && tuple.getX() < 50.0) {
                    return BasicDisplayArea.LEFT;
                }
                return BasicDisplayArea.RIGHT;
            }
            return BasicDisplayArea.BOTTOM;
        }
        return BasicDisplayArea.BOTTOM;
    }

    public boolean hasTCYStyle(StyledString ss) {
        ittStyle style = this._namedStyles.get(ss.styleName());
        if (style == null) {
            return false;
        }
        return !Strings.isNullOrEmpty((String)style._verticalCombine);
    }

    public static enum BasicDisplayArea {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

