/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import com.apple.jingle.leghorn.subtitle.webvtt.BreakStyledText;
import com.apple.jingle.leghorn.subtitle.webvtt.RubyContent;
import com.apple.jingle.leghorn.subtitle.webvtt.RubyText;
import com.apple.jingle.leghorn.subtitle.webvtt.StyledString;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.ParagraphParserStrategy;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLParagraphParser.TTMLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class PopulateTextElementStrategy
implements ParagraphParserStrategy {
    private List<StyledString> _strings = new ArrayList<StyledString>();
    private RubyContent _curRuby;
    private Map<String, String> _rubyAttr = null;
    private Stack<String> _styleStack;
    private Stack<String> _regionStack;
    StringBuilder _sb = new StringBuilder();

    public String toString() {
        return this._strings.toString();
    }

    public void setStacks(Stack<String> style, Stack<String> region) {
        this._styleStack = (Stack)style.clone();
        this._regionStack = (Stack)region.clone();
    }

    @Override
    public void PushStyle(String styleName) {
        if (styleName == null) {
            styleName = this._styleStack.peek();
        }
        this._styleStack.push(styleName);
    }

    @Override
    public void PopStyle() {
        this._styleStack.pop();
    }

    @Override
    public boolean AppendText(String str) {
        if ("\n".equalsIgnoreCase(str)) {
            return false;
        }
        this._sb.append(str);
        return true;
    }

    @Override
    public void StoreText() {
        StyledString ss = new StyledString(this._sb.toString(), this._styleStack.peek(), this._regionStack.peek());
        this._sb.setLength(0);
        this._strings.add(ss);
    }

    @Override
    public void AddBreak() {
        this._strings.add(new BreakStyledText(this._styleStack.peek(), this._regionStack.peek()));
    }

    @Override
    public void StoreFullRuby() throws TTMLException {
        if (this._curRuby == null) {
            throw new TTMLException("Malformed Ruby: ruby tag must contain only ruby base and ruby text");
        }
        this._curRuby.setAttributes(this._rubyAttr);
        this._strings.add(this._curRuby);
        this._curRuby = null;
        this._rubyAttr = null;
    }

    @Override
    public void StoreRubyBase() throws TTMLException {
        String rb = this._sb.toString();
        if (rb.isEmpty()) {
            throw new TTMLException("Malformed Ruby: ruby base can not be empty");
        }
        this._curRuby = new RubyContent(rb, this._styleStack.peek(), this._regionStack.peek());
        this._sb.setLength(0);
    }

    @Override
    public void StoreRubyText() throws TTMLException {
        if (this._curRuby == null) {
            throw new TTMLException("Malformed Ruby: ruby base must come before ruby text ");
        }
        String rt = this._sb.toString();
        if (rt.isEmpty()) {
            throw new TTMLException("Malformed Ruby: ruby text can not be empty");
        }
        this._curRuby.setAnnotation(new RubyText(rt));
        this._sb.setLength(0);
    }

    public Iterable<StyledString> strings() {
        return this._strings;
    }

    @Override
    public int stringsCount() {
        return this._strings.size() + this._sb.length() > 0 ? 1 : 0;
    }

    @Override
    public void StoreRubyAttributes(Map<String, String> attr) throws TTMLException {
        this._rubyAttr = attr;
    }
}

