/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle.webvtt;

import com.apple.jingle.leghorn.subtitle.webvtt.CSSNamedColors;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class CSSColor {
    static final String kPrefix_RGB = "rgb(";
    static final String kPrefix_RGBA = "rgba(";
    static final String kPrefix_HEX = "#";
    static final String kPrefix_HSL = "hsl(";
    static final String kPrefix_HSLA = "hsla(";
    private int _r = 0;
    private int _g = 0;
    private int _b = 0;
    private int _a = 255;

    public static CSSColor colorFromString(String colorString) {
        String cleanString = colorString.trim().toLowerCase();
        if (cleanString.startsWith(kPrefix_RGB) && cleanString.endsWith(")")) {
            return CSSColor.fromRGBAString(cleanString.substring(4, cleanString.length() - 1));
        }
        if (cleanString.startsWith(kPrefix_RGBA) && cleanString.endsWith(")")) {
            return CSSColor.fromRGBAString(cleanString.substring(5, cleanString.length() - 1));
        }
        if (cleanString.startsWith(kPrefix_HEX)) {
            return CSSColor.fromHexString(cleanString.substring(1));
        }
        if (!(cleanString.startsWith(kPrefix_HSL) && cleanString.endsWith(")") || cleanString.startsWith(kPrefix_HSLA) && cleanString.endsWith(")"))) {
            if (!CSSNamedColors.containsKey(cleanString)) {
                throw new IllegalArgumentException("Invalid color string:" + cleanString);
            }
            return CSSColor.fromNumber(CSSNamedColors.get(cleanString), cleanString.length());
        }
        return null;
    }

    public static CSSColor fromRGBAString(String colorString) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String ss : colorString.split(",")) {
            parts.add(ss.trim());
        }
        if (parts.size() != 3 && parts.size() != 4) {
            throw new IllegalArgumentException("Invalid color string:" + colorString);
        }
        CSSColor ret = new CSSColor();
        ret._r = Integer.parseInt((String)parts.get(0));
        ret._g = Integer.parseInt((String)parts.get(1));
        ret._b = Integer.parseInt((String)parts.get(2));
        if (parts.size() == 4) {
            ret._a = (int)Math.floor(Double.parseDouble((String)parts.get(3)) * 255.0);
        }
        return ret;
    }

    public static CSSColor fromHexString(String hexColor) {
        long all = Long.parseLong(hexColor, 16);
        return CSSColor.fromNumber(all, hexColor.length());
    }

    public static CSSColor fromNumber(long hexColor, int srcStringLen) {
        if (srcStringLen != 6 && srcStringLen != 3 && srcStringLen != 8) {
            throw new IllegalArgumentException("Invalid color string:" + String.valueOf(hexColor));
        }
        CSSColor ret = new CSSColor();
        if (srcStringLen == 6) {
            ret._r = (int)(hexColor >> 16 & 0xFFL);
            ret._g = (int)(hexColor >> 8 & 0xFFL);
            ret._b = (int)(hexColor & 0xFFL);
        } else if (srcStringLen != 3) {
            if (srcStringLen == 8) {
                ret._r = (int)(hexColor >> 24 & 0xFFL);
                ret._g = (int)(hexColor >> 16 & 0xFFL);
                ret._b = (int)(hexColor >> 8 & 0xFFL);
                ret._a = (int)(hexColor & 0xFFL);
            } else {
                throw new IllegalArgumentException("Invalid color string:" + String.valueOf(hexColor));
            }
        }
        return ret;
    }

    public List<Double> asFloatARGBList() {
        return Lists.newArrayList((Object[])new Double[]{(double)this._a / 255.0, (double)this._r / 255.0, (double)this._g / 255.0, (double)this._b / 255.0});
    }
}

