/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle;

import com.apple.jingle.leghorn.subtitle.VTTStylingPolicy;
import com.apple.jingle.leghorn.subtitle.VTTStylingPolicyDefault;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class VTTStylingPolicyUserDefined
implements VTTStylingPolicy {
    private static final String UD_PREFIX = "udstyle:(";
    private static final String UD_POSFIX = ")";
    private Map<String, String> _attributes = new HashMap<String, String>();
    private VTTStylingPolicyDefault _defaultStyling = new VTTStylingPolicyDefault();
    private static final Set<String> _knownAttributes = Sets.newHashSet((Object[])new String[]{"font-size", "x-font-size-display", "background-color", "x-text-edge-style", "font-family-name", "x-generic-font-family"});

    @Override
    public String name() {
        return "UserDefinedStyle";
    }

    @Override
    public int fontRelativeSize() {
        if (this._attributes.containsKey("font-size")) {
            return Integer.parseInt(this._attributes.get("font-size"));
        }
        return this._defaultStyling.fontRelativeSize();
    }

    @Override
    public double fontRelativeScreenPercentage() {
        if (this._attributes.containsKey("x-font-size-display")) {
            return Double.parseDouble(StringUtils.strip((String)this._attributes.get("x-font-size-display"), (String)"%"));
        }
        return this._defaultStyling.fontRelativeScreenPercentage();
    }

    @Override
    public String backgroundColor() {
        if (this._attributes.containsKey("background-color")) {
            return StringUtils.strip((String)this._attributes.get("background-color"), (String)"\"");
        }
        return this._defaultStyling.backgroundColor();
    }

    @Override
    public String characterEdgeStyle() {
        if (this._attributes.containsKey("x-text-edge-style")) {
            return StringUtils.strip((String)this._attributes.get("x-text-edge-style"), (String)"\"");
        }
        return this._defaultStyling.characterEdgeStyle();
    }

    @Override
    public String fontFamilyName() {
        if (this._attributes.containsKey("font-family-name")) {
            return StringUtils.strip((String)this._attributes.get("font-family-name"), (String)"\"");
        }
        return this._defaultStyling.fontFamilyName();
    }

    @Override
    public String fontGenericFamilyName() {
        if (this._attributes.containsKey("x-generic-font-family")) {
            return StringUtils.strip((String)this._attributes.get("x-generic-font-family"), (String)"\"");
        }
        return this._defaultStyling.fontGenericFamilyName();
    }

    public static boolean isUserDefinedString(String stringPolicy) {
        return stringPolicy.startsWith(UD_PREFIX) && stringPolicy.endsWith(UD_POSFIX);
    }

    public static VTTStylingPolicyUserDefined makeStylingPolicyFromString(String stringPolicy) {
        String attributes = stringPolicy.substring(UD_PREFIX.length(), stringPolicy.length() - 1);
        if (Strings.isNullOrEmpty((String)attributes)) {
            throw new IllegalArgumentException("Invalid user defined vtt style string:" + stringPolicy);
        }
        VTTStylingPolicyUserDefined ret = new VTTStylingPolicyUserDefined();
        for (String at : attributes.split(";")) {
            String[] parts = at.split(":");
            if (parts.length == 2) {
                if (!_knownAttributes.contains(parts[0])) {
                    System.out.println("Unknown attribute:" + parts[0]);
                    continue;
                }
                if ("x-generic-font-family".equals(parts[1]) && ret._attributes.containsKey("font-family-name")) {
                    System.out.println("Ignoring x-generic-font-family because font-family-name is already present");
                    continue;
                }
                if ("font-family-name".equals(parts[1]) && ret._attributes.containsKey("x-generic-font-family")) {
                    System.out.println("Ignoring font-family-name because x-generic-font-family is already present");
                    continue;
                }
                if ("x-font-size-display".equals(parts[1]) && ret._attributes.containsKey("font-size")) {
                    System.out.println("Ignoring x-font-size-display because font-size is already present");
                    continue;
                }
                if ("font-size".equals(parts[1]) && ret._attributes.containsKey("x-font-size-display")) {
                    System.out.println("Ignoring font-size because x-font-size-display is already present");
                    continue;
                }
                ret._attributes.put(parts[0], parts[1]);
                continue;
            }
            throw new IllegalArgumentException("Invalid attribute in user defined vtt style string:" + stringPolicy + " attribute:" + at);
        }
        return ret;
    }
}

