/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle;

import com.apple.jingle.leghorn.subtitle.VTTDocumentParseException;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTParser;
import com.apple.jingle.leghorn.subtitle.webvtt.VTTParser.VTTParserDescribeAction;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class VTTDocument {
    private String _headerMessage = "";
    private long _firstSampleTime = -1L;
    private long _lastSampleTime = -1L;
    private long _numberOfSamples = 0L;
    private long _numberOfEmptySamples = 0L;
    private boolean _hasRuby = false;
    private boolean _hasVerticals = false;
    public static final int LINE_COUNT_LIMIT = 4;
    private final long[] sampleTextLineCount = new long[4];
    private Map<String, String> _styles = new HashMap<String, String>();
    private final long[] samplePositionCount = new long[4];
    public static final String TCY = "text-combine-upright";
    public static final String RUBY_POSITION = "ruby-position";
    public static final String RUBY_ALIGN = "align";
    public static final String RUBY_OFFSET = "offset";
    public static final String COLOR = "color";
    public static final String FONT_SIZE = "font-size";
    public static final String FONT_FAMILY = "font-family";
    public static final String TEXT_SHADOW = "text-shadow";

    public String headerMessage() {
        return this._headerMessage;
    }

    public void setHeaderMessage(String message) {
        this._headerMessage = message;
    }

    public static VTTDocument createVTTDocument(File f) throws IOException, VTTDocumentParseException {
        FileSeekableDataInput sdi = new FileSeekableDataInput(f);
        VTTDocument doc = new VTTDocument();
        return doc.createVTTDocument((SeekableDataInput)sdi);
    }

    public long firstSampleTime() {
        return this._firstSampleTime;
    }

    public void setFirstSampleTime(long n) {
        this._firstSampleTime = n;
    }

    public long lastSampleTime() {
        return this._lastSampleTime;
    }

    public void setLastSampleTime(long n) {
        this._lastSampleTime = n;
    }

    public long numberOfSamples() {
        return this._numberOfSamples;
    }

    public void setNumberOfSamples(long n) {
        this._numberOfSamples = n;
    }

    public long numberOfEmptySamples() {
        return this._numberOfEmptySamples;
    }

    public void setNumberOfEmptySamples(long n) {
        this._numberOfEmptySamples = n;
    }

    public boolean hasRuby() {
        return this._hasRuby;
    }

    public void setHasRuby(boolean v) {
        this._hasRuby = v;
    }

    public boolean hasVerticals() {
        return this._hasVerticals;
    }

    public void setHasVerticals(boolean v) {
        this._hasVerticals = v;
    }

    public long[] getSampleTextLineCount() {
        return this.sampleTextLineCount;
    }

    public long[] getSamplePositionCount() {
        return this.samplePositionCount;
    }

    public long getTopSamplesCount() {
        return this.samplePositionCount[0];
    }

    public long getBottomSamplesCount() {
        return this.samplePositionCount[1];
    }

    public long getLeftSamplesCount() {
        return this.samplePositionCount[2];
    }

    public long getRightSamplesCount() {
        return this.samplePositionCount[3];
    }

    public void setTopSamplesCount(long n) {
        this.samplePositionCount[0] = n;
    }

    public void setBottomSamplesCount(long n) {
        this.samplePositionCount[1] = n;
    }

    public void setLeftSamplesCount(long n) {
        this.samplePositionCount[2] = n;
    }

    public void setRightSamplesCount(long n) {
        this.samplePositionCount[3] = n;
    }

    public void addStyle(String selector, String styleString) {
        this._styles.put(selector, styleString);
    }

    private boolean hasStyle(@Nonnull String styleName) {
        if (Strings.isNullOrEmpty((String)styleName)) {
            return false;
        }
        for (String values : this._styles.values()) {
            for (String st : values.split(",|;")) {
                String[] stpair = st.trim().split(":");
                if (!styleName.equals(stpair[0].trim())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasStyles() {
        return this._styles.size() != 0;
    }

    public boolean hasTCY() {
        return this.hasStyle(TCY);
    }

    public boolean hasRubyPosition() {
        return this.hasStyle(RUBY_POSITION);
    }

    public boolean hasRubyAlignment() {
        return this.hasStyle(RUBY_ALIGN);
    }

    public boolean hasRubyOffset() {
        return this.hasStyle(RUBY_OFFSET);
    }

    public boolean hasColor() {
        return this.hasStyle(COLOR);
    }

    public boolean hasFontSize() {
        return this.hasStyle(FONT_SIZE);
    }

    public boolean hasFontFamily() {
        return this.hasStyle(FONT_FAMILY);
    }

    public boolean hasTextShadow() {
        return this.hasStyle(TEXT_SHADOW);
    }

    public Map<String, String> getStyles() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.putAll(this._styles);
        return ret;
    }

    public VTTDocument createVTTDocument(SeekableDataInput sdi) throws IOException, VTTDocumentParseException {
        VTTParser parser = new VTTParser(new VTTParserDescribeAction(this));
        parser.parse(sdi);
        return this;
    }

    public void countSampleTextLine(int lineCount) {
        if (lineCount >= 4) {
            this.sampleTextLineCount[3] = this.sampleTextLineCount[3] + 1L;
        } else {
            int n = lineCount;
            this.sampleTextLineCount[n] = this.sampleTextLineCount[n] + 1L;
        }
    }

    @Nonnull
    public Set<String> computeFeatureTags() {
        HashSet<String> featureTags = new HashSet<String>();
        if (this.hasVerticals()) {
            featureTags.add("com.apple.itunes.vertical-typography.v1");
        }
        if (this.hasRuby()) {
            if (this.hasColor() || this.hasFontFamily() || this.hasFontSize() || this.hasRubyAlignment() || this.hasRubyOffset() || this.hasRubyPosition() || this.hasTCY() || this.hasTextShadow()) {
                featureTags.add("com.apple.itunes.ruby-typography.v2");
            } else {
                featureTags.add("com.apple.itunes.ruby-typography.v1");
            }
        }
        return featureTags;
    }
}

