/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle;

import com.apple.jingle.leghorn.subtitle.SubtitleDocument;
import com.apple.jingle.leghorn.subtitle.SubtitleDocumentParseException;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.media.foundation.util.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.w3.ns.ttml.DivEltype;
import org.w3.ns.ttml.PEltype;
import org.w3.ns.ttml.SpanEltype;
import org.w3.ns.ttml.TtDocument;
import org.w3.ns.ttmlDatatype.FontStyle;
import org.w3.ns.ttmlDatatype.FontWeight;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TimedTextSubtitleDocument
implements SubtitleDocument {
    private TtDocument ttDocument;
    public static final Logger log = Logger.getLogger(TimedTextSubtitleDocument.class);
    private static String defaultFont = System.getProperty("com.apple.jingle.contentbusinesslogic.subtitle.defaultFont", "Lucida Grande");
    private static String defaultFontSize = System.getProperty("com.apple.jingle.contentbusinesslogic.subtitle.defaultFontSize", "10");
    private static String defaultBackgroundColor = System.getProperty("com.apple.jingle.contentbusinesslogic.subtitle.defaultBackgroundColor", "0%, 0%, 0%, 0%");
    private static String defaultTextColor = System.getProperty("com.apple.jingle.contentbusinesslogic.subtitle.defaultTextColor", "1%, 1%, 1%, 100%");
    private Document subtitleDocument;
    private long time;
    private int frameRate;
    private int spanId;
    private int currentStyle;
    public static final Pattern msOnlyTimeCodePattern = Pattern.compile("([0-9]+)ms");
    public static final Pattern clockTimeCodePattern = Pattern.compile("([0-9]+):([0-9][0-9]):([0-9][0-9]):([0-9][0-9])");
    public static final Pattern sOnlyTimeCodePattern = Pattern.compile("([0-9]+)s");

    private TimedTextSubtitleDocument() {
    }

    private TimedTextSubtitleDocument(TtDocument ttDocument) {
        this.ttDocument = ttDocument;
    }

    @Override
    public String getLanguage() {
        return this.ttDocument.getTt().getLang();
    }

    public static SubtitleDocument createFromTimedTextXML(File file) throws IOException, SubtitleDocumentParseException {
        return TimedTextSubtitleDocument.createFromTimedTextXML(new FileInputStream(file));
    }

    public static SubtitleDocument createFromTimedTextXML(InputStream is) throws IOException, SubtitleDocumentParseException {
        try {
            DocumentBuilderFactory dbf = XMLUtil.getDocumentBuilderDisabledXXE();
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", TimedTextSubtitleDocument.getSchemaFilePath());
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            TimedTextXMLErrorHandler errorHandler = new TimedTextXMLErrorHandler();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(errorHandler);
            Document document = db.parse(is);
            if (errorHandler.getExceptions().size() > 0) {
                throw new SubtitleDocumentParseException("Timed text document was not valid as per schema", errorHandler.getExceptions().get(0));
            }
            TtDocument ttDocument = TtDocument.Factory.parse((Node)document);
            TimedTextSubtitleDocument subtitleDocument = new TimedTextSubtitleDocument(ttDocument);
            return subtitleDocument;
        }
        catch (XmlException xmlException) {
            throw new SubtitleDocumentParseException("General exception parsing subtitle document", xmlException);
        }
        catch (SAXException saxException) {
            throw new SubtitleDocumentParseException("General exception parsing subtitle document", saxException);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("Caught ParserConfigurationException while parsing subtitle document", pce);
        }
    }

    @Override
    public void outputAsQuicktime3gpp(File outputFile, int trackWidth, int trackHeight) throws IOException, SubtitleDocumentParseException, ParserConfigurationException {
    }

    private String iso639_1_to_iso639_2(String lang) {
        if (lang.equalsIgnoreCase("en")) {
            return "eng";
        }
        throw new IllegalStateException("Other languages are not implemented yet.");
    }

    private void processSampleOfDuration(PEltype p, long durationInMillis, Element parent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("outputSampleOfDuration called with duration " + durationInMillis + " at time :" + this.time));
        }
        Element sample = this.addSampleElement(durationInMillis, parent);
        Element description = this.addDefaultDescriptionElements(p.getRegion(), sample);
        this.processSharedStyles(p, description);
        Element sampleData = this.addSampleDataElement(sample);
        XmlCursor cursor = p.newCursor();
        this.currentStyle = 2;
        while (!cursor.currentTokenType().isEnd()) {
            cursor.toNextToken();
            if (cursor.currentTokenType().isText()) {
                this.addTextElement(cursor.getTextValue(), 1, sampleData);
                continue;
            }
            if (!cursor.currentTokenType().isStart()) continue;
            cursor = this.processSpan(cursor, sampleData);
        }
        this.time += durationInMillis;
        cursor.dispose();
    }

    private void processSharedStyles(PEltype p, Element parent) {
        Element styles = this.addSharedStylesElement(parent);
        Element style = this.addDefaultStyleElement(styles);
        this.spanId = 2;
        SpanEltype[] spanArray = p.getSpanArray();
        for (int i = 0; i < spanArray.length; ++i) {
            SpanEltype span = spanArray[i];
            this.processSharedStyle(span, "", styles);
        }
    }

    private void processSharedStyle(SpanEltype span, String parentAttributes, Element parent) {
        FontWeight.Enum myFontWeight = span.getFontWeight();
        FontStyle.Enum myFontStyle = span.getFontStyle();
        StringBuffer myAttributes = new StringBuffer();
        if (myFontWeight != null) {
            String w = " {font-weight: " + myFontWeight.toString() + "} ";
            myAttributes.append(w);
        }
        if (myFontStyle != null) {
            String s = " {font-style: " + myFontStyle.toString() + "} ";
            myAttributes.append(s);
        }
        Element style = this.addStyleElement(this.spanId, myAttributes.toString(), parent);
        ++this.spanId;
        SpanEltype[] children = span.getSpanArray();
        for (int i = 0; i < children.length; ++i) {
            this.processSharedStyle(children[i], myAttributes.toString(), parent);
        }
    }

    private XmlCursor processSpan(XmlCursor cursor, Element parent) {
        while (!cursor.currentTokenType().isEnd()) {
            cursor.toNextToken();
            if (cursor.currentTokenType().isText()) {
                this.addTextElement(cursor.getTextValue(), this.currentStyle, parent);
                continue;
            }
            if (!cursor.currentTokenType().isStart()) continue;
            ++this.currentStyle;
            cursor = this.processSpan(cursor, parent);
        }
        cursor.toNextToken();
        return cursor;
    }

    private static String getSchemaFilePath() throws IOException {
        File ttXsdFile;
        String ttXsdLocation = System.getProperty("com.apple.jingle.contentbusinesslogic.subtitle.ttXsdLocation");
        if (ttXsdLocation != null && (ttXsdFile = new File(ttXsdLocation, "ttaf1-dfxp-document.xsd")).exists()) {
            return "file:" + ttXsdFile.getCanonicalPath();
        }
        URL tmpUrl = TimedTextSubtitleDocument.class.getResource("ttaf1-dfxp-document.xsd");
        if (tmpUrl != null) {
            return TimedTextSubtitleDocument.class.getResource("ttaf1-dfxp-document.xsd").toString();
        }
        throw new IllegalStateException("ttaf1-dfxp .xsd files could not be found, so I can't validate timed text files.  Please set system property \"com.apple.jingle.contentbusinesslogic.subtitle.ttXsdLocation\" to the toplevel directory containing the schema files.");
    }

    @Override
    public MediaTime getFirstTimeCode() {
        throw new IllegalStateException("Unimplemented method");
    }

    @Override
    public MediaTime getLastTimeCode() {
        throw new IllegalStateException("Unimplemented method");
    }

    @Override
    public long getNumberOfSamples() {
        int nSamples = 0;
        DivEltype[] a = this.ttDocument.getTt().getBody().getDivArray();
        for (int i = 0; i < a.length; ++i) {
            PEltype[] b = a[i].getPArray();
            nSamples += b.length;
        }
        return nSamples;
    }

    private void cacheFrameRate() {
        TtDocument ttDoc = this.ttDocument;
        if (ttDoc == null) {
            throw new IllegalStateException("Cannot generate 3gpp file if we have not parsed in a timed text document.");
        }
        this.frameRate = ttDoc.getTt().getFrameRate() == null ? 30 : ttDoc.getTt().getFrameRate().intValue();
    }

    @Override
    public long getFrameRate() {
        if (this.frameRate == 0) {
            this.cacheFrameRate();
        }
        return this.frameRate;
    }

    private Element addText3GTrackElement(int trackWidth, int trackHeight, String lang) {
        Element result = this.subtitleDocument.createElement("text3GTrack");
        result.setAttribute("trackWidth", String.valueOf(trackWidth));
        result.setAttribute("trackHeight", String.valueOf(trackHeight));
        result.setAttribute("language", this.iso639_1_to_iso639_2(lang));
        result.setAttribute("timeScale", "1000");
        this.subtitleDocument.appendChild(result);
        ProcessingInstruction quicktime = this.subtitleDocument.createProcessingInstruction("quicktime", "type=\"application/x-quicktime-tx3g\"");
        this.subtitleDocument.insertBefore(quicktime, result);
        return result;
    }

    private Element addSampleElement(long durationInMillis, Element parent) {
        Element sample = this.subtitleDocument.createElement("sampleCount");
        sample.setAttribute("keyframe", "true");
        sample.setAttribute("duration", String.valueOf(durationInMillis));
        parent.appendChild(sample);
        return sample;
    }

    private Element addTextElement(String value, int style, Element parent) {
        Element text = this.subtitleDocument.createElement("text");
        text.setAttribute("styleID", String.valueOf(style));
        if (value != null) {
            text.appendChild(this.subtitleDocument.createTextNode(value.trim()));
        }
        parent.appendChild(text);
        return text;
    }

    private void processTextElement(XmlCursor cursor, int style) {
        String text = cursor.getTextValue();
        boolean done = false;
        while (!done) {
            cursor.toNextToken();
            if (cursor.currentTokenType().isStart() && cursor.getDomNode().getNodeName().equalsIgnoreCase("br")) {
                text = text + "\n";
                cursor.toNextToken();
                continue;
            }
            if (cursor.currentTokenType().isStart() && !cursor.getDomNode().getNodeName().equalsIgnoreCase("br")) {
                done = true;
                cursor.toPrevToken();
                continue;
            }
            if (cursor.currentTokenType().isText()) {
                text = text + cursor.getTextValue();
                continue;
            }
            if (!cursor.currentTokenType().isEnd()) continue;
            done = true;
        }
    }

    private Element addDefaultDescriptionElements(String region, Element parent) {
        Element description = this.addDescriptionElement(region, parent);
        Element defaultTextBox = this.addDefaultTextBoxElement(description);
        Element fontTable = this.addFontTableElement(description);
        Element font = this.addFontElement(fontTable);
        return description;
    }

    private Element addDefaultStyleElement(Element parent) {
        return this.addStyleElement(1, null, parent);
    }

    private Element addStyleElement(int spanId, String attributes, Element parent) {
        Element style = this.subtitleDocument.createElement("style");
        style.setAttribute("id", String.valueOf(spanId));
        if (attributes != null) {
            style.appendChild(this.subtitleDocument.createTextNode("{font-table: 1} " + attributes + "{font-size: " + defaultFontSize + "} {color: " + defaultTextColor + "}"));
        } else {
            style.appendChild(this.subtitleDocument.createTextNode("{font-table: 1} {font-size: " + defaultFontSize + "} {color: " + defaultTextColor + "}"));
        }
        parent.appendChild(style);
        return style;
    }

    private Element addSharedStylesElement(Element parent) {
        Element styles = this.subtitleDocument.createElement("sharedStyles");
        parent.appendChild(styles);
        return styles;
    }

    private Element addFontElement(Element parent) {
        Element font = this.subtitleDocument.createElement("font");
        font.setAttribute("name", defaultFont);
        font.setAttribute("id", "1");
        parent.appendChild(font);
        return font;
    }

    private Element addFontTableElement(Element parent) {
        Element fontTable = this.subtitleDocument.createElement("fontTable");
        parent.appendChild(fontTable);
        return fontTable;
    }

    private Element addDefaultTextBoxElement(Element parent) {
        Element box = this.subtitleDocument.createElement("defaultTextBox");
        parent.appendChild(box);
        return box;
    }

    private Element addDescriptionElement(String region, Element parent) {
        Element description = this.subtitleDocument.createElement("description");
        description.setAttribute("backgroundColor", defaultBackgroundColor);
        description.setAttribute("verticalJustification", region);
        description.setAttribute("horizontalJustification", "center");
        description.setAttribute("format", "tx3g");
        parent.appendChild(description);
        return description;
    }

    private void outputEmptySampleOfDuration(long durationInMillis, Element parent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("outputEmptySampleOfDuration called with duration " + durationInMillis + " at time :" + this.time));
        }
        Element sample = this.addSampleElement(durationInMillis, parent);
        Element description = this.addDescriptionElement("bottom", sample);
        this.addDefaultTextBoxElement(description);
        Element fontTable = this.addFontTableElement(description);
        this.addFontElement(fontTable);
        Element styles = this.addSharedStylesElement(description);
        this.addDefaultStyleElement(styles);
        Element sampleData = this.addSampleDataElement(sample);
        this.addTextElement(null, 1, sampleData);
        this.time += durationInMillis;
    }

    private Element addSampleDataElement(Element parent) {
        Element sampleData = this.subtitleDocument.createElement("sampleData");
        sampleData.setAttribute("targetEncoding", "utf8");
        parent.appendChild(sampleData);
        return sampleData;
    }

    private static class TimedTextXMLErrorHandler
    implements ErrorHandler {
        private List<SAXParseException> exceptions = new LinkedList<SAXParseException>();

        private TimedTextXMLErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        public List<SAXParseException> getExceptions() {
            return this.exceptions;
        }
    }
}

