/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle;

import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.WellFormedRubySpanValidator;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.beans.NotificationList;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.quicktime.ITTValidationContext;
import com.apple.jingle.leghorn.subtitle.ITTRegionClassifier;
import com.apple.jingle.leghorn.subtitle.SubtitleSMPTEException;
import com.apple.jingle.leghorn.subtitle.SubtitleSMPTETimeCode;
import com.apple.jingle.leghorn.subtitle.ittStyleAdaptor;
import com.apple.jingle.leghorn.subtitle.webvtt.TTMLBeansEnumMapper;
import com.apple.jingle.leghorn.subtitle.xml.BlankPElements;
import com.apple.jingle.leghorn.subtitle.xml.Block;
import com.apple.jingle.leghorn.subtitle.xml.Control;
import com.apple.jingle.leghorn.subtitle.xml.Direction;
import com.apple.jingle.leghorn.subtitle.xml.DisplayLocation;
import com.apple.jingle.leghorn.subtitle.xml.OverlapElement;
import com.apple.jingle.leghorn.subtitle.xml.OverlappingPElements;
import com.apple.jingle.leghorn.subtitle.xml.PElement;
import com.apple.jingle.leghorn.subtitle.xml.PElementsWithMoreThanTwoLines;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDescriptionDocument;
import com.apple.jingle.leghorn.subtitle.xml.UnicodeStatisticsDocument;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.leghorn.util.NamedTimeCodeInterval;
import com.apple.jingle.leghorn.util.TTMLSchemaValidationHelper;
import com.apple.jingle.leghorn.util.UnicodeUtil;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableInputStream;
import com.apple.jingle.media.foundation.util.CharacterStatistics;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.w3.ns.ttml.BodyEltype;
import org.w3.ns.ttml.DivEltype;
import org.w3.ns.ttml.HeadEltype;
import org.w3.ns.ttml.LayoutEltype;
import org.w3.ns.ttml.PEltype;
import org.w3.ns.ttml.RegionEltype;
import org.w3.ns.ttml.StyleEltype;
import org.w3.ns.ttml.StylingEltype;
import org.w3.ns.ttml.TtDocument;
import org.w3.ns.ttml.TtEltype;
import org.w3.ns.ttml.impl.PEltypeImpl;
import org.w3.ns.ttmlParameter.ExtensionEltype;
import org.w3.ns.ttmlParameter.ExtensionsEltype;
import org.w3.ns.ttmlParameter.ProfileEltype;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SubtitleSummary {
    private TtDocument document;
    private SubtitleDescriptionDocument description = SubtitleDescriptionDocument.Factory.newInstance();
    private ITTValidationContext ittValidationContext;
    private SeekableDataInput sdi;
    private DivEltype div;
    private boolean isRubyAllowed = false;
    private boolean isVerticalAllowed = false;
    private ITTRegionClassifier regionClassifier;
    private List<String> verticalRegions = new ArrayList<String>();
    private List<String> tcyStyles = new ArrayList<String>();
    private UnicodeUtil.CJKCompatibility cjkUtil = new UnicodeUtil.CJKCompatibility();
    private static final String XML_ID = "xml:id";
    private int longestLineLength = 0;
    private static Character[] badCharacters = new Character[]{Character.valueOf('\u00b6')};
    private static final Logger logger = Logger.getLogger(SubtitleSummary.class);
    public static final String TTML_SCHEMA_LOC = "/com/apple/jingle/leghorn/subtitle/RNC/ttaf1-dfxp.complete.rnc";
    public static final String ITT_SCHEMA_LOC = "/com/apple/jingle/leghorn/subtitle/RNC/itunes-timed-text.complete.rnc";
    private static final Pattern ALL_WHITESPACE_PATTERN = Pattern.compile("^\\s+$");

    public SubtitleSummary(SeekableDataInput sdi) throws IOException {
        this(sdi, new ITTValidationContext(sdi.getFileName(), "SubtitleSummaryClass_DefaultApplication", "DefaultVersionNumber"));
    }

    public SubtitleSummary(SeekableDataInput sdi, ITTValidationContext ctx) throws IOException {
        this.sdi = sdi;
        this.ittValidationContext = ctx;
        this.validateSubtitleDocument();
    }

    public SubtitleDescriptionDocument getDescription() {
        return this.description;
    }

    public TtDocument getDocument() {
        return this.document;
    }

    public ITTValidationContext getValidationContext() {
        return this.ittValidationContext;
    }

    private void validateSubtitleDocument() throws IOException {
        this.validateSubtitleDocumentInternal();
        SubtitleDescriptionDocument.SubtitleDescription desc = this.description.getSubtitleDescription();
        if (desc != null) {
            NotificationList notificationList = desc.getNotifications();
            if (notificationList == null) {
                notificationList = desc.addNewNotifications();
            }
            this.ittValidationContext.populateAlertList(notificationList, ValidationLevel.INFO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSubtitleDocumentInternal() throws IOException {
        SubtitleDescriptionDocument.SubtitleDescription desc = this.description.addNewSubtitleDescription();
        try {
            this.sdi.seek(0L);
            try (SeekableInputStream ttmlInputStream = new SeekableInputStream(this.sdi);){
                TTMLSchemaValidationHelper.validateWithRNCSchema((InputStream)ttmlInputStream, TTML_SCHEMA_LOC);
            }
            this.sdi.seek(0L);
            try (SeekableInputStream ittInputStream = new SeekableInputStream(this.sdi);){
                TTMLSchemaValidationHelper.validateWithRNCSchema((InputStream)ittInputStream, ITT_SCHEMA_LOC);
            }
        }
        catch (RuntimeException e) {
            this.ittValidationContext.addCheckAlert(MediaValidationCode.SUBTITLE_FAILS_SCHEMA_VALIDATION, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("SchemaError", "XML does not validate"));
            return;
        }
        this.sdi.seek(0L);
        try (SeekableInputStream sii = new SeekableInputStream(this.sdi);){
            TtDocument ttDoc;
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setEntityResolver(new EntityListener());
            xmlOptions.setLoadLineNumbers();
            this.document = ttDoc = TtDocument.Factory.parse((InputStream)sii, (XmlOptions)xmlOptions);
            TtEltype tt = ttDoc.getTt();
            if (!(tt.isSetFrameRate() && tt.isSetFrameRateMultiplier() && tt.isSetDropMode())) {
                this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_SAMPLERATE_MISSING, MediaUtil.dictionary.add("javaClass", "SubtitleSummary"));
            }
            HashMap<String, Set<String>> overlappingRegions = new HashMap<String, Set<String>>();
            if (tt.isSetHead()) {
                StylingEltype styling;
                this.isRubyAllowed = SubtitleSummary.hasExtensionDesignator(tt.getHead(), "#ruby");
                this.isVerticalAllowed = SubtitleSummary.hasExtensionDesignator(tt.getHead(), "#vertical");
                this.regionClassifier = new ITTRegionClassifier(tt.getHead().getLayout().getRegionArray());
                LayoutEltype layout = tt.getHead().getLayout();
                if (layout != null) {
                    RegionEltype[] regions;
                    for (RegionEltype regionEltype : regions = layout.getRegionArray()) {
                        String regionName = ((Element)regionEltype.getDomNode()).getAttribute(XML_ID);
                        if (!this.regionClassifier.isVertical(regionName)) continue;
                        this.verticalRegions.add(regionName);
                    }
                }
                if ((styling = tt.getHead().getStyling()) != null) {
                    for (RegionEltype regionEltype : styling.getStyleArray()) {
                        String styleVerticalCombine;
                        String styleRubyAlign;
                        ittStyleAdaptor style = new ittStyleAdaptor((StyleEltype)regionEltype);
                        String styleRubyPosition = style.getRubyExtPosition();
                        if (!(Strings.isNullOrEmpty((String)styleRubyPosition) || "before".equals(styleRubyPosition) || "after".equals(styleRubyPosition))) {
                            this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_UNCATEGORIZED_ERROR, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("errorMessage", "Invalid value for the ruby style position attribute:" + styleRubyPosition));
                        }
                        if (!(Strings.isNullOrEmpty((String)(styleRubyAlign = style.getRubyExtAlign())) || "start".equals(styleRubyAlign) || "center".equals(styleRubyAlign) || "center".equals(styleRubyAlign) || "spaceBetween".equals(styleRubyAlign) || "spaceAround".equals(styleRubyAlign))) {
                            this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_UNCATEGORIZED_ERROR, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("errorMessage", "Invalid value for the ruby style align attribute:" + styleRubyAlign));
                        }
                        if (Strings.isNullOrEmpty((String)(styleVerticalCombine = style.getVerticalExtCombine()))) continue;
                        if (!("none".equals(styleVerticalCombine) || "all".equals(styleVerticalCombine) || styleVerticalCombine.matches("\\d*"))) {
                            this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_UNCATEGORIZED_ERROR, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("errorMessage", "Invalid value for the vertical style combine attribute:" + styleVerticalCombine));
                        }
                        if (!styleVerticalCombine.matches("^\\d*$") && !styleVerticalCombine.equals("all")) continue;
                        ((Element)regionEltype.getDomNode()).getAttribute(XML_ID);
                        this.tcyStyles.add(((Element)regionEltype.getDomNode()).getAttribute(XML_ID));
                    }
                }
            }
            if (tt.isSetBody()) {
                BodyEltype body = tt.getBody();
                int numberOfDivs = body.sizeOfDivArray();
                if (numberOfDivs > 1 || numberOfDivs < 1) {
                    this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_INVALID_NUMBER_OF_DIV_ELEMENTS, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("numberOfDivs", Integer.toString(numberOfDivs)));
                }
                if (numberOfDivs > 0) {
                    SubtitleSMPTETimeCode divOffset;
                    this.div = body.getDivArray(0);
                    if (this.div.isSetBegin()) {
                        divOffset = this.checkOffsetTimeStamp(this.div.getBegin(), tt, desc);
                        desc.setOffsetTimeCode(this.div.getBegin());
                    } else {
                        divOffset = SubtitleSMPTETimeCode.UNDEFINED;
                    }
                    desc.setNumberOfSamples(BigInteger.valueOf(this.div.sizeOfPArray()));
                    String defaultRegion = this.div.getRegion();
                    if (defaultRegion == null || defaultRegion.isEmpty()) {
                        defaultRegion = body.getRegion();
                    }
                    List<NamedTimeCodeInterval> timeIntervals = this.parseTimeIntervals(tt, this.div.getPArray(), defaultRegion, desc);
                    this.checkTimeStampsInvariant2(timeIntervals, this.isVerticalAllowed, divOffset, desc);
                    SubtitleSummary.checkTimeRegionOverlap(timeIntervals, this.regionClassifier, desc);
                    if (this.div.sizeOfPArray() > 0) {
                        PEltype[] pEltypeArray = this.div.getPArray();
                        TreeMap<Interval, Interval> pMap = this.checkOverlap(pEltypeArray, defaultRegion, this.isRubyAllowed || this.isVerticalAllowed, overlappingRegions, tt, desc);
                        desc.setFirstTimeCode(pMap.firstKey().pElement.getBegin());
                        desc.setLastTimeCode(pMap.lastKey().pElement.getEnd());
                        this.checkBlankAndMaxNumberOfLinesPerPElement(pEltypeArray, desc);
                        SubtitleSummary.checkForRuby(pEltypeArray, this.isRubyAllowed, desc);
                        this.checkForVertical(pEltypeArray, this.isVerticalAllowed, this.regionClassifier, desc);
                        SubtitleSummary.countDisplayLocations(pEltypeArray, this.regionClassifier, desc);
                        HashSet<String> beginTimecodes = new HashSet<String>();
                        HashSet<Character> allFoundBadChars = new HashSet<Character>();
                        for (PEltype p : pEltypeArray) {
                            this.longestLineLength = Math.max(this.longestLineLength, this.getLongestLineLength(p.getDomNode()));
                            HashSet<Character> foundBadChars = new HashSet<Character>();
                            this.getBadCharacters(p.getDomNode(), foundBadChars);
                            if (foundBadChars.isEmpty() || allFoundBadChars.containsAll(foundBadChars)) continue;
                            allFoundBadChars.addAll(foundBadChars);
                            beginTimecodes.add(p.getBegin());
                        }
                        if (!allFoundBadChars.isEmpty()) {
                            this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_CONTAINS_BAD_CHARACTER, MediaUtil.dictionary.add("startTimeCodeList", ((Object)beginTimecodes).toString()).add("badCharList", SubtitleSummary.charToHex(allFoundBadChars).toString()));
                        }
                    }
                }
            }
        }
        this.validateItalicAndRomanWithCJK();
    }

    private void getBadCharacters(Node n, Set<Character> foundChars) {
        if (n.getNodeName().equals("#text")) {
            String nodeText = n.getNodeValue();
            for (Character c : badCharacters) {
                if (nodeText.indexOf(c.charValue()) < 0) continue;
                foundChars.add(c);
            }
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.getBadCharacters(children.item(i), foundChars);
        }
    }

    private int getCharacterCount(Node n) {
        if (n.getNodeName().equals("#text")) {
            return n.getNodeValue().length();
        }
        int subCount = 0;
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            subCount += this.getCharacterCount(children.item(i));
        }
        return subCount;
    }

    private int getLongestLineLength(Node n) {
        if (n.getNodeName().equals("#text")) {
            return n.getNodeValue().length();
        }
        int subCount = 0;
        int preBreakLength = 0;
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName() != null && child.getNodeName().toLowerCase().equals("br")) {
                preBreakLength = Math.max(preBreakLength, subCount);
                subCount = 0;
                continue;
            }
            subCount += this.getCharacterCount(child);
        }
        return Math.max(preBreakLength, subCount);
    }

    private static Collection<String> charToHex(Collection<Character> chars) {
        ArrayList<String> hexStrings = new ArrayList<String>();
        for (Character c : chars) {
            hexStrings.add(Strings.padStart((String)Integer.toHexString(c.charValue()).toUpperCase(), (int)4, (char)'0'));
        }
        return hexStrings;
    }

    private void validateItalicAndRomanWithCJK() {
        Node doc = this.document.getDomNode();
        List<TextNodeData> textNodesAsListOfStrings = SubtitleSummary.followNode(doc, new ArrayList<TextNodeData>(), false);
        for (TextNodeData data : textNodesAsListOfStrings) {
            if (!data.containsItalicRoman()) continue;
            this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_CONTAINS_ITALICS_ROMAN_WITH_CJK, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("textData", data.getTextData()).add("errorMessage", "italics are not supported for CJK yet so it cannot be combined with roman within italic span"));
        }
    }

    public void validationsToException(ValidationLevel validationLevel) throws DescriptionException {
        if (this.getValidationContext().hasValidations(validationLevel)) {
            ArrayList<String> errorMessages = new ArrayList<String>();
            Collection<ValidationResult> validationResults = this.getValidationContext().getValidations(validationLevel);
            for (ValidationResult validationResult : validationResults) {
                errorMessages.add(validationResult.getValidationMessage());
            }
            String message = Joiner.on((String)", ").skipNulls().join(errorMessages);
            throw new DescriptionException(message);
        }
    }

    public void validationsToException() throws DescriptionException {
        this.validationsToException(ValidationLevel.ERROR);
    }

    public UnicodeStatisticsDocument.UnicodeStatistics computeUnicodeStatistics() {
        Node doc = this.document.getDomNode();
        CharacterStatistics charStats = CharacterStatistics.generateStatistics((CharSequence)"");
        SubtitleSummary.processStatisticsOfDocument(doc, charStats);
        UnicodeStatisticsDocument.UnicodeStatistics unicodeStats = UnicodeStatisticsDocument.UnicodeStatistics.Factory.newInstance();
        UnicodeStatisticsDocument.UnicodeStatistics.Blocks blocks = unicodeStats.addNewBlocks();
        Map blockStats = charStats.getBlockStatistics();
        for (Map.Entry entry : blockStats.entrySet()) {
            Character.UnicodeBlock key = (Character.UnicodeBlock)entry.getKey();
            CharacterStatistics.CodePointBag value = (CharacterStatistics.CodePointBag)entry.getValue();
            Block block = blocks.addNewBlock();
            block.setCount(BigInteger.valueOf(value.getCount()));
            block.setName(key.toString());
            String characters = value.getNonControlCharacters();
            block.setStringValue(SubtitleSummary.addNoBreakSpaceToCombiningCharacters(characters));
        }
        CharacterStatistics.CodePointBag unrecognizedCodePointBag = charStats.getUnrecognizedBlockStatistics();
        if (unrecognizedCodePointBag.getCount() > 0L) {
            Block unrecognizedBlock = blocks.addNewBlock();
            unrecognizedBlock.setCount(BigInteger.valueOf(unrecognizedCodePointBag.getCount()));
            unrecognizedBlock.setName("_UNDEFINED");
            unrecognizedBlock.setStringValue(unrecognizedCodePointBag.getCharacters());
        }
        Control control = unicodeStats.addNewControl();
        control.setCount(BigInteger.valueOf(charStats.getControlStatistics().getCount()));
        UnicodeStatisticsDocument.UnicodeStatistics.Directionality directionality = unicodeStats.addNewDirectionality();
        for (Map.Entry entry : charStats.getDirectionalityStatistics().entrySet()) {
            CharacterStatistics.Directionality key = (CharacterStatistics.Directionality)entry.getKey();
            CharacterStatistics.CodePointBag value = (CharacterStatistics.CodePointBag)entry.getValue();
            Direction direction = directionality.addNewDirection();
            direction.setCount(BigInteger.valueOf(value.getCount()));
            direction.setName(key.toString());
            direction.setUnique(BigInteger.valueOf(value.getUnique()));
        }
        return unicodeStats;
    }

    private static String addNoBreakSpaceToCombiningCharacters(String characters) {
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator it = new StringCharacterIterator(characters);
        char ch = it.first();
        while (ch != '\uffff') {
            sb.append(ch);
            int characterType = Character.getType(ch);
            if (characterType == 6 || characterType == 8 || characterType == 7) {
                sb.append(Character.toChars(160));
            }
            ch = it.next();
        }
        return sb.toString();
    }

    private static boolean containsHanScript(String data) {
        int codepoint;
        for (int i = 0; i < data.length(); i += Character.charCount(codepoint)) {
            codepoint = data.codePointAt(i);
            if (Character.UnicodeScript.of(codepoint) != Character.UnicodeScript.HAN) continue;
            return true;
        }
        return false;
    }

    private static void processStatisticsOfDocument(Node doc, CharacterStatistics charStats) {
        List<TextNodeData> textNodesAsListOfStrings = SubtitleSummary.followNode(doc, new ArrayList<TextNodeData>(), false);
        for (TextNodeData node : textNodesAsListOfStrings) {
            charStats.addCharacters((CharSequence)node.getTextData());
        }
    }

    private static boolean isRomanAndCJK(@Nonnull String data) {
        boolean isCJK = SubtitleSummary.containsHanScript(data);
        for (int i = 0; i < data.length(); ++i) {
            if (!isCJK || !CharMatcher.ASCII.matches(data.charAt(i)) || !Character.isDigit(data.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static void processNode(Node node, List<TextNodeData> linesOfText, boolean withinItalicSpan) {
        Text text;
        String data;
        Matcher m;
        if (node instanceof Text && !(m = ALL_WHITESPACE_PATTERN.matcher(data = (text = (Text)node).getData())).matches()) {
            linesOfText.add(new TextNodeData(data, withinItalicSpan && SubtitleSummary.isRomanAndCJK(data)));
        }
    }

    private static List<TextNodeData> followNode(Node node, List<TextNodeData> linesOfText, boolean withinItalicSpan) {
        SubtitleSummary.processNode(node, linesOfText, withinItalicSpan);
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                SubtitleSummary.followNode(children.item(i), linesOfText, SubtitleSummary.isItalicSpan(node));
            }
        }
        return linesOfText;
    }

    private static boolean isItalicSpan(Node node) {
        if (node != null && node.getNodeName().equalsIgnoreCase("span")) {
            NamedNodeMap attributes = node.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.item(i).getNodeValue().equalsIgnoreCase("italic")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void checkForRuby(PEltype[] pArray, boolean isRubyAllowed, SubtitleDescriptionDocument.SubtitleDescription desc) {
        WellFormedRubySpanValidator rubyValidator = new WellFormedRubySpanValidator(desc, isRubyAllowed);
        rubyValidator.validate(pArray);
        if (rubyValidator.rubyTagCount() != 0L) {
            desc.setNumberOfRubyTags(BigInteger.valueOf(rubyValidator.rubyTagCount()));
        }
    }

    public void checkForVertical(PEltype[] pArray, boolean isVerticalAllowed, ITTRegionClassifier regionClassifier, SubtitleDescriptionDocument.SubtitleDescription desc) {
        long verticalCount = 0L;
        for (PEltype e : pArray) {
            String paragraphRegion = regionClassifier.defaulRegionName();
            if (e.isSetRegion()) {
                paragraphRegion = e.getRegion();
            }
            if (!regionClassifier.isVertical(paragraphRegion)) continue;
            ++verticalCount;
            if (isVerticalAllowed) continue;
            this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_INVALID_VERTICAL, MediaUtil.dictionary.add("javaClass", "SubtitleSummary"));
        }
        if (verticalCount != 0L) {
            desc.setNumberOfVerticalSamples(BigInteger.valueOf(verticalCount));
        }
    }

    private SubtitleSMPTETimeCode checkOffsetTimeStamp(String timeStampString, TtEltype ttmlElement, SubtitleDescriptionDocument.SubtitleDescription desc) throws SubtitleSMPTEException {
        SMPTETimeCode.Mode docTmcdMode;
        if (!SMPTETimeCode.isValid(timeStampString)) {
            this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_INVALID_FORMAT_SMPTE_TIMECODE, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("timestamp", timeStampString));
            return null;
        }
        SampleRate docTmcdSampleRate = new SampleRate(ttmlElement.getFrameRate().longValue(), ttmlElement.getFrameRateMultiplier());
        SubtitleSMPTETimeCode offsetTimecode = SubtitleSMPTETimeCode.parseSubtitleTimeCode(timeStampString, docTmcdSampleRate, docTmcdMode = TTMLBeansEnumMapper.toSMPTEDropMode(ttmlElement.getDropMode()));
        if (offsetTimecode.shouldWarn()) {
            this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_TIMESTAMP_FORMAT_IS_NOT_CONSISTENT_WRT_DROPFRAME, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("timestamp", timeStampString));
        }
        return offsetTimecode;
    }

    private void checkTimeStampsInvariant2(List<NamedTimeCodeInterval> intervals, boolean isVerticalAllowed, SubtitleSMPTETimeCode offset, SubtitleDescriptionDocument.SubtitleDescription desc) throws SubtitleSMPTEException {
        long beginOfLastSubtitle = Long.MIN_VALUE;
        long endOfLastSubtitle = Long.MIN_VALUE;
        long offsetMilliseconds = null != offset ? offset.getTotalMilliseconds() : 0L;
        for (NamedTimeCodeInterval interval : intervals) {
            if (interval.begin().getTotalMilliseconds() + offsetMilliseconds < 0L || interval.end().getTotalMilliseconds() + offsetMilliseconds < 0L) {
                this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_TIMESTAMP_INVALID_TIMECODE, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("start", interval.begin().toUserString()).add("end", interval.end().toUserString()).add("offset", null == offset ? "" : offset.toUserString()));
                continue;
            }
            if (!isVerticalAllowed && endOfLastSubtitle > interval.begin().getTotalMilliseconds()) {
                this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_NON_MONOTONIC_TIMECODE, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("timestamp", interval.begin().toUserString()));
                continue;
            }
            if (interval.begin().getTotalMilliseconds() >= interval.end().getTotalMilliseconds()) {
                this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_INVALID_DURATION, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("timestamp", interval.end().toUserString()));
                continue;
            }
            if (beginOfLastSubtitle > interval.begin().getTotalMilliseconds()) {
                this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_NON_MONOTONIC_TIMECODE, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("timestamp", interval.begin().toUserString()));
                continue;
            }
            beginOfLastSubtitle = interval.begin().getTotalMilliseconds();
            endOfLastSubtitle = interval.end().getTotalMilliseconds();
        }
    }

    private static void checkTimeRegionOverlap(@Nonnull List<NamedTimeCodeInterval> intervals, @Nonnull ITTRegionClassifier regionClassifier, @Nonnull SubtitleDescriptionDocument.SubtitleDescription desc) {
        if (intervals.size() < 2) {
            return;
        }
        ArrayList activeIntervals = Lists.newArrayList((Object[])new NamedTimeCodeInterval[]{intervals.get(0)});
        intervals.remove(0);
        while (!intervals.isEmpty()) {
            NamedTimeCodeInterval current = intervals.get(0);
            intervals.remove(0);
            Iterator it = activeIntervals.iterator();
            while (it.hasNext()) {
                NamedTimeCodeInterval a = (NamedTimeCodeInterval)it.next();
                if (!current.intersect(a).isValid()) {
                    it.remove();
                    continue;
                }
                if (!SubtitleSummary.doRegionsOverlap(regionClassifier, current.name(), a.name())) continue;
                SubtitleSummary.addOverlapElementToDescription(desc, a, current);
            }
            activeIntervals.add(current);
        }
    }

    private static boolean doRegionsOverlap(@Nonnull ITTRegionClassifier regionClassifier, String firstRegion, String secondRegion) {
        return regionClassifier.classify(firstRegion) == regionClassifier.classify(secondRegion);
    }

    public TreeMap<Interval, Interval> checkOverlap(PEltype[] pArray, @Nonnull String defaultRegion, boolean isTimeOverlapAllowedAcrossNonoverlappingRegions, Map<String, Set<String>> overlappingRegions, TtEltype tt, SubtitleDescriptionDocument.SubtitleDescription desc) throws SubtitleSMPTEException {
        TreeMap<Interval, Interval> pMap = new TreeMap<Interval, Interval>();
        TreeMap<Interval, Interval> overlappingElements = new TreeMap<Interval, Interval>();
        for (PEltype p : pArray) {
            String paraRegion = SubtitleSummary.getRegionForPara(p, defaultRegion);
            Interval paraInterval = new Interval(p, tt, paraRegion, overlappingRegions.get(paraRegion), isTimeOverlapAllowedAcrossNonoverlappingRegions);
            Interval existing = pMap.put(paraInterval, paraInterval);
            if (existing == null) continue;
            overlappingElements.put(paraInterval, existing);
        }
        return pMap;
    }

    private static void addOverlapElementToDescription(SubtitleDescriptionDocument.SubtitleDescription desc, NamedTimeCodeInterval paraInterval, NamedTimeCodeInterval existing) {
        OverlappingPElements descOverlappingPElements = desc.getOverlappingPElements();
        if (null == descOverlappingPElements) {
            descOverlappingPElements = desc.addNewOverlappingPElements();
        }
        OverlapElement descOverlap = descOverlappingPElements.addNewOverlap();
        descOverlap.setFirstRegion(paraInterval.name());
        SubtitleSummary.setPElement(descOverlap.addNewFirstPElement(), paraInterval.begin().toUserString(), paraInterval.end().toUserString());
        descOverlap.setSecondRegion(existing.name());
        SubtitleSummary.setPElement(descOverlap.addNewSecondPElement(), existing.begin().toUserString(), existing.end().toUserString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasExtensionDesignator(HeadEltype head, String extDesignator) {
        if (extDesignator == null || head == null) {
            return false;
        }
        if (head.sizeOfProfileArray() == 0) {
            return false;
        }
        ProfileEltype profile = head.getProfileArray()[0];
        if (profile.sizeOfExtensionsArray() == 0) {
            return false;
        }
        for (ExtensionsEltype extensions : profile.getExtensionsArray()) {
            if (!"http://namespace.itunes.apple.com/itt/ttml-extension/".equals(extensions.getBase())) continue;
            for (ExtensionEltype e : extensions.getExtensionArray()) {
                XmlCursor cursor = null;
                try {
                    cursor = e.newCursor();
                    cursor.toFirstContentToken();
                    String ext = cursor.getTextValue();
                    if (extDesignator.compareTo(ext) != 0) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (cursor != null) {
                        cursor.dispose();
                    }
                }
            }
        }
        return false;
    }

    private List<NamedTimeCodeInterval> parseTimeIntervals(TtEltype ttmlElement, PEltype[] pArray, String defaultRegion, SubtitleDescriptionDocument.SubtitleDescription desc) throws SubtitleSMPTEException {
        ArrayList timeIntervals = Lists.newArrayList();
        SampleRate docTmcdSampleRate = new SampleRate(ttmlElement.getFrameRate().longValue(), ttmlElement.getFrameRateMultiplier());
        SMPTETimeCode.Mode docTmcdMode = TTMLBeansEnumMapper.toSMPTEDropMode(ttmlElement.getDropMode());
        for (PEltype e : pArray) {
            if (!e.isSetBegin() || !e.isSetEnd()) {
                this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_TIMESTAMP_MISSING, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("message", SubtitleSummary.getPElementContent(e)));
                continue;
            }
            String currentRegion = defaultRegion;
            if (e.isSetRegion()) {
                currentRegion = e.getRegion();
            }
            SubtitleSMPTETimeCode beginTimecode = SubtitleSMPTETimeCode.parseSubtitleTimeCode(e.getBegin(), docTmcdSampleRate, docTmcdMode);
            SubtitleSMPTETimeCode endTimecode = SubtitleSMPTETimeCode.parseSubtitleTimeCode(e.getEnd(), docTmcdSampleRate, docTmcdMode);
            if (beginTimecode.shouldWarn()) {
                this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_TIMESTAMP_FORMAT_IS_NOT_CONSISTENT_WRT_DROPFRAME, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("timestamp", e.getBegin()));
            }
            if (endTimecode.shouldWarn()) {
                this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_TIMESTAMP_FORMAT_IS_NOT_CONSISTENT_WRT_DROPFRAME, MediaUtil.dictionary.add("javaClass", "SubtitleSummary").add("timestamp", e.getEnd()));
            }
            timeIntervals.add(new NamedTimeCodeInterval(beginTimecode, endTimecode, currentRegion));
        }
        return timeIntervals;
    }

    public static void countDisplayLocations(PEltype[] pArray, ITTRegionClassifier regionClassifier, SubtitleDescriptionDocument.SubtitleDescription desc) {
        long htop = 0L;
        long hbottom = 0L;
        long vleft = 0L;
        long vright = 0L;
        for (PEltype e : pArray) {
            ITTRegionClassifier.RegionType regionType;
            String paragraphRegion = regionClassifier.defaulRegionName();
            if (e.isSetRegion()) {
                paragraphRegion = e.getRegion();
            }
            if ((regionType = regionClassifier.classify(paragraphRegion)) == ITTRegionClassifier.RegionType.TOP) {
                ++htop;
                continue;
            }
            if (regionType == ITTRegionClassifier.RegionType.BOTTOM) {
                ++hbottom;
                continue;
            }
            if (regionType == ITTRegionClassifier.RegionType.LEFT) {
                ++vleft;
                continue;
            }
            if (regionType != ITTRegionClassifier.RegionType.RIGHT) continue;
            ++vright;
        }
        DisplayLocation displayLocation = desc.addNewDisplayLocation();
        displayLocation.setTop(BigInteger.valueOf(htop));
        displayLocation.setBottom(BigInteger.valueOf(hbottom));
        displayLocation.setLeft(BigInteger.valueOf(vleft));
        displayLocation.setRight(BigInteger.valueOf(vright));
    }

    public void checkBlankAndMaxNumberOfLinesPerPElement(PEltype[] pArray, SubtitleDescriptionDocument.SubtitleDescription desc) {
        boolean createdPewmttl = false;
        PElementsWithMoreThanTwoLines pewmttl = null;
        BlankPElements blanks = null;
        ArrayList multiLineText = Lists.newArrayList();
        for (PEltype p : pArray) {
            if (SubtitleSummary.isBlankPElementContent(p)) {
                if (blanks == null) {
                    blanks = desc.addNewBlankPElements();
                }
                SubtitleSummary.setPElement(blanks.addNewPElement(), p.getBegin(), p.getEnd());
            }
            if (this.getNumberOfBrElements(p.getDomNode()) <= 1) continue;
            if (!createdPewmttl) {
                pewmttl = desc.addNewPElementsWithMoreThanTwoLines();
                createdPewmttl = true;
            }
            SubtitleSummary.setPElement(pewmttl.addNewPElement(), p.getBegin(), p.getEnd());
            multiLineText.add(p.getBegin());
        }
        if (createdPewmttl) {
            String multiLineLocations = Joiner.on((String)", ").skipNulls().join((Iterable)multiLineText);
            this.ittValidationContext.addCheckAlert(MediaValidationCode.ITT_MULTILINETEXT_NOTSUPPORTED, MediaUtil.dictionary.add("locations", multiLineLocations).add("exampleLocation", (String)multiLineText.get(0)));
        }
    }

    private int getNumberOfBrElements(Node n) {
        NodeList children = n.getChildNodes();
        if (n.getNodeName().trim().toLowerCase().equals("br")) {
            return 1;
        }
        if (children.getLength() > 0) {
            int brCount = 0;
            for (int i = 0; i < children.getLength(); ++i) {
                brCount += this.getNumberOfBrElements(children.item(i));
            }
            return brCount;
        }
        return 0;
    }

    @Nonnull
    private static String getRegionForPara(PEltype p, @Nonnull String defaultRegion) {
        String paraRegion = p.getRegion();
        if (paraRegion == null || paraRegion.isEmpty()) {
            paraRegion = defaultRegion;
        }
        return paraRegion;
    }

    private static void setPElement(PElement pElement, String begin, String end) {
        if (pElement != null) {
            pElement.setBegin(begin);
            pElement.setEnd(end);
        }
    }

    private static String getPElementContent(PEltype p) {
        return Strings.nullToEmpty((String)((PEltypeImpl)p).getStringValue());
    }

    public void setCjkOverrideMap(String mapPropertiesFile) {
        this.cjkUtil.setOverrideMap(mapPropertiesFile);
    }

    public void setCjkOverrideMap(FileInputStream mapPropertiesFile) {
        this.cjkUtil.setOverrideMap(mapPropertiesFile);
    }

    public void setCjkOverrideMap(Map<Character, Character> overrideMap) {
        this.cjkUtil.setOverrideMap(overrideMap);
    }

    public void addToCjkOverrideMap(Map<Character, Character> overrideMap) {
        this.cjkUtil.addToOverrideMap(overrideMap);
    }

    public void setCjkOverrideMap() {
        this.cjkUtil.setOverrideMap();
    }

    public void resetCjkOverrideMap() {
        this.cjkUtil.resetOverrideMap();
    }

    public void shouldUseMultiCharMaping(boolean b) {
        this.cjkUtil.shouldUseMultiCharMapping(b);
    }

    public void halfToFullWidth() {
        if (this.cjkUtil == null) {
            this.cjkUtil = new UnicodeUtil.CJKCompatibility();
        }
        if (this.div != null) {
            for (PEltype p : this.div.getPArray()) {
                if (this.cjkUtil.getShouldUseMultiCharMapping()) {
                    this.mapMultiChar(p.getDomNode());
                }
                if (!this.isVerticalAllowed || !this.verticalRegions.contains(p.getRegion())) continue;
                this.halfToFullWidth(p.getDomNode());
            }
        }
    }

    private void halfToFullWidth(Node n) {
        if (n.getNodeName().equals("#text")) {
            n.setNodeValue(this.cjkUtil.halfToFullWidth(n.getNodeValue()));
            return;
        }
        if (this.tcyStyles.contains(((Element)n).getAttribute("style"))) {
            return;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.halfToFullWidth(children.item(i));
        }
    }

    private void mapMultiChar(Node n) {
        if (n.getNodeName().equals("#text")) {
            n.setNodeValue(this.cjkUtil.mapMultiChar(n.getNodeValue()));
            return;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.mapMultiChar(children.item(i));
        }
    }

    public int getLongestLineLength() {
        return this.longestLineLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getAllControlCharacters(SeekableDataInput sdi) {
        StringBuilder sb = new StringBuilder("Control characters found at: ");
        int prefixLength = sb.length();
        BufferedReader br = null;
        try {
            String line;
            sdi.seek(0L);
            SeekableInputStream sii = new SeekableInputStream(sdi);
            br = new BufferedReader(new InputStreamReader((InputStream)sii, "UTF-8"));
            int lineNum = 0;
            while ((line = br.readLine()) != null) {
                ++lineNum;
                for (int i = 0; i < line.length(); ++i) {
                    if (!Character.isISOControl(line.charAt(i))) continue;
                    if (sb.length() > prefixLength) {
                        sb.append(", ");
                    }
                    sb.append(String.format("(line %d, column %d, 0x%02X)", lineNum, i + 1, (int)line.charAt(i)));
                }
            }
        }
        catch (IOException e) {
            try {
                logger.warn((Object)("Error in scanning for control characters, ignoring... (" + e.getMessage() + ")"));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)br);
        }
        IOUtils.closeQuietly((Reader)br);
        if (prefixLength == sb.length()) {
            return null;
        }
        return sb.toString();
    }

    private static Throwable getInterestingCauseRecursively(Throwable t) {
        ImmutableSet notInterestingCauses = ImmutableSet.of(XmlException.class, SAXParseException.class);
        for (Throwable throwable = t; throwable != null; throwable = throwable.getCause()) {
            if (notInterestingCauses.contains(throwable.getClass())) continue;
            return throwable;
        }
        return null;
    }

    private static boolean isBlankPElementContent(PEltype p) {
        String data = ((PEltypeImpl)p).getStringValue();
        Matcher m = ALL_WHITESPACE_PATTERN.matcher(data);
        return m.matches();
    }

    private static class EntityListener
    implements EntityResolver {
        private EntityListener() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }

    private static class Interval
    implements Comparable<Interval> {
        SMPTETimeCode start;
        SMPTETimeCode end;
        PEltype pElement;
        @Nonnull
        String regionName;
        @Nullable
        Set<String> overlappingRegions;
        boolean timeOverlapAllowedAcrossNonoverLappingRegions;

        public Interval(PEltype p, TtEltype tt, @Nonnull String paraRegionName, @Nullable Set<String> overlappingRegionsForParaRegion, boolean isTimeOverlapAllowedAcrossNonoverlappingRegions) throws SubtitleSMPTEException {
            this.pElement = p;
            this.regionName = paraRegionName;
            this.overlappingRegions = overlappingRegionsForParaRegion;
            this.timeOverlapAllowedAcrossNonoverLappingRegions = isTimeOverlapAllowedAcrossNonoverlappingRegions;
            SampleRate docTmcdSampleRate = new SampleRate(tt.getFrameRate().longValue(), tt.getFrameRateMultiplier());
            SMPTETimeCode.Mode docTmcdMode = TTMLBeansEnumMapper.toSMPTEDropMode(tt.getDropMode());
            this.start = SubtitleSMPTETimeCode.parseSubtitleTimeCode(p.getBegin(), docTmcdSampleRate, docTmcdMode);
            this.end = SubtitleSMPTETimeCode.parseSubtitleTimeCode(p.getEnd(), docTmcdSampleRate, docTmcdMode);
        }

        @Override
        public int compareTo(@Nonnull Interval otherInt) {
            if (this.timeOverlapAllowedAcrossNonoverLappingRegions) {
                if (null != this.overlappingRegions && this.overlappingRegions.contains(otherInt.regionName) || this.regionName.equals(otherInt.regionName)) {
                    if (this.start.getMediaTime().compareTo(otherInt.start.getMediaTime()) < 0 && this.end.getMediaTime().compareTo(otherInt.start.getMediaTime()) < 0) {
                        return -1;
                    }
                    if (this.start.getMediaTime().compareTo(otherInt.end.getMediaTime()) > 0 && this.end.getMediaTime().compareTo(otherInt.end.getMediaTime()) > 0) {
                        return 1;
                    }
                    return 0;
                }
                return this.regionName.compareTo(otherInt.regionName);
            }
            if (this.start.getMediaTime().compareTo(otherInt.start.getMediaTime()) < 0 && this.end.getMediaTime().compareTo(otherInt.start.getMediaTime()) < 0) {
                return -1;
            }
            if (this.start.getMediaTime().compareTo(otherInt.end.getMediaTime()) > 0 && this.end.getMediaTime().compareTo(otherInt.end.getMediaTime()) > 0) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "" + this.pElement.getRegion() + ": " + this.start.toSMPTEString() + " to " + this.end.toSMPTEString();
        }
    }

    protected static class TextNodeData {
        private final Pair<String, Boolean> textData;

        TextNodeData(String data, boolean containsItalicRoman) {
            this.textData = Pair.of((Object)data, (Object)containsItalicRoman);
        }

        public String getTextData() {
            return (String)this.textData.getLeft();
        }

        public boolean containsItalicRoman() {
            return (Boolean)this.textData.getRight();
        }
    }
}

