/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle;

import com.apple.jingle.leghorn.subtitle.InconsistentSMPTETime;
import com.apple.jingle.leghorn.subtitle.MalformedSMPTETime;
import com.apple.jingle.leghorn.subtitle.SubtitleSMPTEException;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.google.common.base.Strings;

public class SubtitleSMPTETimeCode
extends SMPTETimeCode {
    private static final long serialVersionUID = 4472480235640553565L;
    boolean _wasSwapped = false;
    boolean _shouldWarn = false;
    public static final SubtitleSMPTETimeCode UNDEFINED = new SubtitleSMPTETimeCode();

    public SubtitleSMPTETimeCode() {
    }

    public SubtitleSMPTETimeCode(SMPTETimeCode timeCode) {
        super(timeCode);
    }

    public boolean swappedFrameSeparator() {
        return this._wasSwapped;
    }

    public boolean shouldWarn() {
        return this._shouldWarn;
    }

    public static SubtitleSMPTETimeCode parseSubtitleTimeCode(String smpteTimeCode, SampleRate frameRate, SMPTETimeCode.Mode timeCodeType) throws SubtitleSMPTEException {
        SubtitleSMPTETimeCode newTimeCode;
        boolean shouldWarn;
        if (!SubtitleSMPTETimeCode.isValid(smpteTimeCode)) {
            throw new MalformedSMPTETime(Strings.nullToEmpty((String)smpteTimeCode));
        }
        boolean wasSwapped = false;
        boolean bl = shouldWarn = SMPTETimeCode.guessMode(smpteTimeCode) != SMPTETimeCode.Mode.nonDrop;
        if (timeCodeType == SMPTETimeCode.Mode.dropNTSC || timeCodeType == SMPTETimeCode.Mode.dropPAL) {
            if (SMPTETimeCode.guessMode(smpteTimeCode) == SMPTETimeCode.Mode.nonDrop) {
                smpteTimeCode = SMPTETimeCode.swapFrameModeIndicator(smpteTimeCode, timeCodeType);
                wasSwapped = true;
            }
        } else if (timeCodeType == SMPTETimeCode.Mode.nonDrop && (SMPTETimeCode.guessMode(smpteTimeCode) == SMPTETimeCode.Mode.dropNTSC || SMPTETimeCode.guessMode(smpteTimeCode) == SMPTETimeCode.Mode.dropPAL)) {
            throw new InconsistentSMPTETime(smpteTimeCode);
        }
        try {
            newTimeCode = new SubtitleSMPTETimeCode(SMPTETimeCode.parseTimeCode(smpteTimeCode, frameRate, timeCodeType));
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedSMPTETime(ex.getMessage(), ex);
        }
        newTimeCode._wasSwapped = wasSwapped;
        newTimeCode._shouldWarn = shouldWarn;
        return newTimeCode;
    }
}

