/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlObject;
import org.w3.ns.ttml.RegionEltype;

public class ITTRegionClassifier {
    private List<RegionEltype> _regions = new ArrayList<RegionEltype>();
    private String _defaulRegionName = "";

    public ITTRegionClassifier(@Nonnull RegionEltype[] regions, @Nonnull String defaulRegionName) {
        if (regions != null) {
            Collections.addAll(this._regions, regions);
        }
        if (defaulRegionName.isEmpty()) {
            if (regions.length != 0) {
                this._defaulRegionName = this.getRegionName(regions[0]);
            }
        } else {
            this._defaulRegionName = defaulRegionName;
        }
    }

    public ITTRegionClassifier(@Nonnull RegionEltype[] regions) {
        this(regions, "");
    }

    public String defaulRegionName() {
        return this._defaulRegionName;
    }

    public boolean isVertical(@Nonnull String regionName) {
        RegionEltype region = this.getRegionByName(regionName);
        double[] extend = ITTRegionClassifier.stringToPercentagePair(region.getExtent());
        if (extend == null) {
            return false;
        }
        return extend[0] / extend[1] < 1.0;
    }

    public boolean isHorizontal(@Nonnull String regionName) {
        RegionEltype region = this.getRegionByName(regionName);
        double[] extend = ITTRegionClassifier.stringToPercentagePair(region.getExtent());
        if (extend == null) {
            return false;
        }
        return extend[0] / extend[1] >= 1.0;
    }

    public RegionType classify(@Nonnull String regionName) {
        double[] origin;
        RegionEltype region = this.getRegionByName(regionName);
        if (region == null) {
            return RegionType.BOTTOM;
        }
        if (this.isHorizontal(regionName)) {
            double[] origin2 = ITTRegionClassifier.stringToPercentagePair(region.getOrigin());
            if (origin2 != null) {
                if (origin2[0] == 0.0 && origin2[1] == 0.0) {
                    return RegionType.TOP;
                }
                if (origin2[0] == 0.0 && origin2[1] == 85.0) {
                    return RegionType.BOTTOM;
                }
            }
        } else if (this.isVertical(regionName) && (origin = ITTRegionClassifier.stringToPercentagePair(region.getOrigin())) != null) {
            if (origin[0] == 85.0 && origin[1] == 0.0) {
                return RegionType.RIGHT;
            }
            if (origin[0] == 0.0 && origin[1] == 0.0 || origin[0] == 15.0 && origin[1] == 0.0) {
                return RegionType.LEFT;
            }
        }
        return RegionType.BOTTOM;
    }

    private String getRegionName(RegionEltype region) {
        XmlObject xo;
        if (null != region && null != (xo = region.selectAttribute("http://www.w3.org/XML/1998/namespace", "id"))) {
            return ((SimpleValue)xo).getStringValue();
        }
        return "";
    }

    private RegionEltype getRegionByName(@Nonnull String regionName) {
        for (RegionEltype r : this._regions) {
            if (!this.getRegionName(r).equals(regionName)) continue;
            return r;
        }
        return null;
    }

    private static double[] stringToPercentagePair(@Nonnull String ss) {
        if (ss == null) {
            return null;
        }
        String[] splited = ss.split("\\s+");
        if (splited.length != 2) {
            return null;
        }
        if (!splited[0].endsWith("%") || !splited[1].endsWith("%")) {
            return null;
        }
        try {
            return new double[]{Double.valueOf(splited[0].substring(0, splited[0].length() - 1)), Double.valueOf(splited[1].substring(0, splited[1].length() - 1))};
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static enum RegionType {
        BOTTOM,
        TOP,
        LEFT,
        RIGHT;

    }
}

