/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.subtitle;

import com.apple.jingle.leghorn.subtitle.SubtitleDocument;
import com.apple.jingle.leghorn.subtitle.SubtitleDocumentParseException;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.TimeRange;
import com.apple.jingle.media.foundation.util.XMLUtil;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.smpteRa.schemas.x4287.x2007.dcst.SubtitleReelDocument;
import org.smpteRa.schemas.x4287.x2007.dcst.SubtitleReelType;
import org.smpteRa.schemas.x4287.x2007.dcst.SubtitleType;
import org.smpteRa.schemas.x4287.x2007.dcst.TextType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DCDMSubtitleDocument
implements SubtitleDocument {
    private SubtitleReelDocument subtitleReelDocument;

    private DCDMSubtitleDocument(SubtitleReelDocument sre) {
        this.subtitleReelDocument = sre;
    }

    @Override
    public MediaTime getFirstTimeCode() {
        throw new IllegalStateException("Unimplemented method");
    }

    @Override
    public long getFrameRate() {
        throw new IllegalStateException("Unimplemented method");
    }

    @Override
    public String getLanguage() {
        throw new IllegalStateException("Unimplemented method");
    }

    @Override
    public MediaTime getLastTimeCode() {
        throw new IllegalStateException("Unimplemented method");
    }

    @Override
    public long getNumberOfSamples() {
        throw new IllegalStateException("Unimplemented method");
    }

    @Override
    public void outputAsQuicktime3gpp(File outputFile, int trackWidth, int trackHeight) throws IOException, SubtitleDocumentParseException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = XMLUtil.getDocumentBuilderDisabledXXE();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document subtitleDocument = documentBuilder.newDocument();
        ProcessingInstruction qtProcessingInstruction = subtitleDocument.createProcessingInstruction("quicktime", "type=\"application/x-quicktime-sbtl\"");
        subtitleDocument.appendChild(qtProcessingInstruction);
        Element root = subtitleDocument.createElement("subtitleTrack");
        subtitleDocument.appendChild(root);
        root.setAttribute("trackWidth", trackWidth + ".0");
        root.setAttribute("trackHeight", trackHeight + ".0");
        root.setAttribute("layer", "0");
        root.setAttribute("language", "eng");
        root.setAttribute("timeScale", "1000");
        String startTimeStr = this.subtitleReelDocument.getSubtitleReel().getStartTime();
        if (startTimeStr == null) {
            startTimeStr = "01:00:00:00";
        }
        SMPTETimeCode startTime = SMPTETimeCode.parseTimeCode(startTimeStr, SMPTETimeCode.getDefaultFrameRate(), SMPTETimeCode.getDefaultSMPTETimeCodeType());
        this.recurse(root, this.subtitleReelDocument.getSubtitleReel().getSubtitleList().selectPath("*"), trackWidth, trackHeight, 1000L, this.subtitleReelDocument.getSubtitleReel().getTimeCodeRate().longValue(), new MediaTimeHolder(new SMPTETimeCode(startTime)));
        try {
            OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), Charsets.UTF_8);
            XMLUtil.serializeNode((Node)subtitleDocument, (int)0, (Writer)os);
            os.flush();
            os.close();
        }
        catch (TransformerException e) {
            throw new RuntimeException("Could not transform DOM to output stream for subtitling.", e);
        }
        catch (IOException e1) {
            throw new RuntimeException("Could not write temporary subtiting XML file", e1);
        }
    }

    private void recurse(Element rootElement, XmlObject[] documentObjects, int trackWidth, int trackHeight, long timeScale, long timeCodeFrameRate, MediaTimeHolder latestTimeCodeHolder) throws SubtitleDocumentParseException {
        Document doc = rootElement.getOwnerDocument();
        for (XmlObject documentObject : documentObjects) {
            if (documentObject instanceof SubtitleType) {
                SubtitleType sub = (SubtitleType)documentObject;
                SMPTETimeCode sampleTimeIn = SMPTETimeCode.parseTimeCode(sub.getTimeIn(), SMPTETimeCode.getDefaultFrameRate(), SMPTETimeCode.getDefaultSMPTETimeCodeType());
                SMPTETimeCode sampleTimeOut = SMPTETimeCode.parseTimeCode(sub.getTimeOut(), SMPTETimeCode.getDefaultFrameRate(), SMPTETimeCode.getDefaultSMPTETimeCodeType());
                if (latestTimeCodeHolder.latestTimeCode != null) {
                    MediaTime blankDuration = new TimeRange(latestTimeCodeHolder.latestTimeCode.getMediaTime(), sampleTimeIn.getMediaTime()).duration();
                    long blankTicks = blankDuration.getSampleCount();
                    if (blankTicks < 0L) {
                        throw new SubtitleDocumentParseException("DCDM timecode " + sampleTimeIn + " occurs earlier than previous sampleCount ended, at timecode " + latestTimeCodeHolder.latestTimeCode);
                    }
                    if (blankTicks != 0L) {
                        Element sampleDataElement = this.buildSampleData(rootElement, trackWidth, trackHeight, doc, blankTicks);
                        Element textElement = doc.createElement("text");
                        sampleDataElement.appendChild(textElement);
                        textElement.setAttribute("styleID", "1");
                        textElement.setTextContent("");
                    }
                }
                latestTimeCodeHolder.latestTimeCode = sampleTimeOut;
                long textTime = new TimeRange(sampleTimeIn.getMediaTime(), sampleTimeOut.getMediaTime()).duration().getSampleCount();
                if (textTime < 0L) {
                    throw new SubtitleDocumentParseException("DCDM sampleCount has out timecode " + sampleTimeOut + " that begins before in timecode " + sampleTimeIn);
                }
                if (textTime == 0L) {
                    throw new SubtitleDocumentParseException("DCDM sampleCount has out timecode " + sampleTimeOut + " equal to in timecode " + sampleTimeIn);
                }
                Element sampleDataElement = this.buildSampleData(rootElement, trackWidth, trackHeight, doc, textTime);
                for (TextType text : sub.getTextArray()) {
                    Element textElement = doc.createElement("text");
                    sampleDataElement.appendChild(textElement);
                    textElement.setAttribute("styleID", "1");
                    StringBuffer sb = new StringBuffer();
                    this.cheapReadableString(sb, text.getDomNode());
                    textElement.setTextContent(sb.toString() + "\n");
                }
                continue;
            }
            if (!(documentObject instanceof SubtitleReelType.SubtitleList.Font)) continue;
            SubtitleReelType.SubtitleList.Font font = (SubtitleReelType.SubtitleList.Font)documentObject;
            this.recurse(rootElement, (XmlObject[])font.getSubtitleArray(), trackWidth, trackHeight, timeScale, timeCodeFrameRate, latestTimeCodeHolder);
        }
    }

    private Element buildSampleData(Element rootElement, int trackWidth, int trackHeight, Document doc, long duration) {
        Element sampleElement = doc.createElement("sampleCount");
        rootElement.appendChild(sampleElement);
        sampleElement.setAttribute("duration", duration + "");
        sampleElement.setAttribute("keyframe", "true");
        Element descriptionElement = doc.createElement("description");
        sampleElement.appendChild(descriptionElement);
        descriptionElement.setAttribute("format", "tx3g");
        descriptionElement.setAttribute("horizontalJustification", "Center");
        descriptionElement.setAttribute("verticalJustification", "Bottom");
        descriptionElement.setAttribute("backgroundColor", "0%, 0%, 0%, 0%");
        Element defaultTextBoxElement = doc.createElement("defaultTextBox");
        descriptionElement.appendChild(defaultTextBoxElement);
        Element fontTableElement = doc.createElement("fontTable");
        descriptionElement.appendChild(fontTableElement);
        Element fontElement = doc.createElement("font");
        fontTableElement.appendChild(fontElement);
        fontElement.setAttribute("id", "1");
        fontElement.setAttribute("name", "Serif");
        Element sharedStylesElement = doc.createElement("sharedStyles");
        descriptionElement.appendChild(sharedStylesElement);
        Element styleElement = doc.createElement("style");
        sharedStylesElement.appendChild(styleElement);
        styleElement.setAttribute("id", "1");
        styleElement.setTextContent("{font-table: 1} {font-size:  24} {font-style:normal} {font-weight: normal} {color: 100%, 100%, 0%, 80%}");
        Element sampleDataElement = doc.createElement("sampleData");
        sampleElement.appendChild(sampleDataElement);
        sampleDataElement.setAttribute("targetEncoding", "utf8");
        return sampleDataElement;
    }

    private void cheapReadableString(StringBuffer sb, Node node) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.cheapReadableString(sb, nodeList.item(i));
            }
        } else if (node instanceof Text) {
            sb.append(((Text)node).getData());
        }
    }

    public static SubtitleDocument generateFromDCDMSubtitleXML(InputStream is) throws SubtitleDocumentParseException {
        try {
            return new DCDMSubtitleDocument(SubtitleReelDocument.Factory.parse((InputStream)is));
        }
        catch (XmlException e) {
            throw new SubtitleDocumentParseException("XmlException caught", e);
        }
        catch (IOException e) {
            throw new SubtitleDocumentParseException("IOException caught", e);
        }
    }

    public static void main(String[] args) {
        try {
            SubtitleDocument sd = DCDMSubtitleDocument.generateFromDCDMSubtitleXML(new FileInputStream("/Volumes/jtb/jeremy/Documents/Subtitles/SMPTE Examples/DCDMSample.xml"));
            sd.outputAsQuicktime3gpp(new File("/tmp/output.xml"), 853, 100);
            SubtitleDocument sd2 = DCDMSubtitleDocument.generateFromDCDMSubtitleXML(new FileInputStream("/Volumes/jtb/jeremy/Documents/Subtitles/SMPTE Examples/DCDMSample2.xml"));
            sd2.outputAsQuicktime3gpp(new File("/tmp/output2.xml"), 853, 100);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SubtitleDocumentParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static class MediaTimeHolder {
        SMPTETimeCode latestTimeCode;

        public MediaTimeHolder(SMPTETimeCode newTimeCode) {
            this.latestTimeCode = newTimeCode;
        }
    }
}

