/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.software;

import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.DescriptionWrapper;
import com.apple.jingle.leghorn.fileformat.UniformTypeIdentiferContainerTypeAdaptor;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.media.MediaDescriptionResult;
import com.apple.jingle.leghorn.software.SoftwareDescriber;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class SoftwareDescriptionFactory {
    public static final String PROP_SHOULD_GENERATE_DESCRIPTION = "SoftwareDescriptionFactory.shouldGenerateSoftwareDescription";

    public static Collection<MediaDescriptionResult> createDescription(File fileToDescribe, SoftwareDescriber<DescriptionWrapper> softwareDescriber, UniformTypeIdentifier uti) throws DescriptionException {
        MediaDescriptionResult mediaDescriptionResult;
        ContainerDescription containerDescription;
        UniformTypeIdentiferContainerTypeAdaptor containerTypeAdaptor = new UniformTypeIdentiferContainerTypeAdaptor(uti);
        try {
            containerDescription = softwareDescriber.describe(fileToDescribe.toURI(), (ContainerType)containerTypeAdaptor);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        ArrayList assetDescriptions = Lists.newArrayList();
        Object softwareDescriptionDocument = containerDescription.getDescriptionDocument();
        if (softwareDescriptionDocument instanceof DescriptionWrapper) {
            mediaDescriptionResult = new MediaDescriptionResult(softwareDescriber.getToolName(), softwareDescriber.getToolVersion(), new MediaDescriptionResult.Asset(containerTypeAdaptor.getName(), uti.getIdentifier(), null), (DescriptionWrapper)softwareDescriptionDocument);
        } else {
            try {
                mediaDescriptionResult = new MediaDescriptionResult(softwareDescriber.getToolName(), softwareDescriber.getToolVersion(), new MediaDescriptionResult.Asset(containerTypeAdaptor.getName(), uti.getIdentifier(), null), containerDescription.serializeToString());
            }
            catch (Exception e) {
                throw new DescriptionException(e);
            }
        }
        assetDescriptions.add(mediaDescriptionResult);
        return assetDescriptions;
    }
}

