/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.software;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.DescriptionWrapper;
import com.apple.jingle.leghorn.fileformat.FormatDescription;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.software.SoftwareDescriber;
import com.apple.jingle.leghorn.software.SoftwareDescriberLocationSpec;
import com.apple.jingle.leghorn.software.SoftwareDescriberLocationSpecFactoryUtil;
import com.apple.jingle.leghorn.software.SoftwareSupportService;
import com.apple.jingle.leghorn.software.ToolInvoker;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSoftwareDescriber
implements SoftwareDescriber<DescriptionWrapper> {
    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    protected static SoftwareDescriberLocationSpec createSoftwareDescriberLocationSpec(URI uri) {
        return SoftwareDescriberLocationSpecFactoryUtil.createSoftwareDescriberLocationSpecFactory().createLocationSpec(uri);
    }

    @Override
    public final ContainerDescription<DescriptionWrapper> describe(URI uri, ContainerType type) throws IOException, DescriptionException {
        SoftwareDescriberLocationSpec softwareDescriptionSpec = AbstractSoftwareDescriber.createSoftwareDescriberLocationSpec(uri);
        return this.describe(softwareDescriptionSpec, type);
    }

    @Override
    public ContainerDescription<DescriptionWrapper> describe(Verifier.Describable describable, ContainerType type) throws IOException, DescriptionException {
        return this.describe(describable.getLocalFile().toURI(), type);
    }

    @Override
    public ContainerDescription<DescriptionWrapper> describe(SoftwareDescriberLocationSpec softwareDescriptionSpec, ContainerType type) throws IOException, DescriptionException {
        DescriptionWrapper results = this.describe(softwareDescriptionSpec);
        return this.createContainerDescription(results, type);
    }

    protected DescriptionWrapper describe(SoftwareDescriberLocationSpec softwareDescriptionSpec) throws DescriptionException {
        String softwareFilePath = softwareDescriptionSpec.getSoftwareFilePath();
        SoftwareSupportService toolSupport = softwareDescriptionSpec.getToolSupport();
        ToolInvoker swinfoInvoker = toolSupport.getToolInvoker(SoftwareSupportService.Tool.SWINFO).addTargetFilePath(softwareFilePath);
        try {
            return swinfoInvoker.invoke();
        }
        catch (Exception e) {
            throw new DescriptionException(e);
        }
    }

    protected ContainerDescription<DescriptionWrapper> createContainerDescription(final DescriptionWrapper description, final ContainerType containerType) {
        return new ContainerDescription<DescriptionWrapper>(){

            @Override
            public ContainerType getType() {
                return containerType;
            }

            @Override
            public DescriptionWrapper getDescriptionDocument() {
                return description;
            }

            @Override
            public List<String> getStreamIdentifiers() {
                return Collections.emptyList();
            }

            @Override
            public boolean hasMultipleStreams() {
                return false;
            }

            @Override
            public FormatDescription<DescriptionWrapper> getStreamFormatDescription(String streamIdentifier) {
                return null;
            }

            @Override
            public String serializeToString() throws Exception {
                return this.getDescriptionDocument().serializeToString();
            }
        };
    }
}

