/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.scc.simple;

import com.apple.jingle.leghorn.scc.simple.SccBufferInstruction;
import com.apple.jingle.leghorn.scc.simple.SccColor;
import com.apple.jingle.leghorn.scc.simple.SccExtendedWesternEuropeanCharacter;
import com.apple.jingle.leghorn.scc.simple.SccMidRowBackgroundColorInstruction;
import com.apple.jingle.leghorn.scc.simple.SccMidRowBlackTextInstruction;
import com.apple.jingle.leghorn.scc.simple.SccMidRowNoBackgroundColorInstruction;
import com.apple.jingle.leghorn.scc.simple.SccMidRowStyleInstruction;
import com.apple.jingle.leghorn.scc.simple.SccNoOpInstruction;
import com.apple.jingle.leghorn.scc.simple.SccPreambleAddressInstruction;
import com.apple.jingle.leghorn.scc.simple.SccPreambleStyleInstruction;
import com.apple.jingle.leghorn.scc.simple.SccSetTabOffsetInstruction;
import com.apple.jingle.leghorn.scc.simple.SccSpecialNorthAmericanCharacter;
import com.apple.jingle.leghorn.scc.simple.SccStreamElement;
import com.apple.jingle.leghorn.scc.simple.SccStyle;
import com.apple.jingle.leghorn.scc.simple.SccTextInstruction;
import com.apple.jingle.leghorn.scc.simple.SccUnknownElement;
import com.apple.jingle.leghorn.scc.simple.SccXdsMetaData;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RawSccReader
implements Closeable {
    public static final Pattern linePattern = Pattern.compile("([0-9]{2}:[0-9]{2}:[0-9]{2}[:;][0-9]{2})\t(([0-9a-f]{4} )*([0-9a-f]{4}))", 2);
    private final LineNumberReader reader;
    private LinkedList<SccStreamElement> currentLine = null;
    private boolean readEof = false;
    static final String[] charMap = new String[96];

    public RawSccReader(Reader reader) throws IOException {
        this.reader = new LineNumberReader(reader);
        String line = this.reader.readLine();
        if (!line.equals("Scenarist_SCC V1.0")) {
            throw new IOException("Illegal SCC file header");
        }
    }

    public String readNextLine() throws IOException {
        if (this.readEof) {
            return null;
        }
        String line = this.reader.readLine();
        if (line == null) {
            this.readEof = true;
            return null;
        }
        if (!line.trim().isEmpty()) {
            throw new IOException("Expecting blank line before next entry at line " + this.reader.getLineNumber());
        }
        line = this.reader.readLine();
        if (line == null) {
            this.readEof = true;
            return null;
        }
        Matcher m = linePattern.matcher(line);
        if (!m.matches()) {
            throw new IOException("Invalid SCC line at line " + this.reader.getLineNumber());
        }
        this.currentLine = RawSccReader.parseSccData(m.group(2).replaceAll(" ", "").toCharArray());
        return m.group(1);
    }

    public SccStreamElement readNextLineElement() {
        if (this.currentLine != null && !this.currentLine.isEmpty()) {
            return this.currentLine.removeFirst();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    static int toChId(boolean secondChannelToggle, boolean line284) {
        int ch;
        int n = ch = line284 ? 3 : 1;
        if (secondChannelToggle) {
            ++ch;
        }
        return ch;
    }

    static final int toRowNum(int rowCode, boolean exRow, boolean nextRowDown) {
        int rowNum = -1;
        switch (rowCode) {
            case 0: {
                rowNum = exRow ? 14 : 11;
                break;
            }
            case 1: {
                rowNum = exRow ? 5 : 1;
                break;
            }
            case 2: {
                rowNum = exRow ? 7 : 3;
                break;
            }
            case 3: {
                rowNum = exRow ? 9 : 12;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (nextRowDown) {
            ++rowNum;
        }
        return rowNum;
    }

    static final int toInt(int value, int bitOffset, int bitCount) {
        if (bitOffset > 0) {
            value >>>= bitOffset;
        }
        int mask = 0;
        for (int idx = 0; idx < bitCount; ++idx) {
            mask <<= 1;
            mask |= 1;
        }
        return value & mask;
    }

    static final boolean toBool(int value, int bitOffset) {
        return RawSccReader.toInt(value, bitOffset, 1) == 1;
    }

    static void parseLine(String line) throws IOException {
        Matcher m = linePattern.matcher(line);
        if (m.matches()) {
            System.out.println(m.group(1) + ":");
            for (Object e : RawSccReader.parseSccData(m.group(2).replaceAll(" ", "").toCharArray())) {
                System.out.println(" ... " + e);
            }
            System.out.println();
        }
    }

    public static String toChar(int value) {
        if (value >= 32 && value <= 127) {
            return charMap[value - 32];
        }
        return null;
    }

    private static LinkedList<SccStreamElement> parseSccData(char[] chData) throws IOException {
        LinkedList<SccStreamElement> out = new LinkedList<SccStreamElement>();
        StringBuilder text = new StringBuilder();
        int lastValue = -1;
        int cursor = 0;
        while (cursor + 4 <= chData.length) {
            int value = Integer.parseInt(new String(chData, cursor, 4), 16) & 0x7F7F;
            int hiByte = value >>> 8;
            int loByte = value & 0x7F;
            switch (hiByte >>> 4) {
                case 0: {
                    if (text.length() > 0) {
                        out.add(new SccTextInstruction(text.toString()));
                        text.setLength(0);
                    }
                    if (value == 0) {
                        out.add(new SccNoOpInstruction());
                    } else {
                        out.add(new SccXdsMetaData(hiByte & 0xF, loByte & 0xF));
                    }
                    lastValue = -1;
                    break;
                }
                case 1: {
                    boolean secondChannelToggle = RawSccReader.toBool(value, 11);
                    if (lastValue == value) break;
                    if (text.length() > 0) {
                        out.add(new SccTextInstruction(text.toString()));
                        text.setLength(0);
                    }
                    if ((value & 0x7040) == 4160) {
                        if (RawSccReader.toBool(value, 4)) {
                            out.add(new SccPreambleAddressInstruction(secondChannelToggle, RawSccReader.toRowNum(RawSccReader.toInt(value, 8, 2), RawSccReader.toBool(value, 10), RawSccReader.toBool(value, 5)), RawSccReader.toInt(value, 1, 3) * 4, RawSccReader.toBool(value, 0)));
                        } else {
                            out.add(new SccPreambleStyleInstruction(secondChannelToggle, RawSccReader.toRowNum(RawSccReader.toInt(value, 8, 2), RawSccReader.toBool(value, 10), RawSccReader.toBool(value, 5)), SccStyle.values()[RawSccReader.toInt(value, 1, 3)], RawSccReader.toBool(value, 0)));
                        }
                    } else if ((value & 0x7670) == 5152) {
                        out.add(new SccBufferInstruction(secondChannelToggle, RawSccReader.toBool(value, 8), RawSccReader.toInt(value, 0, 4)));
                    } else if ((value & 0x7770) == 5920) {
                        out.add(new SccSetTabOffsetInstruction(secondChannelToggle, RawSccReader.toInt(value, 0, 2)));
                    } else if ((value & 0x7770) == 4128) {
                        out.add(new SccMidRowBackgroundColorInstruction(secondChannelToggle, SccColor.valueOf(RawSccReader.toInt(value, 1, 3)), RawSccReader.toBool(value, 0)));
                    } else if ((value & 0x7770) == 4384) {
                        out.add(new SccMidRowStyleInstruction(secondChannelToggle, SccStyle.values()[RawSccReader.toInt(value, 1, 3)], RawSccReader.toBool(value, 0)));
                    } else if ((value & 0x777E) == 5934) {
                        out.add(new SccMidRowBlackTextInstruction(secondChannelToggle, RawSccReader.toBool(value, 0)));
                    } else if ((value & 0x777F) == 5933) {
                        out.add(new SccMidRowNoBackgroundColorInstruction(secondChannelToggle));
                    } else if ((value & 0x7770) == 4400) {
                        out.add(new SccSpecialNorthAmericanCharacter(secondChannelToggle, loByte));
                    } else if ((value & 0x7770) == 4400) {
                        out.add(new SccExtendedWesternEuropeanCharacter(secondChannelToggle, RawSccReader.toBool(value, 8), loByte));
                    } else {
                        out.add(new SccUnknownElement(value));
                    }
                    lastValue = value;
                    break;
                }
                default: {
                    String ch2;
                    String ch1 = RawSccReader.toChar(hiByte);
                    if (ch1 != null) {
                        text.append(ch1);
                    }
                    if ((ch2 = RawSccReader.toChar(loByte)) != null) {
                        text.append(ch2);
                    }
                    lastValue = -1;
                }
            }
            cursor += 4;
        }
        if (text.length() > 0) {
            out.add(new SccTextInstruction(text.toString()));
            text.setLength(0);
        }
        return out;
    }

    public static void main(String[] parms) {
        try {
            try (RawSccReader reader = new RawSccReader(new FileReader("/Users/lconlyjr/jingle/AssetPool/Gossamer2Assetcaptions.e437015eea851cb85ec2f0524b9d775e.scc"));){
                String timeCode;
                while ((timeCode = reader.readNextLine()) != null) {
                    SccStreamElement e;
                    System.out.println(timeCode);
                    while ((e = reader.readNextLineElement()) != null) {
                        System.out.println("  " + e);
                    }
                    System.out.println();
                }
            }
            RawSccReader.parseLine("01:02:53:14\t1640");
            RawSccReader.parseLine("01:02:53:14\t94ae 94ae 9420 9420 947a 947a 97a2 97a2 a820 68ef f26e 2068 ef6e 6be9 6e67 2029 942c 942c 8080 8080 942f 942f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        for (int ch = 32; ch <= 127; ++ch) {
            RawSccReader.charMap[ch - 32] = Character.toString((char)ch);
        }
        RawSccReader.charMap[10] = "\u00e1";
        RawSccReader.charMap[60] = "\u00e9";
        RawSccReader.charMap[62] = "\u00ed";
        RawSccReader.charMap[63] = "\u00f3";
        RawSccReader.charMap[91] = "\u00e7";
        RawSccReader.charMap[92] = "\u00f7";
        RawSccReader.charMap[93] = "\u00d1";
        RawSccReader.charMap[94] = "\u00f1";
        RawSccReader.charMap[95] = "(SB)";
    }
}

