/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.scc;

import com.apple.jingle.leghorn.quicktime.SCCValidationContext;
import com.apple.jingle.leghorn.scc.SCCDocument;
import java.io.File;
import java.io.IOException;

public class ValidateSCCFileApplication {
    public static final String appName = "sccparse";

    public static void main(String[] args) {
        SCCDocument sccDocument = new SCCDocument();
        if (args.length < 1) {
            System.out.println("usage: sccparse [sccfile]");
            System.exit(1);
        }
        try {
            sccDocument = SCCDocument.createSCCDocument(new File(args[0]));
        }
        catch (IOException e) {
            System.out.println("Unable to access SCC file \"" + args[0] + "\"");
            e.printStackTrace();
            System.exit(1);
        }
        SCCValidationContext validationContext = sccDocument.getValidationContext();
        if (validationContext.hasValidationErrors()) {
            System.out.println("Unable to parse \"" + args[0] + "\"; this file is not well-formed SCC.");
            validationContext.setToolName("ValidateSCCFileApplication");
            System.out.println(validationContext);
            System.exit(1);
        }
        System.out.println("Successfully parsed \"" + args[0] + "\"; this file is well-formed SCC.");
    }
}

