/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.scc;

import com.apple.jingle.leghorn.timecode.SMPTETimeCode;

public class SCCTimeCode
implements Comparable<SCCTimeCode> {
    private SMPTETimeCode timecode;

    public long getFramesComponent() {
        return this.timecode.getFramesComponent();
    }

    public long getHoursComponent() {
        return this.timecode.getHoursComponent();
    }

    public boolean isDropFrame() {
        return this.timecode.isDropFrame();
    }

    public long getMinutesComponent() {
        return this.timecode.getMinutesComponent();
    }

    public long getSecondsComponent() {
        return this.timecode.getSecondsComponent();
    }

    @Override
    public int compareTo(SCCTimeCode b) {
        return this.timecode.compareTo(b.timecode);
    }

    public String toString() {
        return this.timecode.toSMPTEString();
    }

    public SCCTimeCode addFrames(long nFrames) {
        SCCTimeCode newTime = new SCCTimeCode();
        newTime.timecode = new SMPTETimeCode(this.timecode.getMediaTime().timeByAdjustingSamples(nFrames), this.timecode.getMode());
        return newTime;
    }

    private SCCTimeCode() {
    }

    public ValidationInformation getValidationInformation() {
        if (this.getHoursComponent() < 0L) {
            return new ValidationInformation(false, "Hours component is less than zero");
        }
        if (this.getMinutesComponent() < 0L) {
            return new ValidationInformation(false, "Minutes component is less than zero");
        }
        if (this.getMinutesComponent() > 59L) {
            return new ValidationInformation(false, "Minutes component is greater than 59");
        }
        if (this.getSecondsComponent() < 0L) {
            return new ValidationInformation(false, "Seconds component is less than zero");
        }
        if (this.getSecondsComponent() > 59L) {
            return new ValidationInformation(false, "Seconds component is greater than 59");
        }
        if (this.isDropFrame() && this.getMinutesComponent() % 10L != 0L && this.getSecondsComponent() == 0L && (this.getFramesComponent() == 0L || this.getFramesComponent() == 1L)) {
            return new ValidationInformation(false, "Timecode " + this + " doesn't exist in drop frame");
        }
        return new ValidationInformation(true, null);
    }

    private String padDigits(long srcLong, int padLength) {
        String src = Long.toString(srcLong);
        while (src.length() < padLength) {
            src = "0" + src;
        }
        return src;
    }

    public SCCTimeCode(long hoursComponent, long minutesComponent, long secondsComponent, long framesComponent, boolean isDropFrame) {
        String timeString = this.padDigits(hoursComponent, 2) + ":" + this.padDigits(minutesComponent, 2) + ":" + this.padDigits(secondsComponent, 2) + (isDropFrame ? ";" : ":") + this.padDigits(framesComponent, 2);
        this.timecode = SMPTETimeCode.parseTimeCode(timeString, SMPTETimeCode.ntsc2997, isDropFrame ? SMPTETimeCode.Mode.dropNTSC : SMPTETimeCode.Mode.nonDrop);
    }

    public SCCTimeCode(SCCTimeCode originalTimeCode) {
        this.timecode = originalTimeCode.timecode;
    }

    public static class ValidationInformation {
        private boolean isValid;
        private String failureReason;

        public ValidationInformation(boolean valid, String failureReason) {
            this.isValid = valid;
            this.failureReason = failureReason;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public String getFailureReason() {
            return this.failureReason;
        }
    }
}

