/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.scc;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.scc.SCCLineParseException;
import com.apple.jingle.leghorn.scc.SCCTimeCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SCCLine {
    private static final Pattern timecodePattern = Pattern.compile("([0-9]{2}):([0-9]{2}):([0-9]{2})([:;])([0-9]{2})");
    private static final Pattern sccItemPattern = Pattern.compile("([0-9A-Fa-f]{4})");
    private static final Pattern tabPattern = Pattern.compile("\t");
    private static final Pattern spacePattern = Pattern.compile(" +");
    private SCCTimeCode timeCode;
    private int[] payload;
    private String payloadString;
    private int lineNumber;
    private static HashMap<String, Boolean> parityMap = new HashMap();
    private List<String> ParseExceptions = new ArrayList<String>();

    public void addParseException(String exceptionMessage) {
        this.ParseExceptions.add(exceptionMessage);
    }

    public boolean hasParseExceptions() {
        return this.ParseExceptions.size() >= 1;
    }

    public static SCCLine createFromSCCLineString(LeghornValidationContext ctx, int lineNumber, String strLine) throws SCCLineParseException {
        return SCCLine.createFromSCCLineString(ctx, strLine, lineNumber, false);
    }

    public String getPayloadAsString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.payloadString.length(); ++i) {
            if (i != 0 && i % 4 == 0) {
                sb.append(' ');
            }
            sb.append(this.payloadString.charAt(i));
        }
        return sb.toString();
    }

    private void setPayloadString(String str) {
        this.payloadString = str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkParityIsOdd(String hexstr, int sccPayload, int index) {
        HashMap<String, Boolean> hashMap = parityMap;
        synchronized (hashMap) {
            if (parityMap.containsKey(hexstr)) {
                Boolean hasOddBits = parityMap.get(hexstr);
                if (!hasOddBits.booleanValue()) {
                    return false;
                }
            } else {
                int numberOfHighBits = 0;
                int tmpByte = sccPayload;
                for (int j = 0; j < 8; ++j) {
                    if (tmpByte % 2 == 1) {
                        ++numberOfHighBits;
                    }
                    tmpByte >>= 1;
                }
                if (numberOfHighBits % 2 != 1) {
                    parityMap.put(hexstr, Boolean.FALSE);
                    return false;
                }
                parityMap.put(hexstr, Boolean.TRUE);
            }
            return true;
        }
    }

    public static SCCLine createFromSCCLineString(LeghornValidationContext ctx, String strLine, int lineNumber, boolean ignoreParity) {
        SCCLine sccLine = new SCCLine();
        sccLine.setLineNumber(lineNumber);
        if (null == strLine) {
            String errorMessage = "Null line passed in";
            sccLine.addParseException(errorMessage);
            ctx.addCheckAlert(MediaValidationCode.CC_LINE_NULL, MediaUtil.dictionary.add("javaClass", "SCCLine"));
            return sccLine;
        }
        String[] items = tabPattern.split(strLine.trim());
        if (items.length != 2) {
            String errorMessage = "Line is not of format <timecode><tab><SCC payload>";
            sccLine.addParseException(errorMessage);
            ctx.addCheckAlert(MediaValidationCode.CC_LINE_FORMAT_INVALID, MediaUtil.dictionary.add("javaClass", "SCCLine").add("line", strLine));
            return sccLine;
        }
        Matcher matcher = timecodePattern.matcher(items[0]);
        if (!matcher.matches()) {
            String errorMessage = "Invalid timecode " + items[0];
            sccLine.addParseException(errorMessage);
            ctx.addCheckAlert(MediaValidationCode.CC_TIME_CODE_INVALID, MediaUtil.dictionary.add("javaClass", "SCCLine").add("timeCode", items[0]).add("line", strLine));
            return sccLine;
        }
        try {
            sccLine.timeCode = new SCCTimeCode(Long.parseLong(matcher.group(1)), Long.parseLong(matcher.group(2)), Long.parseLong(matcher.group(3)), Long.parseLong(matcher.group(5)), matcher.group(4).equals(";"));
        }
        catch (IllegalArgumentException e) {
            String errorMessage = "Invalid timecode " + items[0];
            sccLine.addParseException(errorMessage);
            ctx.addCheckAlert(MediaValidationCode.CC_TIME_CODE_INVALID, MediaUtil.dictionary.add("javaClass", "SCCLine").add("timeCode", items[0]).add("line", strLine));
            return sccLine;
        }
        sccLine.setPayloadString(items[1].trim().replaceAll(" +", ""));
        String[] sccItems = spacePattern.split(items[1].trim());
        sccLine.payload = new int[sccItems.length * 2];
        int index = 0;
        for (String sccItem : sccItems) {
            String errorMessage;
            String hexstr;
            matcher = sccItemPattern.matcher(sccItem);
            if (!matcher.matches()) {
                String errorMessage2 = String.format("SCC item (position %d) (line %d) does not match 4 hex characters", index / 2 + 1, sccLine.getLineNumber());
                sccLine.addParseException(errorMessage2);
                String posDesc = String.format("%s item (%s and %s byte)", MediaUtil.getOrdinal(index / 2 + 1), MediaUtil.getOrdinal(index + 1), MediaUtil.getOrdinal(index + 2));
                ctx.addCheckAlert(MediaValidationCode.CC_HEX_CHARACTERS_INVALID, MediaUtil.dictionary.add("javaClass", "SCCLine").add("position", posDesc).add("line", Integer.toString(sccLine.getLineNumber())));
                ++index;
                continue;
            }
            sccLine.payload[index] = Byte.parseByte(sccItem.substring(0, 1), 16);
            int n = index;
            sccLine.payload[n] = sccLine.payload[n] * 16;
            int n2 = index;
            sccLine.payload[n2] = sccLine.payload[n2] + Byte.parseByte(sccItem.substring(1, 2), 16);
            if (!ignoreParity && !SCCLine.checkParityIsOdd(hexstr = sccItem.substring(0, 2), sccLine.payload[index], index)) {
                errorMessage = String.format("Byte \"%s\" (position %d) fails parity check!", hexstr, index / 2 + 1);
                sccLine.addParseException(errorMessage);
                ctx.addCheckAlert(MediaValidationCode.CC_PARITY_CHECK_FAILURE, MediaUtil.dictionary.add("javaClass", "SCCLine").add("item", sccItem).add("position", Integer.toString(index / 2 + 1)).add("line", strLine));
                ++index;
                continue;
            }
            sccLine.payload[++index] = Byte.parseByte(sccItem.substring(2, 3), 16);
            int n3 = index;
            sccLine.payload[n3] = sccLine.payload[n3] * 16;
            int n4 = index;
            sccLine.payload[n4] = sccLine.payload[n4] + Byte.parseByte(sccItem.substring(3, 4), 16);
            if (!ignoreParity && !SCCLine.checkParityIsOdd(hexstr = sccItem.substring(2, 4), sccLine.payload[index], index)) {
                errorMessage = String.format("Byte \"%s\" (position %d) fails parity check!", hexstr, index / 2 + 1);
                sccLine.addParseException(errorMessage);
                ctx.addCheckAlert(MediaValidationCode.CC_PARITY_CHECK_FAILURE, MediaUtil.dictionary.add("javaClass", "SCCLine").add("item", hexstr).add("position", Integer.toString(index / 2 + 1)).add("line", strLine));
                ++index;
                continue;
            }
            ++index;
        }
        return sccLine;
    }

    public SCCTimeCode getTimeCode() {
        return this.timeCode;
    }

    public void setTimeCode(SCCTimeCode timeCode) {
        this.timeCode = timeCode;
    }

    public int[] getPayload() {
        return this.payload;
    }

    public void setPayload(int[] payload) {
        this.payload = payload;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getDurationInFrames() {
        return this.payload.length / 2;
    }

    public String getParityFreeCCHex() {
        return this.getParityFreeCCHex(true);
    }

    String getParityFreeCCHex(boolean addSpaces) {
        StringBuffer parityFreeCCHexBuffer = new StringBuffer();
        for (int i = 0; i < this.payload.length; ++i) {
            String hexStr;
            int tmpInt;
            if (addSpaces && i != 0 && i % 2 == 0) {
                parityFreeCCHexBuffer.append(" ");
            }
            if ((tmpInt = this.payload[i]) > 128) {
                tmpInt -= 128;
            }
            if ((hexStr = Integer.toHexString(tmpInt)).length() == 1) {
                hexStr = "0" + hexStr;
            }
            parityFreeCCHexBuffer.append(hexStr);
        }
        return parityFreeCCHexBuffer.toString();
    }

    public String getParityCCHex() {
        return this.getParityCCHex(true);
    }

    String getParityCCHex(boolean addSpaces) {
        StringBuffer parityFreeCCHexBuffer = new StringBuffer();
        for (int i = 0; i < this.payload.length; ++i) {
            String hexStr;
            if (addSpaces && i != 0 && i % 2 == 0) {
                parityFreeCCHexBuffer.append(" ");
            }
            int tmpInt = this.payload[i] & 0x7F;
            int highBits = 0;
            for (int j = 0; j < 7; ++j) {
                if ((double)((long)tmpInt & (long)Math.pow(2.0, j)) != Math.pow(2.0, j)) continue;
                ++highBits;
            }
            if (highBits % 2 == 0) {
                tmpInt += 128;
            }
            if ((hexStr = Integer.toHexString(tmpInt)).length() == 1) {
                hexStr = "0" + hexStr;
            }
            parityFreeCCHexBuffer.append(hexStr);
        }
        return parityFreeCCHexBuffer.toString();
    }

    static String readableStringForCCHex(String ccHex) {
        if (ccHex.equals("20")) {
            return " ";
        }
        if (ccHex.equals("21")) {
            return "!";
        }
        if (ccHex.equals("22")) {
            return "\"";
        }
        if (ccHex.equals("23")) {
            return "#";
        }
        if (ccHex.equals("24")) {
            return "$";
        }
        if (ccHex.equals("25")) {
            return "%";
        }
        if (ccHex.equals("26")) {
            return "&";
        }
        if (ccHex.equals("27")) {
            return "'";
        }
        if (ccHex.equals("28")) {
            return "(";
        }
        if (ccHex.equals("29")) {
            return ")";
        }
        if (ccHex.equals("2a")) {
            return "\u00e5";
        }
        if (ccHex.equals("2b")) {
            return "+";
        }
        if (ccHex.equals("2c")) {
            return ",";
        }
        if (ccHex.equals("2d")) {
            return "-";
        }
        if (ccHex.equals("2e")) {
            return ".";
        }
        if (ccHex.equals("2f")) {
            return "/";
        }
        if (ccHex.equals("30")) {
            return "0";
        }
        if (ccHex.equals("31")) {
            return "1";
        }
        if (ccHex.equals("32")) {
            return "2";
        }
        if (ccHex.equals("33")) {
            return "3";
        }
        if (ccHex.equals("34")) {
            return "4";
        }
        if (ccHex.equals("35")) {
            return "5";
        }
        if (ccHex.equals("36")) {
            return "6";
        }
        if (ccHex.equals("37")) {
            return "7";
        }
        if (ccHex.equals("38")) {
            return "8";
        }
        if (ccHex.equals("39")) {
            return "9";
        }
        if (ccHex.equals("3a")) {
            return ":";
        }
        if (ccHex.equals("3b")) {
            return ";";
        }
        if (ccHex.equals("3c")) {
            return "<";
        }
        if (ccHex.equals("3d")) {
            return "=";
        }
        if (ccHex.equals("3e")) {
            return ">";
        }
        if (ccHex.equals("3f")) {
            return "?";
        }
        if (ccHex.equals("40")) {
            return "@";
        }
        if (ccHex.equals("41")) {
            return "A";
        }
        if (ccHex.equals("42")) {
            return "B";
        }
        if (ccHex.equals("43")) {
            return "C";
        }
        if (ccHex.equals("44")) {
            return "D";
        }
        if (ccHex.equals("45")) {
            return "E";
        }
        if (ccHex.equals("46")) {
            return "F";
        }
        if (ccHex.equals("47")) {
            return "G";
        }
        if (ccHex.equals("48")) {
            return "H";
        }
        if (ccHex.equals("49")) {
            return "I";
        }
        if (ccHex.equals("4a")) {
            return "J";
        }
        if (ccHex.equals("4b")) {
            return "K";
        }
        if (ccHex.equals("4c")) {
            return "L";
        }
        if (ccHex.equals("4d")) {
            return "M";
        }
        if (ccHex.equals("4e")) {
            return "N";
        }
        if (ccHex.equals("4f")) {
            return "O";
        }
        if (ccHex.equals("50")) {
            return "P";
        }
        if (ccHex.equals("51")) {
            return "Q";
        }
        if (ccHex.equals("52")) {
            return "R";
        }
        if (ccHex.equals("53")) {
            return "S";
        }
        if (ccHex.equals("54")) {
            return "T";
        }
        if (ccHex.equals("55")) {
            return "U";
        }
        if (ccHex.equals("56")) {
            return "V";
        }
        if (ccHex.equals("57")) {
            return "W";
        }
        if (ccHex.equals("58")) {
            return "X";
        }
        if (ccHex.equals("59")) {
            return "Y";
        }
        if (ccHex.equals("5a")) {
            return "Z";
        }
        if (ccHex.equals("5b")) {
            return "[";
        }
        if (ccHex.equals("5c")) {
            return "\u00e9";
        }
        if (ccHex.equals("5d")) {
            return "]";
        }
        if (ccHex.equals("5e")) {
            return "\u00ed";
        }
        if (ccHex.equals("5f")) {
            return "\u00f3";
        }
        if (ccHex.equals("60")) {
            return "\u00fa";
        }
        if (ccHex.equals("61")) {
            return "a";
        }
        if (ccHex.equals("62")) {
            return "b";
        }
        if (ccHex.equals("63")) {
            return "c";
        }
        if (ccHex.equals("64")) {
            return "d";
        }
        if (ccHex.equals("65")) {
            return "e";
        }
        if (ccHex.equals("66")) {
            return "f";
        }
        if (ccHex.equals("67")) {
            return "g";
        }
        if (ccHex.equals("68")) {
            return "h";
        }
        if (ccHex.equals("69")) {
            return "i";
        }
        if (ccHex.equals("6a")) {
            return "j";
        }
        if (ccHex.equals("6b")) {
            return "k";
        }
        if (ccHex.equals("6c")) {
            return "l";
        }
        if (ccHex.equals("6d")) {
            return "m";
        }
        if (ccHex.equals("6e")) {
            return "n";
        }
        if (ccHex.equals("6f")) {
            return "o";
        }
        if (ccHex.equals("70")) {
            return "p";
        }
        if (ccHex.equals("71")) {
            return "q";
        }
        if (ccHex.equals("72")) {
            return "r";
        }
        if (ccHex.equals("73")) {
            return "s";
        }
        if (ccHex.equals("74")) {
            return "t";
        }
        if (ccHex.equals("75")) {
            return "u";
        }
        if (ccHex.equals("76")) {
            return "v";
        }
        if (ccHex.equals("77")) {
            return "w";
        }
        if (ccHex.equals("78")) {
            return "x";
        }
        if (ccHex.equals("79")) {
            return "y";
        }
        if (ccHex.equals("7a")) {
            return "z";
        }
        if (ccHex.equals("7b")) {
            return "\u00e7";
        }
        if (ccHex.equals("7c")) {
            return "\u00f7";
        }
        if (ccHex.equals("7d")) {
            return "\u00d1";
        }
        if (ccHex.equals("7e")) {
            return "\u00f1";
        }
        if (ccHex.equals("7f")) {
            return " ";
        }
        return "";
    }
}

