/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.scc;

import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.SCCValidationContext;
import com.apple.jingle.leghorn.scc.SCCLine;
import com.apple.jingle.leghorn.scc.SCCTimeCode;
import com.apple.jingle.leghorn.scc.bizobjs.ClosedCaptionRenderingEvent;
import com.apple.jingle.leghorn.scc.bizobjs.PopOnCaption;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SCCDocument {
    private List<SCCLine> lines = new LinkedList<SCCLine>();
    private boolean endsWithNewline = true;
    private SCCValidationContext validationContext;

    public SCCDocument() {
        this(new SCCValidationContext("SCCDocumentClass_DefaultFile", "SCCDocumentClass_DefaultApplication", "DummyVersionNumber"));
    }

    public SCCDocument(SCCValidationContext ctx) {
        this.validationContext = ctx;
    }

    public SCCValidationContext getValidationContext() {
        return this.validationContext;
    }

    public List<SCCLine> getLines() {
        return this.lines;
    }

    public void addLine(SCCLine sccLine) {
        this.lines.add(sccLine);
    }

    public static SCCDocument createSCCDocument(File f) throws IOException {
        FileSeekableDataInput sdi = new FileSeekableDataInput(f);
        return SCCDocument.createSCCDocument((SeekableDataInput)sdi, false);
    }

    public static SCCDocument createSCCDocument(File f, boolean ignoreParity) throws IOException {
        FileSeekableDataInput sdi = new FileSeekableDataInput(f);
        return SCCDocument.createSCCDocument((SeekableDataInput)sdi, ignoreParity);
    }

    public static SCCDocument createSCCDocument(SeekableDataInput sdi) throws IOException {
        return SCCDocument.createSCCDocument(sdi, false);
    }

    public static SCCDocument createSCCDocument(SeekableDataInput sdi, boolean ignoreParity) throws IOException {
        SCCDocument sccDocument = new SCCDocument();
        sccDocument.validationContext.setFileName(sdi.getFileName());
        int line = 1;
        String tmpLine = sdi.readLine();
        if (null == tmpLine) {
            sccDocument.validationContext.addCheckAlert(MediaValidationCode.CC_FIRSTTIMECODE_MISSING, MediaUtil.dictionary.add("SCCDocument", "Line 1: EOF detected"));
            return sccDocument;
        }
        if (tmpLine.trim().isEmpty()) {
            ++line;
            tmpLine = sdi.readLine();
            if (null == tmpLine) {
                sccDocument.validationContext.addCheckAlert(MediaValidationCode.CC_FIRSTTIMECODE_MISSING, MediaUtil.dictionary.add("SCCDocument", "Line 1: EOF detected"));
                return sccDocument;
            }
        }
        if (!tmpLine.trim().matches("Scenarist_SCC V1.0")) {
            sccDocument.validationContext.addCheckAlert(MediaValidationCode.CC_SCENARIST_SCC_MISSING, MediaUtil.dictionary.add("javaClass", "SCCDocument").add("lineNumber", Integer.toString(line)));
        }
        ++line;
        SCCTimeCode beginningOfLastSCCLine = null;
        SCCTimeCode endOfLastSCCLine = null;
        while ((tmpLine = sdi.readLine()) != null) {
            if (!tmpLine.trim().isEmpty()) {
                sccDocument.validationContext.addCheckAlert(MediaValidationCode.CC_BLANK_LINE_EXPECTED, MediaUtil.dictionary.add("javaClass", "SCCDocument").add("lineNumber", Integer.toString(line)));
            } else {
                ++line;
                tmpLine = sdi.readLine();
            }
            if (tmpLine == null) break;
            SCCLine sccLine = SCCLine.createFromSCCLineString(sccDocument.validationContext, tmpLine.trim(), line, ignoreParity);
            if (!sccLine.hasParseExceptions()) {
                sccDocument.addLine(sccLine);
                if (beginningOfLastSCCLine != null && beginningOfLastSCCLine.compareTo(sccLine.getTimeCode()) != -1) {
                    sccDocument.validationContext.addCheckAlert(MediaValidationCode.CC_START_TIME_INVALID, MediaUtil.dictionary.add("javaClass", "SCCDocument").add("startTime", sccLine.getTimeCode().toString()).add("compareToType", "start").add("compareToTime", beginningOfLastSCCLine.toString()).add("line", Integer.toString(line)));
                }
                if (endOfLastSCCLine != null && endOfLastSCCLine.compareTo(sccLine.getTimeCode()) >= 0) {
                    sccDocument.validationContext.addCheckAlert(MediaValidationCode.CC_START_TIME_INVALID, MediaUtil.dictionary.add("javaClass", "SCCDocument").add("startTime", sccLine.getTimeCode().toString()).add("compareToType", "end").add("compareToTime", endOfLastSCCLine.toString()).add("line", Integer.toString(line)));
                }
                if (beginningOfLastSCCLine != null && beginningOfLastSCCLine.isDropFrame() != sccLine.getTimeCode().isDropFrame()) {
                    sccDocument.validationContext.addCheckAlert(MediaValidationCode.CC_DROP_MODE_MISMATCH, MediaUtil.dictionary.add("javaClass", "SCCDocument").add("currentTimeCode", sccLine.getTimeCode().toString()).add("previousTimeCode", beginningOfLastSCCLine.toString()).add("line", Integer.toString(line)));
                }
                if ((beginningOfLastSCCLine = sccLine.getTimeCode()) != null) {
                    endOfLastSCCLine = beginningOfLastSCCLine.addFrames(sccLine.getDurationInFrames() - 1);
                }
            }
            ++line;
        }
        sdi.seek(sdi.length() - 1L);
        if (sdi.readByte() != 10) {
            sccDocument.endsWithNewline = false;
        }
        return sccDocument;
    }

    public void export(OutputStream out) {
        PrintWriter pw = new PrintWriter(out);
        pw.print("Scenarist_SCC V1.0\r\n");
        pw.print("\r\n");
        int i = 0;
        for (SCCLine line : this.lines) {
            pw.write(line.getTimeCode().toString());
            pw.print('\t');
            pw.write(line.getPayloadAsString());
            pw.print("\r\n");
            if (this.lines.size() == ++i) continue;
            pw.print("\r\n");
        }
        pw.flush();
        pw.close();
    }

    private List<SCCLine> linesInPeriod(MediaTime periodStartMediaTime, MediaTime durationMediaTime, boolean applyOffset) {
        SampleRate sampleRate = SMPTETimeCode.ntsc2997;
        SMPTETimeCode.Mode mode = null;
        MediaTime startOffset = null;
        MediaTime threeFrames = null;
        long startMilliseconds = periodStartMediaTime.getTotalMilliseconds();
        long endMilliseconds = periodStartMediaTime.getTotalMilliseconds() + durationMediaTime.getTotalMilliseconds();
        LinkedList<SCCLine> newLines = new LinkedList<SCCLine>();
        for (SCCLine line : this.lines) {
            String lineStartSccTimeCode = line.getTimeCode().toString();
            String lineEndSccTimeCode = line.getTimeCode().addFrames(line.getDurationInFrames() - 1).toString();
            if (null == mode) {
                mode = SMPTETimeCode.guessMode(lineStartSccTimeCode);
            }
            MediaTime lineStartMediaTime = SMPTETimeCode.parseTimeCode(lineStartSccTimeCode, sampleRate, mode).getMediaTime();
            MediaTime lineEndMediaTime = SMPTETimeCode.parseTimeCode(lineEndSccTimeCode, sampleRate, mode).getMediaTime();
            if (null == startOffset) {
                MediaTime scaledStartTime = periodStartMediaTime.timeByScalingSampleRate(lineStartMediaTime.getRate());
                startOffset = applyOffset ? new MediaTime(-1L * scaledStartTime.getSampleCount(), scaledStartTime.getRate()) : new MediaTime(0L, scaledStartTime.getRate());
                threeFrames = new MediaTime(3L, scaledStartTime.getRate());
            }
            long lineStartMilliseconds = lineStartMediaTime.getTotalMilliseconds();
            long lineEndMilliseconds = lineEndMediaTime.getTotalMilliseconds();
            if (lineStartMilliseconds < startMilliseconds || lineStartMilliseconds > endMilliseconds || lineEndMilliseconds < startMilliseconds || lineEndMilliseconds > endMilliseconds) continue;
            MediaTime adjustedLineMediaTime = lineStartMediaTime.timeByAddingTime(startOffset);
            if (applyOffset && newLines.isEmpty() && adjustedLineMediaTime.getTotalMilliseconds() >= threeFrames.getTotalMilliseconds()) {
                SCCLine resetLine = SCCLine.createFromSCCLineString(this.validationContext, String.format("00:00:00%s00\t942c", mode.getIndicatorString()), line.getLineNumber(), false);
                newLines.add(resetLine);
            }
            SMPTETimeCode finalTimeCode = new SMPTETimeCode(adjustedLineMediaTime.timeByScalingSampleRate(lineStartMediaTime.getRate()), mode);
            SCCTimeCode finalSccTimecode = new SCCTimeCode(finalTimeCode.getHoursComponent(), finalTimeCode.getMinutesComponent(), finalTimeCode.getSecondsComponent(), finalTimeCode.getFramesComponent(), finalTimeCode.isDropFrame());
            line.setTimeCode(finalSccTimecode);
            newLines.add(line);
        }
        if (newLines.isEmpty()) {
            SCCLine resetLine = SCCLine.createFromSCCLineString(this.validationContext, String.format("00:00:00%s00\t942c", mode.getIndicatorString()), 1, false);
            newLines.add(resetLine);
        }
        return newLines;
    }

    public String timerangesWithinPeriod(MediaTime periodStartMediaTime, MediaTime durationMediaTime, int maxNumberOfRanges) {
        SampleRate sampleRate = SMPTETimeCode.ntsc2997;
        SMPTETimeCode.Mode mode = null;
        String timeranges = "";
        if (!this.lines.isEmpty() && periodStartMediaTime.getSampleCount() >= 0L && durationMediaTime.getSampleCount() >= 0L && maxNumberOfRanges > 0) {
            List<SCCLine> newLines = this.linesInPeriod(periodStartMediaTime, durationMediaTime, false);
            List<ClosedCaptionRenderingEvent> renderingEvents = this.linesToRenderingEvents(newLines);
            Collections.sort(renderingEvents, new Comparator<ClosedCaptionRenderingEvent>(){

                @Override
                public int compare(ClosedCaptionRenderingEvent o1, ClosedCaptionRenderingEvent o2) {
                    return Integer.compare(o2.toString().trim().replaceAll("\\s+", " ").length(), o1.toString().trim().replaceAll("\\s+", " ").length());
                }
            });
            int numberOfRanges = 0;
            StringBuilder sb = new StringBuilder("");
            for (ClosedCaptionRenderingEvent event : renderingEvents) {
                PopOnCaption popOnCaption;
                if (numberOfRanges >= maxNumberOfRanges || (popOnCaption = (PopOnCaption)event) == null) continue;
                String lineStartSccTimeCode = popOnCaption.getStartTimeCode().toString();
                String lineEndSccTimeCode = popOnCaption.getEndTimeCode().toString();
                if (null == mode) {
                    mode = SMPTETimeCode.guessMode(lineStartSccTimeCode);
                }
                MediaTime lineStartMediaTime = SMPTETimeCode.parseTimeCode(lineStartSccTimeCode, sampleRate, mode).getMediaTime();
                MediaTime lineEndMediaTime = SMPTETimeCode.parseTimeCode(lineEndSccTimeCode, sampleRate, mode).getMediaTime();
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(String.format("%d:%d", lineStartMediaTime.getTotalMilliseconds(), lineEndMediaTime.getTotalMilliseconds()));
                ++numberOfRanges;
            }
            timeranges = sb.toString();
        }
        return timeranges;
    }

    public void applyOffsetForDuration(MediaTime periodStartMediaTime, MediaTime durationMediaTime) {
        if (!this.lines.isEmpty() && periodStartMediaTime.getSampleCount() >= 0L && durationMediaTime.getSampleCount() >= 0L) {
            List<SCCLine> newLines = this.linesInPeriod(periodStartMediaTime, durationMediaTime, true);
            this.lines.clear();
            this.lines.addAll(newLines);
        }
    }

    public void applyTimeCodeOffset(String offset) {
        SampleRate sampleRate = SMPTETimeCode.ntsc2997;
        SMPTETimeCode offsetTimecode = null;
        SMPTETimeCode.Mode mode = null;
        for (SCCLine line : this.lines) {
            String sccTimeCode = line.getTimeCode().toString();
            if (null == mode) {
                mode = SMPTETimeCode.guessMode(sccTimeCode);
                offsetTimecode = SMPTETimeCode.parseTimeCodeWithSwapFrameMode(offset, sampleRate, mode);
            }
            SMPTETimeCode timeCode = SMPTETimeCode.parseTimeCode(sccTimeCode, sampleRate, mode);
            MediaTime lineMediaTime = timeCode.getMediaTime().timeByAddingTime(offsetTimecode.getMediaTime());
            SMPTETimeCode finalTimeCode = new SMPTETimeCode(lineMediaTime.timeByScalingSampleRate(lineMediaTime.getRate()), mode);
            SCCTimeCode finalSccTimecode = new SCCTimeCode(finalTimeCode.getHoursComponent(), finalTimeCode.getMinutesComponent(), finalTimeCode.getSecondsComponent(), finalTimeCode.getFramesComponent(), finalTimeCode.isDropFrame());
            line.setTimeCode(finalSccTimecode);
        }
    }

    public SCCTimeCode getFirstTimeCode() {
        if (this.getLines() != null && !this.getLines().isEmpty()) {
            return this.getLines().get(0).getTimeCode();
        }
        return null;
    }

    public SCCTimeCode getLastTimeCode() {
        if (this.getLines() != null && !this.getLines().isEmpty()) {
            return this.getLines().get(this.getLines().size() - 1).getTimeCode();
        }
        return null;
    }

    public int getNumberOfSamples() {
        if (this.getLines() != null) {
            return this.getLines().size();
        }
        return 0;
    }

    private List<ClosedCaptionRenderingEvent> linesToRenderingEvents(List<SCCLine> sccLines) {
        LinkedList<ClosedCaptionRenderingEvent> renderList = new LinkedList<ClosedCaptionRenderingEvent>();
        PopOnCaption currentCaption = null;
        PopOnCaption previousCaption = null;
        SCCTimeCode currentTimeCode = null;
        Iterator<SCCLine> it = sccLines.iterator();
        StringBuilder captionBuffer = new StringBuilder();
        while (it.hasNext()) {
            SCCLine sccLine = it.next();
            currentTimeCode = new SCCTimeCode(sccLine.getTimeCode());
            String parityFreeCCHex = sccLine.getParityFreeCCHex(false);
            boolean spaceAdded = true;
            for (int i = 0; i < parityFreeCCHex.length() / 4; ++i) {
                String currentCCHex = parityFreeCCHex.substring(i * 4, i * 4 + 2);
                String currentCCHex2 = parityFreeCCHex.substring(i * 4 + 2, i * 4 + 4);
                if (currentCCHex.startsWith("1")) {
                    if (currentCCHex.equalsIgnoreCase("14") && currentCCHex2.equalsIgnoreCase("20")) {
                        if (captionBuffer == null) {
                            captionBuffer = new StringBuilder();
                        }
                        currentCaption = new PopOnCaption();
                    } else if (currentCCHex.equalsIgnoreCase("14") && currentCCHex2.equalsIgnoreCase("2c")) {
                        if (previousCaption != null) {
                            previousCaption.setEndTimeCode(new SCCTimeCode(currentTimeCode));
                            previousCaption = null;
                        }
                    } else if (currentCCHex.equalsIgnoreCase("14") && currentCCHex2.equalsIgnoreCase("2f")) {
                        if (currentCaption != null) {
                            currentCaption.setStartTimeCode(new SCCTimeCode(currentTimeCode));
                            currentCaption.setTextContents(captionBuffer.toString());
                            renderList.add(currentCaption);
                            previousCaption = currentCaption;
                            currentCaption = null;
                            captionBuffer = null;
                        }
                    } else if (!spaceAdded && captionBuffer != null) {
                        captionBuffer.append(" ");
                        spaceAdded = true;
                    }
                } else {
                    if (captionBuffer != null) {
                        captionBuffer.append(SCCLine.readableStringForCCHex(currentCCHex));
                        captionBuffer.append(SCCLine.readableStringForCCHex(currentCCHex2));
                    }
                    spaceAdded = false;
                }
                currentTimeCode = currentTimeCode.addFrames(1L);
            }
        }
        if (currentCaption != null) {
            currentCaption.setStartTimeCode(new SCCTimeCode(currentTimeCode));
            if (previousCaption != null) {
                previousCaption.setEndTimeCode(new SCCTimeCode(currentTimeCode).addFrames(-1L));
            }
            currentCaption.setTextContents(captionBuffer.toString());
            renderList.add(currentCaption);
        }
        return renderList;
    }

    public List<ClosedCaptionRenderingEvent> render() {
        List<SCCLine> sccLines = this.getLines();
        return this.linesToRenderingEvents(sccLines);
    }

    public int getMaximumFrameIndex() {
        long maximumFrameIndex = 0L;
        for (SCCLine line : this.getLines()) {
            maximumFrameIndex = Math.max(line.getTimeCode().getFramesComponent(), maximumFrameIndex);
        }
        return (int)maximumFrameIndex;
    }

    public boolean hasDropFrame() {
        for (SCCLine line : this.getLines()) {
            if (!line.getTimeCode().isDropFrame()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonDropFrame() {
        for (SCCLine line : this.getLines()) {
            if (line.getTimeCode().isDropFrame()) continue;
            return true;
        }
        return false;
    }

    public boolean endsWithNewline() {
        return this.endsWithNewline;
    }

    public int getLongestLineLength() {
        int longestRenderLine = 0;
        List<ClosedCaptionRenderingEvent> events = this.render();
        for (ClosedCaptionRenderingEvent event : events) {
            if (event.getTextContents() == null) continue;
            longestRenderLine = Math.max(longestRenderLine, event.getTextContents().length());
        }
        return longestRenderLine;
    }

    public static void main(String[] args) {
        File inputFile = new File(args[0]);
        File outputFile = new File(args[1]);
        try {
            SCCDocument sccDocument = SCCDocument.createSCCDocument(inputFile);
            try (FileOutputStream os = new FileOutputStream(outputFile);){
                sccDocument.applyOffsetForDuration(new MediaTime(60L, 1L), new MediaTime(600L, 1L));
                sccDocument.export(os);
            }
            String timeranges = sccDocument.timerangesWithinPeriod(new MediaTime(0L, 1L), new MediaTime(600L, 1L), 10);
            System.out.println("Timeranges for 0 to 10 minutes : " + timeranges);
            System.out.println("Longest line: " + sccDocument.getLongestLineLength());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

