/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.scc;

import com.apple.jingle.leghorn.quicktime.SCCValidationContext;
import com.apple.jingle.leghorn.scc.SCCDocument;
import com.apple.jingle.leghorn.scc.SCCLine;
import java.io.File;
import java.io.IOException;

public class DumpParityFreeSCCFileApplication {
    public static final String appName = "sccparityfreecc";

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: sccparityfreecc [sccfile]");
            System.exit(1);
        }
        SCCDocument sccDocument = new SCCDocument();
        try {
            sccDocument = SCCDocument.createSCCDocument(new File(args[0]));
        }
        catch (IOException e) {
            System.out.println("Unable to access SCC file \"" + args[0] + "\"");
            e.printStackTrace();
            System.exit(1);
        }
        SCCValidationContext validationContext = sccDocument.getValidationContext();
        if (validationContext.hasValidationErrors()) {
            System.out.println("Unable to parse \"" + args[0] + "\"; this file is not well-formed SCC.");
            validationContext.setToolName("DumpParityFreeSCCFileApplication");
            System.out.println(validationContext);
            System.exit(1);
        }
        for (SCCLine sccLine : sccDocument.getLines()) {
            System.out.println(sccLine.getTimeCode() + "\t" + sccLine.getParityFreeCCHex());
        }
    }
}

