/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.samples;

import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.TimecodeSampleDescription;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.Rational;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;

public class TimecodeSample {
    TimecodeSampleDescription sampleDescription;
    long counter = -1L;
    int hours = -1;
    int minutes = 1;
    int seconds = -1;
    int frames = -1;
    boolean isNegative;

    public void parseSample(BaseParser parser, SeekableDataInput seekableDataInput, SampleTableAtom.SampleCursor cursor) throws IOException {
        this.sampleDescription = (TimecodeSampleDescription)cursor.getSampleDescription();
        seekableDataInput.seek(cursor.getSamplePosition());
        this.counter = this.sampleDescription.getDataFormat().equals("tmcd") ? BitstreamReader.readU32((DataInput)seekableDataInput) : BitstreamReader.readU64((DataInput)seekableDataInput);
    }

    public boolean isTapeCounter() {
        return this.sampleDescription.isTapeCounter();
    }

    public long getCounter() {
        return this.counter;
    }

    public SMPTETimeCode asSMPTETimeCode(MediaTime atTime) {
        SampleRate sampleRate = new SampleRate((long)this.sampleDescription.getFps(), new Rational(this.sampleDescription.getTimeScalePerFrame(), this.sampleDescription.getFrameInRealTime() * (long)this.sampleDescription.getFps()).reduce());
        MediaTime mediaTime = new MediaTime(this.getCounter(), sampleRate).timeByAddingTime(atTime.timeByScalingSampleRate(sampleRate));
        return new SMPTETimeCode(mediaTime, this.sampleDescription.isDropFrame() ? SMPTETimeCode.Mode.dropNTSC : SMPTETimeCode.Mode.nonDrop);
    }
}

