/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.samples;

import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.atoms.MediaHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.samples.BaseSample;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;

public class CaptioningSample
extends BaseSample {
    private byte[] bytes;

    @Override
    public void parseSample(BaseParser parser, SeekableDataInput seekableDataInput, SampleTableAtom.SampleCursor sampleCursor) throws IOException {
        super.parseSample(parser, seekableDataInput, sampleCursor);
        if (!sampleCursor.getSampleDescription().getDataFormat().equals("c608")) {
            throw new IllegalArgumentException("Unknown data format when parsing captioning: " + sampleCursor.getSampleDescription().getDataFormat());
        }
        parser.always(seekableDataInput.readByte(), 99);
        parser.always(seekableDataInput.readByte(), 100);
        parser.always(seekableDataInput.readByte(), 97);
        parser.always(seekableDataInput.readByte(), 116);
        this.bytes = new byte[(int)(sampleCursor.getSampleLength() - 8L)];
        seekableDataInput.readFully(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean verifySample(SampleTableAtom.SampleCursor sampleCursor, MediaHeaderAtom mediaHeaderAtom) {
        return sampleCursor.getSampleDuration() / (mediaHeaderAtom.getTimeScale() / 30L) * 2L >= (long)this.bytes.length;
    }
}

