/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.esdsSampleDescriptionExtension;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class waveSampleDescriptionExtension
extends SampleDescription.SampleDescriptionExtension {
    protected static final Map<String, Class<?>> TYPE_CLASS_MAP = new HashMap();

    @Override
    public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        while (movieFile.getFilePointer() < this.offset + this.size) {
            long offset = movieFile.getFilePointer();
            long size = BitstreamReader.readU32(movieFile, parentMaxOffset);
            String type = BitstreamReader.readFourCC(movieFile, parentMaxOffset);
            if (new String(new char[]{'\u0000', '\u0000', '\u0000', '\u0000'}).equals(type)) break;
            if (size == 0L) {
                throw new IllegalArgumentException("Size of a decompression parameter atom cannot be 0. Zero size '" + type + "' atom at offset: " + offset);
            }
            if (TYPE_CLASS_MAP.containsKey(type)) {
                try {
                    QTAtom atom = (QTAtom)TYPE_CLASS_MAP.get(type).newInstance();
                    atom.setAttributes(offset, size, type);
                    atom.setParent(this);
                    if (atom instanceof SampleDescription.SampleDescriptionExtension) {
                        ((SampleDescription.SampleDescriptionExtension)atom).parseSampleDescriptionExtension(ctx, quickTimeParser, movieFile, Math.min(offset + size, parentMaxOffset));
                    } else {
                        atom.parseAtom(ctx, quickTimeParser, movieFile);
                    }
                    this.atoms.add(atom);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            movieFile.seek(offset + size);
        }
    }

    static {
        TYPE_CLASS_MAP.put("esds", esdsSampleDescriptionExtension.class);
    }
}

