/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions.sei;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class MasteringDisplayColorVolumeSeiMessage
implements DataDumpable {
    public static final int GREEN_X = 0;
    public static final int GREEN_Y = 1;
    public static final int BLUE_X = 2;
    public static final int BLUE_Y = 3;
    public static final int RED_X = 4;
    public static final int RED_Y = 5;
    public static final int WHITEPOINT_X = 6;
    public static final int WHITEPOINT_Y = 7;
    private final BigDecimal[] coordinate = new BigDecimal[8];
    private final BigDecimal maxDisplayMasteringLuminance;
    private final BigDecimal minDisplayMasteringLuminance;

    public MasteringDisplayColorVolumeSeiMessage(RawByteSequencePayloadReader reader) throws IOException {
        for (int idx = 0; idx < this.coordinate.length; ++idx) {
            int value = reader.readBits(16);
            this.coordinate[idx] = BigDecimal.valueOf(value * 2).movePointLeft(5).setScale(6, RoundingMode.HALF_UP);
        }
        this.maxDisplayMasteringLuminance = BigDecimal.valueOf((long)reader.readBits(32) & 0xFFFFFFFFL).movePointLeft(4).setScale(4, RoundingMode.HALF_UP);
        this.minDisplayMasteringLuminance = BigDecimal.valueOf((long)reader.readBits(32) & 0xFFFFFFFFL).movePointLeft(4).setScale(4, RoundingMode.HALF_UP);
    }

    public String toString() {
        return "MasteringDisplayColorVolumeSeiMessage[" + this.minDisplayMasteringLuminance + " cd/m2 - " + this.maxDisplayMasteringLuminance + " cd/m2]";
    }

    @Override
    public void dumpData(DataDump dump) {
        dump = dump.child("MasteringDisplayColorVolume");
        dump.write("R", this.coordinate[4] + "," + this.coordinate[5]);
        dump.write("G", this.coordinate[0] + "," + this.coordinate[1]);
        dump.write("B", this.coordinate[2] + "," + this.coordinate[3]);
        dump.write("W", this.coordinate[6] + "," + this.coordinate[7]);
        dump.write("maxLum", this.maxDisplayMasteringLuminance);
        dump.write("minLum", this.minDisplayMasteringLuminance);
    }
}

