/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class esdsSampleDescriptionExtension
extends SampleDescription.SampleDescriptionExtension {
    long version;
    int esid;
    int objectProfileIdentification;
    long streamType;
    long bufferSizeDb;
    long maxBitRate;
    long averageBitRate;
    long channelLayout;
    long frequency;
    long audioObjectType;
    int frameLengthFlag;
    int hasDependancyOnCoreCoder;
    long coreCoderDelay;
    int extensionFlag;
    long extensionAudioObjectType;
    long syncExtensionType;
    int sbrPresentFlag;
    long extensionSamplingFrequency;
    byte[] magic80s = new byte[]{-128, -128, -128};
    static final long AUDIO_OBJECT_TYPE_AAC_LC = 2L;
    static final long AUDIO_OBJECT_TYPE_AAC_SBR = 5L;
    static final int syncExtensionTypeLength = 11;
    static final long sbrExtensionType = 695L;
    protected static final Map<Long, String> AUDIO_OBJECT_TYPE_FOUR_CC_MAP = new HashMap<Long, String>();
    protected static final Map<Long, Integer> FREQUENCY_MAP;
    protected static final Map<Long, Long> CHANNEL_LAYOUT_MAP;

    private void skipPadding(SeekableDataInput movieFile) throws IOException {
        while (movieFile.readByte() == -128) {
        }
        movieFile.seek(movieFile.getFilePointer() - 1L);
    }

    @Override
    public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        this.version = movieFile.readInt();
        short ESDescriptionTag = movieFile.readByte();
        if (ESDescriptionTag != 3) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "We were expecting a ESDescriptionTag (0x3) but instead got 0x" + Integer.toHexString(ESDescriptionTag), movieFile.getFilePointer() - 1L).put("expectedTag", "0x3").put("actualTag", "0x" + Integer.toHexString(ESDescriptionTag));
        }
        this.skipPadding(movieFile);
        short ESDescLength = movieFile.readByte();
        long endOfESDescriptor = movieFile.getFilePointer() + (long)ESDescLength;
        this.esid = movieFile.readShort();
        movieFile.readByte();
        short decoderConfigDescTag = movieFile.readByte();
        if (decoderConfigDescTag != 4) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "We were expecting a DecoderConfigDescriptionTag (0x04) but we got something else " + decoderConfigDescTag, movieFile.getFilePointer() - 1L);
        }
        this.skipPadding(movieFile);
        short decoderConfigDescLength = movieFile.readByte();
        this.objectProfileIdentification = movieFile.readByte();
        byte[] streamTypeUpStreamAndReserved = new byte[1];
        movieFile.readFully(streamTypeUpStreamAndReserved);
        BitReader bitReader = new BitReader(streamTypeUpStreamAndReserved);
        this.streamType = bitReader.readUBits(6);
        byte[] bsdb = new byte[3];
        movieFile.readFully(bsdb);
        movieFile.readInt();
        movieFile.readInt();
        short decSpecInfoTag = movieFile.readByte();
        if (decSpecInfoTag == 5) {
            this.skipPadding(movieFile);
            short decoderSpecInfoSize = movieFile.readByte();
            byte[] decSpecInfo = new byte[decoderSpecInfoSize];
            movieFile.readFully(decSpecInfo);
            bitReader = new BitReader(decSpecInfo);
            this.audioObjectType = bitReader.readUBits(5);
            this.frequency = bitReader.readUBits(4);
            this.channelLayout = bitReader.readUBits(4);
            if (this.audioObjectType == 2L) {
                this.frameLengthFlag = bitReader.readBit();
                this.hasDependancyOnCoreCoder = bitReader.readBit();
                if (this.hasDependancyOnCoreCoder == 1) {
                    this.coreCoderDelay = bitReader.readUBits(14);
                }
                this.extensionFlag = bitReader.readBit();
                if (bitReader.currentBitOffset() <= (long)(decSpecInfo.length * 8 - 11)) {
                    this.syncExtensionType = bitReader.readUBits(11);
                }
                if (this.syncExtensionType == 695L) {
                    this.extensionAudioObjectType = bitReader.readUBits(5);
                    if (this.extensionAudioObjectType == 5L) {
                        this.sbrPresentFlag = bitReader.readBit();
                        this.extensionSamplingFrequency = bitReader.readUBits(4);
                    }
                }
            }
        }
        movieFile.seek(endOfESDescriptor);
    }

    public long getChannelLayout() {
        long channelLayoutKey;
        long l = channelLayoutKey = this.isSbrAacLc() ? this.channelLayout * (this.extensionSamplingFrequency / this.frequency) : this.channelLayout;
        if (CHANNEL_LAYOUT_MAP.containsKey(channelLayoutKey)) {
            return CHANNEL_LAYOUT_MAP.get(channelLayoutKey);
        }
        return CHANNEL_LAYOUT_MAP.get(2L);
    }

    public Integer getFrequency() {
        long frequencyKey;
        long l = frequencyKey = this.isSbrAacLc() ? this.extensionSamplingFrequency : this.frequency;
        if (FREQUENCY_MAP.containsKey(frequencyKey)) {
            return FREQUENCY_MAP.get(frequencyKey);
        }
        return FREQUENCY_MAP.get(0L);
    }

    @Override
    public String toString() {
        return "[" + this.getExtensionType() + "] [audioObjectType:" + this.audioObjectType + ", frequency: " + this.frequency + ", channelLayout: " + this.channelLayout + "]";
    }

    public String getCodecFourCC() {
        long audioObjectTypeKey;
        long l = audioObjectTypeKey = this.isSbrAacLc() ? this.extensionAudioObjectType : this.audioObjectType;
        if (AUDIO_OBJECT_TYPE_FOUR_CC_MAP.containsKey(audioObjectTypeKey)) {
            return AUDIO_OBJECT_TYPE_FOUR_CC_MAP.get(audioObjectTypeKey);
        }
        return "mp4a";
    }

    public String getRFC6381CodecLabel() {
        return "mp4a.40." + this.audioObjectType;
    }

    public boolean isSbrAacLc() {
        return this.audioObjectType == 2L && this.extensionAudioObjectType == 5L;
    }

    static {
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(0L, "null");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(1L, "aac ");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(2L, "aac ");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(3L, "aac ");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(4L, "aac ");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(5L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(6L, "aac ");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(7L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(8L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(9L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(10L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(11L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(12L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(13L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(14L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(15L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(16L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(17L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(18L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(19L, "aac ");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(20L, "aac ");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(21L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(22L, "aac ");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(23L, "aacl");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(24L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(25L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(26L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(27L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(28L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(29L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(30L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(31L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(32L, "mp1 ");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(33L, "mp2 ");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(34L, "mp3 ");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(35L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(36L, "alac");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(37L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(38L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(39L, "aace");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(40L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(41L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(42L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(43L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(44L, "mp4a");
        AUDIO_OBJECT_TYPE_FOUR_CC_MAP.put(45L, "mp4a");
        FREQUENCY_MAP = new HashMap<Long, Integer>();
        FREQUENCY_MAP.put(0L, 96000);
        FREQUENCY_MAP.put(1L, 88200);
        FREQUENCY_MAP.put(2L, 64000);
        FREQUENCY_MAP.put(3L, 48000);
        FREQUENCY_MAP.put(4L, 44100);
        FREQUENCY_MAP.put(5L, 32000);
        FREQUENCY_MAP.put(6L, 24000);
        FREQUENCY_MAP.put(7L, 22050);
        FREQUENCY_MAP.put(8L, 16000);
        FREQUENCY_MAP.put(9L, 12000);
        FREQUENCY_MAP.put(10L, 11025);
        FREQUENCY_MAP.put(11L, 8000);
        FREQUENCY_MAP.put(12L, 7350);
        CHANNEL_LAYOUT_MAP = new HashMap<Long, Long>();
        CHANNEL_LAYOUT_MAP.put(1L, 6553601L);
        CHANNEL_LAYOUT_MAP.put(2L, 6619138L);
        CHANNEL_LAYOUT_MAP.put(3L, 7471107L);
        CHANNEL_LAYOUT_MAP.put(4L, 0x740004L);
        CHANNEL_LAYOUT_MAP.put(5L, 7864325L);
        CHANNEL_LAYOUT_MAP.put(6L, 8126470L);
        CHANNEL_LAYOUT_MAP.put(7L, 8323080L);
    }
}

