/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Dumpsterable;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class dmixSampleDescriptionExtension
extends SampleDescription.SampleDescriptionExtension
implements Dumpsterable {
    private int version;
    private byte[] flags = new byte[3];
    private List<DMixInstruction> dmixInstructions = new ArrayList<DMixInstruction>();
    private int baseChannelCount;

    public dmixSampleDescriptionExtension(int baseChannelCount) {
        this.baseChannelCount = baseChannelCount;
    }

    @Override
    public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        this.version = BitstreamReader.readU8(movieFile, parentMaxOffset);
        movieFile.readFully(this.flags);
        if (this.version >= 1) {
            this.parseV1(ctx, quickTimeParser, movieFile, parentMaxOffset);
        } else {
            this.parseV0(ctx, quickTimeParser, movieFile, parentMaxOffset);
        }
    }

    private DMixInstruction makeDMixInstruction(SeekableDataInput movieFile, long parentMaxOffset) throws IOException {
        DMixInstruction dmixIns = new DMixInstruction();
        dmixIns.targetLayout = BitstreamReader.readU8(movieFile, parentMaxOffset);
        dmixIns.targetChannelCount = BitstreamReader.readU8(movieFile, parentMaxOffset);
        dmixIns.targetChannelCount = dmixIns.targetChannelCount & 0x7F;
        dmixIns.downMixId = BitstreamReader.readU8(movieFile, parentMaxOffset);
        dmixIns.inStream = dmixIns.downMixId >> 7 != 0;
        dmixIns.downMixId = dmixIns.downMixId & 0x7F;
        return dmixIns;
    }

    private void parseV0(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        DMixInstruction dmixIns = this.makeDMixInstruction(movieFile, parentMaxOffset);
        if (!dmixIns.inStream) {
            int coefSize = dmixIns.targetChannelCount * this.baseChannelCount / 2;
            if (coefSize != 0) {
                if (coefSize % 2 != 0) {
                    ++coefSize;
                }
                byte[] coefRaw = new byte[coefSize];
                DMixInstruction.access$402(dmixIns, new int[dmixIns.targetChannelCount * this.baseChannelCount]);
                movieFile.readFully(coefRaw);
                BitReader reader = new BitReader(coefRaw);
                for (int ii = 0; ii < dmixIns.targetChannelCount * this.baseChannelCount; ++ii) {
                    ((DMixInstruction)dmixIns).coef[ii] = (int)reader.readUBits(4);
                }
            } else {
                System.out.println("[DEV]: why do I have zero??");
            }
        }
        this.dmixInstructions.add(dmixIns);
    }

    private void parseV1(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        int downMixInstructionCount = BitstreamReader.readU8(movieFile, parentMaxOffset);
        downMixInstructionCount &= 0x7F;
        for (int ii = 0; ii < downMixInstructionCount; ++ii) {
            DMixInstruction dmixIns = this.makeDMixInstruction(movieFile, parentMaxOffset);
            if (!dmixIns.inStream) {
                int coefSize;
                int bitsToRead = dmixIns.targetChannelCount * this.baseChannelCount * 5 + 4;
                if ((coefSize = (bitsToRead += 8 - bitsToRead % 8) / 8) != 0) {
                    byte[] coefRaw = new byte[coefSize];
                    DMixInstruction.access$402(dmixIns, new int[dmixIns.targetChannelCount * this.baseChannelCount]);
                    movieFile.readFully(coefRaw);
                    BitReader reader = new BitReader(coefRaw);
                    dmixIns.downMixOffset = (int)reader.readUBits(4);
                    for (int ci = 0; ci < dmixIns.targetChannelCount * this.baseChannelCount; ++ci) {
                        ((DMixInstruction)dmixIns).coef[ci] = (int)reader.readUBits(5);
                    }
                } else {
                    System.out.println("[DEV]: why do I have zero??");
                }
            }
            this.dmixInstructions.add(dmixIns);
        }
    }

    @Override
    public List<KeyValuePair> getProperties() {
        return super.getProperties();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public int getInstructionCount() {
        return this.dmixInstructions.size();
    }

    public static class DMixInstruction {
        private int targetLayout;
        private int targetChannelCount;
        private boolean inStream;
        private int downMixId;
        private int downMixOffset;
        private int[] coef;

        static /* synthetic */ int[] access$402(DMixInstruction x0, int[] x1) {
            x0.coef = x1;
            return x1;
        }
    }
}

