/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.dac3SampleDescriptionExtension;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class dec3SampleDescriptionExtension
extends SampleDescription.SampleDescriptionExtension {
    byte[] payload;
    int dataRateInKBpersec;
    int numIndependentStreams;
    List<IndependentSubstream> independentSubStreams;

    @Override
    public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        this.payload = new byte[2];
        movieFile.readFully(this.payload);
        BitReader reader = new BitReader(this.payload);
        this.dataRateInKBpersec = (int)reader.readUBits(13);
        this.numIndependentStreams = (int)reader.readUBits(3) + 1;
        this.independentSubStreams = new ArrayList<IndependentSubstream>(this.numIndependentStreams);
        for (int i = 0; i < this.numIndependentStreams; ++i) {
            this.independentSubStreams.add(this.parseIndependentSubstream(quickTimeParser, movieFile));
        }
    }

    private IndependentSubstream parseIndependentSubstream(BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
        this.payload = new byte[2];
        movieFile.readFully(this.payload);
        BitReader reader = new BitReader(this.payload);
        IndependentSubstream independentSubstream = new IndependentSubstream();
        independentSubstream.sampleRate = dac3SampleDescriptionExtension.decodeSampleRate((int)reader.readUBits(2));
        independentSubstream.bsid = (char)reader.readUBits(5);
        reader.readBit();
        independentSubstream.associatedAudioService = false;
        if (1 == (reader.readBit() & 1)) {
            independentSubstream.associatedAudioService = true;
        }
        int bsmod = (int)reader.readUBits(3);
        int acmod = (int)reader.readUBits(3);
        independentSubstream.bitStreamMode = dac3SampleDescriptionExtension.BitStreamMode.decodeBitStreamMode(bsmod, acmod);
        independentSubstream.audioCodingMode = dac3SampleDescriptionExtension.AudioCodingMode.decodeAudioCodingMode(acmod);
        independentSubstream.lfe = false;
        if (1 == (reader.readBit() & 1)) {
            independentSubstream.lfe = true;
        }
        this.payload = new byte[1];
        movieFile.readFully(this.payload);
        reader = new BitReader(this.payload);
        reader.readUBits(3);
        independentSubstream.numDependentStreams = (int)reader.readUBits(4);
        if (0 < independentSubstream.numDependentStreams) {
            byte chanLocHighBit = (byte)reader.readBit();
            byte chanLocLowerBits = movieFile.readByte();
            independentSubstream.chanLoc = chanLocHighBit << 8 | chanLocLowerBits;
        }
        return independentSubstream;
    }

    public dac3SampleDescriptionExtension.AudioCodingMode getAudioCodingMode() {
        if (!this.independentSubStreams.isEmpty()) {
            return this.independentSubStreams.get((int)0).audioCodingMode;
        }
        return null;
    }

    public boolean isLfe() {
        if (!this.independentSubStreams.isEmpty()) {
            return this.independentSubStreams.get((int)0).lfe;
        }
        return false;
    }

    public List<dac3SampleDescriptionExtension.Channel> getDependentChannels() {
        if (!this.independentSubStreams.isEmpty()) {
            return this.independentSubStreams.get(0).getDependentChannels();
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public class IndependentSubstream {
        Float sampleRate;
        char bsid;
        boolean associatedAudioService;
        dac3SampleDescriptionExtension.BitStreamMode bitStreamMode;
        dac3SampleDescriptionExtension.AudioCodingMode audioCodingMode;
        boolean lfe;
        int numDependentStreams;
        int chanLoc;

        List<dac3SampleDescriptionExtension.Channel> mapChannelLocation(int chanIndex) {
            switch (chanIndex) {
                case 0: {
                    return Arrays.asList(dac3SampleDescriptionExtension.Channel.LC, dac3SampleDescriptionExtension.Channel.RC);
                }
                case 1: {
                    return Arrays.asList(dac3SampleDescriptionExtension.Channel.LRS, dac3SampleDescriptionExtension.Channel.RRS);
                }
                case 2: {
                    return Arrays.asList(dac3SampleDescriptionExtension.Channel.CS);
                }
                case 3: {
                    return Arrays.asList(dac3SampleDescriptionExtension.Channel.TS);
                }
                case 4: {
                    return Arrays.asList(dac3SampleDescriptionExtension.Channel.LSD, dac3SampleDescriptionExtension.Channel.RSD);
                }
                case 5: {
                    return Arrays.asList(dac3SampleDescriptionExtension.Channel.LW, dac3SampleDescriptionExtension.Channel.RW);
                }
                case 6: {
                    return Arrays.asList(dac3SampleDescriptionExtension.Channel.VHL, dac3SampleDescriptionExtension.Channel.VHR);
                }
                case 7: {
                    return Arrays.asList(dac3SampleDescriptionExtension.Channel.VHC);
                }
                case 8: {
                    return Arrays.asList(dac3SampleDescriptionExtension.Channel.LFE2);
                }
            }
            throw new IllegalStateException("Code issue in parsing chan_loc in dec3 sample description extension.");
        }

        List<dac3SampleDescriptionExtension.Channel> getDependentChannels() {
            ArrayList<dac3SampleDescriptionExtension.Channel> dependentChannels = null;
            for (int i = 0; i < 9; ++i) {
                int bitMask = 1 << i;
                if (0 == (this.chanLoc & bitMask)) continue;
                if (null == dependentChannels) {
                    dependentChannels = new ArrayList<dac3SampleDescriptionExtension.Channel>();
                }
                dependentChannels.addAll(this.mapChannelLocation(i));
            }
            return dependentChannels;
        }
    }
}

