/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.List;

public class dac3SampleDescriptionExtension
extends SampleDescription.SampleDescriptionExtension {
    byte[] payload;
    Float sampleRate;
    BitStreamMode bitStreamMode;
    AudioCodingMode audioCodingMode;
    boolean lfe;

    public static Float decodeSampleRate(int sampleRateCode) {
        Float sampleRate;
        switch (sampleRateCode) {
            case 0: {
                sampleRate = Float.valueOf(48.0f);
                break;
            }
            case 1: {
                sampleRate = Float.valueOf(44.1f);
                break;
            }
            case 2: {
                sampleRate = Float.valueOf(32.0f);
                break;
            }
            case 3: {
                sampleRate = null;
                break;
            }
            default: {
                throw new IllegalStateException("This should never be reached; there's a bug in the code that parses dac3 sample description extensions!");
            }
        }
        return sampleRate;
    }

    @Override
    public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        this.payload = new byte[3];
        movieFile.readFully(this.payload);
        int sampleRateCode = this.payload[0] >> 6 & 3;
        this.sampleRate = dac3SampleDescriptionExtension.decodeSampleRate(sampleRateCode);
        int bitStreamModeCode = (this.payload[0] & 1) << 2 | this.payload[1] >> 6;
        int audioCodingModeCode = this.payload[1] >> 3 & 7;
        this.bitStreamMode = BitStreamMode.decodeBitStreamMode(bitStreamModeCode, audioCodingModeCode);
        this.audioCodingMode = AudioCodingMode.decodeAudioCodingMode(audioCodingModeCode);
        int lfeCode = this.payload[1] >> 2 & 1;
        switch (lfeCode) {
            case 0: {
                this.lfe = false;
                break;
            }
            case 1: {
                this.lfe = true;
                break;
            }
            default: {
                throw new IllegalStateException("This should never be reached; there's a bug in the code that parses dac3 sample description extensions!");
            }
        }
    }

    @Override
    public String toString() {
        return "[" + this.getExtensionType() + "] sampleRate=" + this.sampleRate + "; bsmod=" + (Object)((Object)this.bitStreamMode) + "; acmod=" + (Object)((Object)this.audioCodingMode) + "; lfe=" + this.lfe;
    }

    public Float getSampleRate() {
        return this.sampleRate;
    }

    public BitStreamMode getBitStreamMode() {
        return this.bitStreamMode;
    }

    public AudioCodingMode getAudioCodingMode() {
        return this.audioCodingMode;
    }

    public boolean isLfe() {
        return this.lfe;
    }

    public static enum AudioCodingMode {
        m1p1("1+1", new Channel[]{Channel.Ch1, Channel.Ch2}),
        m1s0("1/0", new Channel[]{Channel.C}),
        m2s0("2/0", new Channel[]{Channel.L, Channel.R}),
        m3s0("3/0", new Channel[]{Channel.L, Channel.C, Channel.R}),
        m2s1("2/1", new Channel[]{Channel.L, Channel.R, Channel.S}),
        m3s1("3/1", new Channel[]{Channel.L, Channel.C, Channel.R, Channel.S}),
        m2s2("2/2", new Channel[]{Channel.L, Channel.R, Channel.SL, Channel.SR}),
        m3s2("3/2", new Channel[]{Channel.L, Channel.C, Channel.R, Channel.SL, Channel.SR});

        private String label;
        private Channel[] channels;

        private AudioCodingMode(String label, Channel[] channels) {
            this.label = label;
            this.channels = channels;
        }

        public static AudioCodingMode decodeAudioCodingMode(int audioCodingModeCode) {
            AudioCodingMode acMode;
            switch (audioCodingModeCode) {
                case 0: {
                    acMode = m1p1;
                    break;
                }
                case 1: {
                    acMode = m1s0;
                    break;
                }
                case 2: {
                    acMode = m2s0;
                    break;
                }
                case 3: {
                    acMode = m3s0;
                    break;
                }
                case 4: {
                    acMode = m2s1;
                    break;
                }
                case 5: {
                    acMode = m3s1;
                    break;
                }
                case 6: {
                    acMode = m2s2;
                    break;
                }
                case 7: {
                    acMode = m3s2;
                    break;
                }
                default: {
                    throw new IllegalStateException("This should never be reached; there's a bug in the code that parses dac3 sample description extensions!");
                }
            }
            return acMode;
        }

        public String getLabel() {
            return this.label;
        }

        public Channel[] getChannels() {
            return this.channels;
        }

        public String toString() {
            String retval = this.label + " (";
            boolean first = true;
            for (Channel channel : this.channels) {
                if (first) {
                    first = false;
                } else {
                    retval = retval + ", ";
                }
                retval = retval + (Object)((Object)channel);
            }
            retval = retval + ")";
            return retval;
        }

        public String getQuickTimeishRepresentation(boolean hasLfe) {
            String retval = this.channels.length == 2 && !hasLfe ? "Stereo (" : this.channels.length + (hasLfe ? ".1" : ".0") + " (";
            boolean first = true;
            for (Channel channel : this.channels) {
                if (first) {
                    first = false;
                } else {
                    retval = retval + " ";
                }
                retval = retval + channel.getQuickTimeishName();
            }
            if (hasLfe) {
                retval = retval + " LFE";
            }
            retval = retval + ")";
            return retval;
        }

        public static String getQuickTimeishRepresentation(List<String> channelNames, boolean hasLfe) {
            String retval = channelNames.size() == 2 && !hasLfe ? "Stereo (" : channelNames.size() + (hasLfe ? -1 : 0) + (hasLfe ? ".1" : ".0") + " (";
            boolean first = true;
            for (String channel : channelNames) {
                if (first) {
                    first = false;
                } else {
                    retval = retval + " ";
                }
                retval = retval + channel;
            }
            retval = retval + ")";
            return retval;
        }
    }

    public static enum Channel {
        Ch1("Discrete 1", "D1"),
        Ch2("Discrete 2", "D2"),
        C("Center", "C"),
        L("Left", "L"),
        R("Right", "R"),
        S("Surround", "S"),
        SL("Left Surround", "Ls"),
        SR("Right Surround", "Rs"),
        LC("Left Center", "Lc"),
        RC("Right Center", "Rc"),
        LRS("Left Rear Surround", "Lrs"),
        RRS("Right Rear Surround", "Rrs"),
        CS("Center Surround", "Cs"),
        TS("Top Surround", "Ts"),
        LSD("Left Surround Direct", "Lsd"),
        RSD("Right Surround Direct", "Rsd"),
        LW("Left Wide", "Lw"),
        RW("Right Wide", "Rw"),
        VHL("Left Vertical Height", "Lvh"),
        VHR("Right Vertical Height", "Rvh"),
        VHC("Vertical Height Center", "Cvh"),
        LTS("Left Top Surround", "Lts"),
        RTS("Right Top Surround", "Rts"),
        LFE2("LFE 2", "LFE2"),
        LFE("LFE Screen", "LFE");

        private String prettyName;
        private String quickTimeishName;

        private Channel(String prettyName, String quickTimeishName) {
            this.prettyName = prettyName;
            this.quickTimeishName = quickTimeishName;
        }

        public String getPrettyName() {
            return this.prettyName;
        }

        public String getQuickTimeishName() {
            return this.quickTimeishName;
        }
    }

    public static enum BitStreamMode {
        CompleteMain("Complete Main", "CM"),
        MusicAndEffects("Music and Effects", "ME"),
        VisuallyImpaired("Visually Impaired", "VI"),
        HearingImpaired("Hearing Impaired", "HI"),
        Dialogue("Dialogue", "D"),
        Commentary("Commentary", "C"),
        Emergency("Emergency", "E"),
        VoiceOver("VoiceOver", "VO"),
        Karaoke("Karaoke");

        private String abbreviation;
        private String prettyName;

        private BitStreamMode(String prettyName) {
            this.prettyName = prettyName;
        }

        private BitStreamMode(String prettyName, String abbreviation) {
            this.prettyName = prettyName;
            this.abbreviation = abbreviation;
        }

        public static BitStreamMode decodeBitStreamMode(int bitStreamModeCode, int audioCodingModeCode) {
            BitStreamMode bsMode;
            switch (bitStreamModeCode) {
                case 0: {
                    bsMode = CompleteMain;
                    break;
                }
                case 1: {
                    bsMode = MusicAndEffects;
                    break;
                }
                case 2: {
                    bsMode = VisuallyImpaired;
                    break;
                }
                case 3: {
                    bsMode = HearingImpaired;
                    break;
                }
                case 4: {
                    bsMode = Dialogue;
                    break;
                }
                case 5: {
                    bsMode = Commentary;
                    break;
                }
                case 6: {
                    bsMode = Emergency;
                    break;
                }
                case 7: {
                    if (audioCodingModeCode == 1) {
                        bsMode = VoiceOver;
                        break;
                    }
                    if (audioCodingModeCode > 1 && audioCodingModeCode < 8) {
                        bsMode = Karaoke;
                        break;
                    }
                    throw new IllegalStateException("Invalid acmod value " + audioCodingModeCode + " for bsmod value 7");
                }
                default: {
                    throw new IllegalStateException("This should never be reached; there's a bug in the code that parses dac3 sample description extensions!");
                }
            }
            return bsMode;
        }

        public String toString() {
            return this.prettyName + (this.abbreviation == null ? "" : " (" + this.abbreviation + ")");
        }
    }
}

