/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Dumpsterable;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class chanSampleDescriptionExtension
extends SampleDescription.SampleDescriptionExtension
implements Dumpsterable {
    int version;
    byte[] flags = new byte[3];
    long audioChannelLayoutTag;
    long channelBitmap;
    long numberChannelDescriptions;
    List<AudioChannelDescription> channelDescriptions = new LinkedList<AudioChannelDescription>();

    @Override
    public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
        this.version = BitstreamReader.readU8(movieFile, parentMaxOffset);
        movieFile.readFully(this.flags);
        this.audioChannelLayoutTag = BitstreamReader.readU32(movieFile, parentMaxOffset);
        this.channelBitmap = BitstreamReader.readU32(movieFile, parentMaxOffset);
        this.numberChannelDescriptions = BitstreamReader.readU32(movieFile, parentMaxOffset);
        int channelDescriptionNum = 0;
        while ((long)channelDescriptionNum < this.numberChannelDescriptions) {
            AudioChannelDescription channelDescription = new AudioChannelDescription();
            channelDescription.parseChannelDescription(quickTimeParser, movieFile, parentMaxOffset);
            this.channelDescriptions.add(channelDescription);
            ++channelDescriptionNum;
        }
    }

    @Override
    public String toString() {
        return "[" + this.getExtensionType() + "] audioChannelLayoutTag=0x" + Long.toHexString(this.audioChannelLayoutTag) + "; channelBitmap=0x" + Long.toHexString(this.channelBitmap) + "; channelDescriptions=" + this.channelDescriptions;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public byte[] getFlags() {
        return this.flags;
    }

    public long getAudioChannelLayoutTag() {
        return this.audioChannelLayoutTag;
    }

    public long getChannelBitmap() {
        return this.channelBitmap;
    }

    public long getNumberChannelDescriptions() {
        return this.numberChannelDescriptions;
    }

    public List<AudioChannelDescription> getChannelDescriptions() {
        return this.channelDescriptions;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        return super.getProperties();
    }

    public static class AudioChannelDescription {
        long audioChannelLabel;
        long channelFlags;
        long[] coordinates = new long[3];

        public void parseChannelDescription(BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException {
            this.audioChannelLabel = BitstreamReader.readU32(movieFile, parentMaxOffset);
            this.channelFlags = BitstreamReader.readU32(movieFile, parentMaxOffset);
            this.coordinates[0] = BitstreamReader.readU32(movieFile, parentMaxOffset);
            this.coordinates[1] = BitstreamReader.readU32(movieFile, parentMaxOffset);
            this.coordinates[2] = BitstreamReader.readU32(movieFile, parentMaxOffset);
        }

        public String toString() {
            return "audioChannelLabel=0x" + Long.toHexString(this.audioChannelLabel) + "; channelFlags=0x" + Long.toHexString(this.channelFlags);
        }

        public long getAudioChannelLabel() {
            return this.audioChannelLabel;
        }

        public long getChannelFlags() {
            return this.channelFlags;
        }

        public long[] getCoordinates() {
            return this.coordinates;
        }
    }
}

