/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.sampledescriptions;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.AvccSampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.DvccSampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.HvccSampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class VideoSampleDescription
extends SampleDescription {
    int version;
    int revisionLevel;
    String vendor;
    long temporalQuality;
    long spatialQuality;
    int width;
    int height;
    float hRes;
    float vRes;
    int frameCount;
    String compressorName;
    int depth;
    int colorTableID;

    @Override
    public void parseSampleDescription(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
        this.version = BitstreamReader.readU16(movieFile);
        this.revisionLevel = BitstreamReader.readU16(movieFile);
        this.vendor = BitstreamReader.readFourCC((DataInput)movieFile);
        this.temporalQuality = BitstreamReader.readU32((DataInput)movieFile);
        this.spatialQuality = BitstreamReader.readU32((DataInput)movieFile);
        this.width = BitstreamReader.readU16(movieFile);
        this.height = BitstreamReader.readU16(movieFile);
        this.hRes = BitstreamReader.readFixed32(movieFile);
        this.vRes = BitstreamReader.readFixed32(movieFile);
        quickTimeParser.always((int)BitstreamReader.readU32((DataInput)movieFile), 0);
        this.frameCount = BitstreamReader.readU16(movieFile);
        this.compressorName = quickTimeParser.readString(movieFile, 31);
        this.depth = BitstreamReader.readU16(movieFile);
        this.colorTableID = BitstreamReader.read16(movieFile);
    }

    @Override
    public SampleDescription.SampleDescriptionExtension createSampleDescriptionExtension(String extensionType, long sdeSize, long sdeOffset) {
        SampleDescription.SampleDescriptionExtension extension;
        if (extensionType != null) {
            switch (extensionType) {
                case "gama": {
                    extension = new gamaSampleDescriptionExtension();
                    break;
                }
                case "pasp": {
                    extension = new paspSampleDescriptionExtension();
                    break;
                }
                case "colr": {
                    extension = new colrSampleDescriptionExtension();
                    break;
                }
                case "fiel": {
                    extension = new fielSampleDescriptionExtension();
                    break;
                }
                case "clap": {
                    extension = new clapSampleDescriptionExtension();
                    break;
                }
                case "avcC": {
                    extension = new AvccSampleDescriptionExtension();
                    break;
                }
                case "uuid": {
                    extension = new uuidSampleDescriptionExtension();
                    break;
                }
                case "mdcv": {
                    extension = new mdcvSampleDescriptionExtension();
                    break;
                }
                case "clli": {
                    extension = new clliSampleDescriptionExtension();
                    break;
                }
                case "hvcC": {
                    extension = new HvccSampleDescriptionExtension();
                    break;
                }
                case "dvcC": {
                    extension = new DvccSampleDescriptionExtension();
                    break;
                }
                default: {
                    extension = new SampleDescription.SampleDescriptionExtension();
                    break;
                }
            }
        } else {
            extension = new SampleDescription.SampleDescriptionExtension();
        }
        extension.setAttributes(sdeOffset, sdeSize, extensionType);
        return extension;
    }

    @Override
    public String toString() {
        return "[" + this.trackType + "] dataFormat=" + this.dataFormat + "; width=" + this.width + "; height=" + this.height + "; frameCount=" + this.frameCount + "; compressorName=" + this.compressorName;
    }

    public int getVersion() {
        return this.version;
    }

    public int getRevisionLevel() {
        return this.revisionLevel;
    }

    public String getVendor() {
        return this.vendor;
    }

    public long getTemporalQuality() {
        return this.temporalQuality;
    }

    public long getSpatialQuality() {
        return this.spatialQuality;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getHRes() {
        return this.hRes;
    }

    public float getVRes() {
        return this.vRes;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public String getCompressorName() {
        return this.compressorName;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getColorTableID() {
        return this.colorTableID;
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        super.dumpData(dump);
        dump.write("version", this.version != 0, this.version).write("revisionLevel", this.revisionLevel != 0, this.revisionLevel).write("vendor", this.vendor).write("temporalQuality", this.temporalQuality).write("spatialQuality", this.spatialQuality).write("width", this.width).write("height", this.height).write("hRes", Float.valueOf(this.hRes)).write("vRes", Float.valueOf(this.vRes)).write("frameCount", this.frameCount).write("compressorName", this.compressorName).write("depth", this.depth).write("colorTableId", this.colorTableID != -1, this.colorTableID);
    }

    public class uuidSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        byte[] uuid = new byte[16];

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            movieFile.readFully(this.uuid);
            BitstreamReader.checkOffsetLimit(movieFile, parentMaxOffset);
        }

        @Override
        public void dumpData(@Nonnull DataDump dump) {
            super.dumpData(dump);
            dump.write("uuid", this.getUUIDAsHex());
        }

        @Override
        public String toString() {
            return "[" + this.getExtensionType() + "] " + this.getUUIDAsHex();
        }

        public String getUUIDAsHex() {
            return Integer.toHexString(this.uuid[0] & 0xFF) + Integer.toHexString(this.uuid[1] & 0xFF) + Integer.toHexString(this.uuid[2] & 0xFF) + Integer.toHexString(this.uuid[3] & 0xFF) + "-" + Integer.toHexString(this.uuid[4] & 0xFF) + Integer.toHexString(this.uuid[5] & 0xFF) + "-" + Integer.toHexString(this.uuid[6] & 0xFF) + Integer.toHexString(this.uuid[7] & 0xFF) + "-" + Integer.toHexString(this.uuid[8] & 0xFF) + Integer.toHexString(this.uuid[9] & 0xFF) + "-" + Integer.toHexString(this.uuid[10] & 0xFF) + Integer.toHexString(this.uuid[11] & 0xFF) + Integer.toHexString(this.uuid[12] & 0xFF) + Integer.toHexString(this.uuid[13] & 0xFF) + Integer.toHexString(this.uuid[14] & 0xFF) + Integer.toHexString(this.uuid[15] & 0xFF);
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("uuid", Atom.bytesAsHex(this.uuid)));
            return l;
        }
    }

    public class clapSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        long apertureWidth_N;
        long apertureWidth_D;
        long apertureHeight_N;
        long apertureHeight_D;
        long horizOff_N;
        long horizOff_D;
        long vertOff_N;
        long vertOff_D;

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            this.apertureWidth_N = BitstreamReader.read32(movieFile, parentMaxOffset);
            this.apertureWidth_D = BitstreamReader.read32(movieFile, parentMaxOffset);
            this.apertureHeight_N = BitstreamReader.read32(movieFile, parentMaxOffset);
            this.apertureHeight_D = BitstreamReader.read32(movieFile, parentMaxOffset);
            this.horizOff_N = BitstreamReader.read32(movieFile, parentMaxOffset);
            this.horizOff_D = BitstreamReader.read32(movieFile, parentMaxOffset);
            this.vertOff_N = BitstreamReader.read32(movieFile, parentMaxOffset);
            this.vertOff_D = BitstreamReader.read32(movieFile, parentMaxOffset);
        }

        public long getApertureWidth_N() {
            return this.apertureWidth_N;
        }

        public long getApertureWidth_D() {
            return this.apertureWidth_D;
        }

        public long getApertureHeight_N() {
            return this.apertureHeight_N;
        }

        public long getApertureHeight_D() {
            return this.apertureHeight_D;
        }

        public long getHorizOff_N() {
            return this.horizOff_N;
        }

        public long getHorizOff_D() {
            return this.horizOff_D;
        }

        public long getVertOff_N() {
            return this.vertOff_N;
        }

        public long getVertOff_D() {
            return this.vertOff_D;
        }

        @Override
        public void dumpData(@Nonnull DataDump dump) {
            super.dumpData(dump);
            dump.write("apertureWidth_N", this.apertureWidth_N).write("apertureWidth_D", this.apertureWidth_D).write("apertureHeight_N", this.apertureHeight_N).write("apertureHeight_D", this.apertureHeight_D).write("horizOff_N", this.horizOff_N).write("horizOff_D", this.horizOff_D).write("vertOff_N", this.vertOff_N).write("vertOff_D", this.vertOff_D);
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("apertureWidth_N", this.apertureWidth_N + ""));
            l.add(new KeyValuePair("apertureWidth_D", this.apertureWidth_D + ""));
            l.add(new KeyValuePair("apertureHeight_N", this.apertureHeight_N + ""));
            l.add(new KeyValuePair("apertureHeight_D", this.apertureHeight_D + ""));
            l.add(new KeyValuePair("horizOff_N", this.horizOff_N + ""));
            l.add(new KeyValuePair("horizOff_D", this.horizOff_D + ""));
            l.add(new KeyValuePair("vertOff_N", this.vertOff_N + ""));
            l.add(new KeyValuePair("vertOff_D", this.vertOff_D + ""));
            return l;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            clapSampleDescriptionExtension that = (clapSampleDescriptionExtension)o;
            if (this.apertureWidth_N != that.apertureWidth_N) {
                return false;
            }
            if (this.apertureWidth_D != that.apertureWidth_D) {
                return false;
            }
            if (this.apertureHeight_N != that.apertureHeight_N) {
                return false;
            }
            if (this.apertureHeight_D != that.apertureHeight_D) {
                return false;
            }
            if (this.horizOff_N != that.horizOff_N) {
                return false;
            }
            if (this.horizOff_D != that.horizOff_D) {
                return false;
            }
            if (this.vertOff_N != that.vertOff_N) {
                return false;
            }
            return this.vertOff_D == that.vertOff_D;
        }

        public int hashCode() {
            int result = (int)(this.apertureWidth_N ^ this.apertureWidth_N >>> 32);
            result = 31 * result + (int)(this.apertureWidth_D ^ this.apertureWidth_D >>> 32);
            result = 31 * result + (int)(this.apertureHeight_N ^ this.apertureHeight_N >>> 32);
            result = 31 * result + (int)(this.apertureHeight_D ^ this.apertureHeight_D >>> 32);
            result = 31 * result + (int)(this.horizOff_N ^ this.horizOff_N >>> 32);
            result = 31 * result + (int)(this.horizOff_D ^ this.horizOff_D >>> 32);
            result = 31 * result + (int)(this.vertOff_N ^ this.vertOff_N >>> 32);
            result = 31 * result + (int)(this.vertOff_D ^ this.vertOff_D >>> 32);
            return result;
        }
    }

    public class fielSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        int fieldCount;
        int fieldOrdering;

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            this.fieldCount = BitstreamReader.readU8(movieFile, parentMaxOffset);
            this.fieldOrdering = BitstreamReader.readU8(movieFile, parentMaxOffset);
        }

        @Override
        public void dumpData(@Nonnull DataDump dump) {
            super.dumpData(dump);
            dump.write("fieldCount", this.fieldCount).write("fieldOrdering", this.fieldOrdering);
        }

        @Override
        public String toString() {
            return "[" + this.getExtensionType() + "] fieldCount=" + this.fieldCount + "; fieldOrdering=" + this.fieldOrdering;
        }

        public int getFieldCount() {
            return this.fieldCount;
        }

        public int getFieldOrdering() {
            return this.fieldOrdering;
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("fieldCount", this.fieldCount + ""));
            l.add(new KeyValuePair("fieldOrdering", this.fieldOrdering + ""));
            return l;
        }

        public int hashCode() {
            return 31 * this.fieldCount + this.fieldOrdering;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            fielSampleDescriptionExtension that = (fielSampleDescriptionExtension)o;
            if (this.fieldCount != that.fieldCount) {
                return false;
            }
            return this.fieldOrdering == that.fieldOrdering;
        }
    }

    public class clliSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        int maxContentLightLevel;
        int maxFrameAverageLightLevel;

        @Override
        public void dumpData(@Nonnull DataDump dump) {
            super.dumpData(dump);
            dump.write("maxContentLightLeveL", this.maxContentLightLevel).write("maxFrameAverageLightLeveL", this.maxFrameAverageLightLevel);
        }

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            this.maxContentLightLevel = BitstreamReader.readU8(movieFile, parentMaxOffset);
            this.maxFrameAverageLightLevel = BitstreamReader.readU8(movieFile, parentMaxOffset);
        }

        @Override
        public String toString() {
            return "[" + this.getExtensionType() + "] maxContentLightLevel=" + this.maxContentLightLevel + "; maxFrameAverageLightLevel=" + this.maxFrameAverageLightLevel;
        }

        public int getMaxContentLightLevel() {
            return this.maxContentLightLevel;
        }

        public int getMaxFrameAverageLightLevel() {
            return this.maxFrameAverageLightLevel;
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("maxContentLightLevel", this.maxContentLightLevel + ""));
            l.add(new KeyValuePair("maxFrameAverageLightLevel", this.maxFrameAverageLightLevel + ""));
            return l;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            clliSampleDescriptionExtension that = (clliSampleDescriptionExtension)o;
            if (this.maxContentLightLevel != that.maxContentLightLevel) {
                return false;
            }
            return this.maxFrameAverageLightLevel == that.maxFrameAverageLightLevel;
        }

        public int hashCode() {
            int result = this.maxContentLightLevel;
            result = 31 * result + this.maxFrameAverageLightLevel;
            return result;
        }
    }

    public class mdcvSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        int[] displayPrimaryX = new int[3];
        int[] displayPrimaryY = new int[3];
        int whitePointX;
        int whitePointY;
        long maxMasteringDisplayLuminance;
        long minMasteringDisplayLuminance;

        @Override
        public void dumpData(@Nonnull DataDump dump) {
            super.dumpData(dump);
            dump.write("greenPrimaryX", this.getGreenPrimaryX()).write("greenPrimaryY", this.getGreenPrimaryY()).write("bluePrimaryX", this.getBluePrimaryX()).write("bluePrimaryY", this.getBluePrimaryY()).write("redPrimaryX", this.getRedPrimaryX()).write("redPrimaryY", this.getRedPrimaryY()).write("whitePointX", this.whitePointX).write("whitePointY", this.whitePointY).write("maxMasteringDisplayLuminance", this.maxMasteringDisplayLuminance).write("minMasteringDisplayLuminance", this.minMasteringDisplayLuminance);
        }

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            for (int i = 0; i < 3; ++i) {
                this.displayPrimaryX[i] = BitstreamReader.readU16(movieFile, parentMaxOffset);
                this.displayPrimaryY[i] = BitstreamReader.readU16(movieFile, parentMaxOffset);
            }
            this.whitePointX = BitstreamReader.readU16(movieFile, parentMaxOffset);
            this.whitePointY = BitstreamReader.readU16(movieFile, parentMaxOffset);
            this.maxMasteringDisplayLuminance = BitstreamReader.readU32(movieFile, parentMaxOffset);
            this.minMasteringDisplayLuminance = BitstreamReader.readU32(movieFile, parentMaxOffset);
        }

        @Override
        public String toString() {
            return "[greenPrimaryX=" + this.getGreenPrimaryX() + "; greenPrimaryY=" + this.getGreenPrimaryY() + "bluePrimaryX=" + this.getBluePrimaryX() + "; bluePrimaryY=" + this.getBluePrimaryY() + "redPrimaryX=" + this.getRedPrimaryX() + "; redPrimaryY=" + this.getRedPrimaryY() + "whitePointX=" + this.whitePointX + "; whitePointY=" + this.whitePointY + "maxMasteringDisplayLuminance=" + this.maxMasteringDisplayLuminance + "minMasteringDisplayLuminance=" + this.minMasteringDisplayLuminance;
        }

        public int getGreenPrimaryX() {
            return this.displayPrimaryX[0];
        }

        public int getGreenPrimaryY() {
            return this.displayPrimaryY[0];
        }

        public int getBluePrimaryX() {
            return this.displayPrimaryX[1];
        }

        public int getBluePrimaryY() {
            return this.displayPrimaryY[1];
        }

        public int getRedPrimaryX() {
            return this.displayPrimaryX[2];
        }

        public int getRedPrimaryY() {
            return this.displayPrimaryY[2];
        }

        public int getWhitePointX() {
            return this.whitePointX;
        }

        public int getWhitePointY() {
            return this.whitePointY;
        }

        public long getMaxMasteringDisplayLuminance() {
            return this.maxMasteringDisplayLuminance;
        }

        public long getMinMasteringDisplayLuminance() {
            return this.minMasteringDisplayLuminance;
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("greenPrimaryX", this.getGreenPrimaryX() + ""));
            l.add(new KeyValuePair("greenPrimaryY", this.getGreenPrimaryY() + ""));
            l.add(new KeyValuePair("bluePrimaryX", this.getBluePrimaryX() + ""));
            l.add(new KeyValuePair("bluePrimaryY", this.getBluePrimaryY() + ""));
            l.add(new KeyValuePair("redPrimaryX", this.getRedPrimaryX() + ""));
            l.add(new KeyValuePair("redPrimaryY", this.getRedPrimaryX() + ""));
            l.add(new KeyValuePair("whitePointX", this.whitePointX + ""));
            l.add(new KeyValuePair("whitePointY", this.whitePointY + ""));
            l.add(new KeyValuePair("maxMasteringDisplayLuminance", this.maxMasteringDisplayLuminance + ""));
            l.add(new KeyValuePair("minMasteringDisplayLuminance", this.minMasteringDisplayLuminance + ""));
            return l;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            mdcvSampleDescriptionExtension that = (mdcvSampleDescriptionExtension)o;
            for (int i = 0; i < 3; ++i) {
                if (this.displayPrimaryX[i] != that.displayPrimaryX[i]) {
                    return false;
                }
                if (this.displayPrimaryY[i] == that.displayPrimaryY[i]) continue;
                return false;
            }
            if (this.whitePointX != that.whitePointX) {
                return false;
            }
            if (this.whitePointY != that.whitePointY) {
                return false;
            }
            if (this.maxMasteringDisplayLuminance != that.maxMasteringDisplayLuminance) {
                return false;
            }
            return this.minMasteringDisplayLuminance == that.minMasteringDisplayLuminance;
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.displayPrimaryX);
            result = 31 * result + Arrays.hashCode(this.displayPrimaryY);
            result = 31 * result + this.whitePointX;
            result = 31 * result + this.whitePointY;
            result = 31 * result + (int)(this.maxMasteringDisplayLuminance ^ this.maxMasteringDisplayLuminance >>> 32);
            result = 31 * result + (int)(this.minMasteringDisplayLuminance ^ this.minMasteringDisplayLuminance >>> 32);
            return result;
        }
    }

    public class colrSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        String colorParameterType;
        int primariesIndex;
        int transferFunctionIndex;
        int matrixIndex;

        @Override
        public void dumpData(@Nonnull DataDump dump) {
            super.dumpData(dump);
            dump.write("colorParameterType", this.colorParameterType).write("primariesIndex", this.primariesIndex).write("transferFunctionIndex", this.transferFunctionIndex).write("matrixIndex", this.matrixIndex);
        }

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            this.colorParameterType = BitstreamReader.readFourCC(movieFile, parentMaxOffset);
            this.primariesIndex = BitstreamReader.readU16(movieFile, parentMaxOffset);
            this.transferFunctionIndex = BitstreamReader.readU16(movieFile, parentMaxOffset);
            this.matrixIndex = BitstreamReader.readU16(movieFile, parentMaxOffset);
        }

        @Override
        public String toString() {
            return "[" + this.getExtensionType() + "] colorParameterType=" + this.colorParameterType + "; primariesIndex=" + this.primariesIndex + "; transferFunctionIndex=" + this.transferFunctionIndex + "; matrixIndex=" + this.matrixIndex;
        }

        public String getColorParameterType() {
            return this.colorParameterType;
        }

        public int getPrimariesIndex() {
            return this.primariesIndex;
        }

        public int getTransferFunctionIndex() {
            return this.transferFunctionIndex;
        }

        public int getMatrixIndex() {
            return this.matrixIndex;
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("colorParameterType", this.colorParameterType));
            l.add(new KeyValuePair("primariesIndex", this.primariesIndex + ""));
            l.add(new KeyValuePair("transferFunctionIndex", this.transferFunctionIndex + ""));
            l.add(new KeyValuePair("matrixIndex", this.matrixIndex + ""));
            return l;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            colrSampleDescriptionExtension that = (colrSampleDescriptionExtension)o;
            if (this.primariesIndex != that.primariesIndex) {
                return false;
            }
            if (this.transferFunctionIndex != that.transferFunctionIndex) {
                return false;
            }
            if (this.matrixIndex != that.matrixIndex) {
                return false;
            }
            return this.colorParameterType.equals(that.colorParameterType);
        }

        public int hashCode() {
            int result = this.colorParameterType.hashCode();
            result = 31 * result + this.primariesIndex;
            result = 31 * result + this.transferFunctionIndex;
            result = 31 * result + this.matrixIndex;
            return result;
        }
    }

    public class paspSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        long hSpacing;
        long vSpacing;

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            this.hSpacing = BitstreamReader.readU32(movieFile, parentMaxOffset);
            this.vSpacing = BitstreamReader.readU32(movieFile, parentMaxOffset);
            if (this.hSpacing <= 0L && this.vSpacing == 0L) {
                this.hSpacing = 1L;
                this.vSpacing = 1L;
            }
        }

        @Override
        public void dumpData(@Nonnull DataDump dump) {
            super.dumpData(dump);
            dump.write("hSpacing", this.hSpacing).write("vSpacing", this.vSpacing);
        }

        @Override
        public String toString() {
            return "[" + this.getExtensionType() + "] hSpacing=" + this.hSpacing + "; vSpacing=" + this.vSpacing;
        }

        public int hashCode() {
            return (int)(this.hSpacing ^ this.hSpacing >>> 32) * 3 + (int)(this.vSpacing ^ this.vSpacing >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj instanceof paspSampleDescriptionExtension) {
                paspSampleDescriptionExtension comp = (paspSampleDescriptionExtension)obj;
                return comp.hSpacing == this.hSpacing && comp.vSpacing == this.vSpacing;
            }
            return false;
        }

        public long getHSpacing() {
            return this.hSpacing;
        }

        public long getVSpacing() {
            return this.vSpacing;
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("hSpacing", this.hSpacing + ""));
            l.add(new KeyValuePair("vSpacing", this.vSpacing + ""));
            return l;
        }
    }

    public class gamaSampleDescriptionExtension
    extends SampleDescription.SampleDescriptionExtension {
        float gama;

        @Override
        public void parseSampleDescriptionExtension(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile, long parentMaxOffset) throws IOException, QtFileCorruptException {
            this.gama = BitstreamReader.readFixed32(movieFile, parentMaxOffset);
        }

        @Override
        public String toString() {
            return "[" + this.getExtensionType() + "] gama=" + this.gama;
        }

        public float getGama() {
            return this.gama;
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("gama", this.gama + ""));
            return l;
        }

        @Override
        public void dumpData(@Nonnull DataDump dump) {
            super.dumpData(dump);
            dump.write("gama", Float.valueOf(this.gama));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            gamaSampleDescriptionExtension that = (gamaSampleDescriptionExtension)o;
            return Float.compare(that.gama, this.gama) == 0;
        }

        public int hashCode() {
            return this.gama != 0.0f ? Float.floatToIntBits(this.gama) : 0;
        }
    }
}

